// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists connection invitations for the partner account, with optional filtering
// by status, type, and other criteria.
func (c *Client) ListConnectionInvitations(ctx context.Context, params *ListConnectionInvitationsInput, optFns ...func(*Options)) (*ListConnectionInvitationsOutput, error) {
	if params == nil {
		params = &ListConnectionInvitationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConnectionInvitations", params, optFns, c.addOperationListConnectionInvitationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConnectionInvitationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConnectionInvitationsInput struct {

	// The catalog identifier for the partner account.
	//
	// This member is required.
	Catalog *string

	// Filter results by connection type (e.g., reseller, distributor, technology
	// partner).
	ConnectionType types.ConnectionType

	// The maximum number of connection invitations to return in a single response.
	MaxResults *int32

	// The token for retrieving the next page of results in paginated responses.
	NextToken *string

	// Filter results by specific participant identifiers.
	OtherParticipantIdentifiers []string

	// Filter results by participant type (inviter or invitee).
	ParticipantType types.ParticipantType

	// Filter results by invitation status (pending, accepted, rejected, canceled,
	// expired).
	Status types.InvitationStatus

	noSmithyDocumentSerde
}

type ListConnectionInvitationsOutput struct {

	// A list of connection invitation summaries matching the specified criteria.
	//
	// This member is required.
	ConnectionInvitationSummaries []types.ConnectionInvitationSummary

	// The token for retrieving the next page of results if more results are available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConnectionInvitationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListConnectionInvitations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListConnectionInvitations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConnectionInvitations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListConnectionInvitationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConnectionInvitations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListConnectionInvitationsPaginatorOptions is the paginator options for
// ListConnectionInvitations
type ListConnectionInvitationsPaginatorOptions struct {
	// The maximum number of connection invitations to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConnectionInvitationsPaginator is a paginator for ListConnectionInvitations
type ListConnectionInvitationsPaginator struct {
	options   ListConnectionInvitationsPaginatorOptions
	client    ListConnectionInvitationsAPIClient
	params    *ListConnectionInvitationsInput
	nextToken *string
	firstPage bool
}

// NewListConnectionInvitationsPaginator returns a new
// ListConnectionInvitationsPaginator
func NewListConnectionInvitationsPaginator(client ListConnectionInvitationsAPIClient, params *ListConnectionInvitationsInput, optFns ...func(*ListConnectionInvitationsPaginatorOptions)) *ListConnectionInvitationsPaginator {
	if params == nil {
		params = &ListConnectionInvitationsInput{}
	}

	options := ListConnectionInvitationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConnectionInvitationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConnectionInvitationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConnectionInvitations page.
func (p *ListConnectionInvitationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConnectionInvitationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConnectionInvitations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConnectionInvitationsAPIClient is a client that implements the
// ListConnectionInvitations operation.
type ListConnectionInvitationsAPIClient interface {
	ListConnectionInvitations(context.Context, *ListConnectionInvitationsInput, ...func(*Options)) (*ListConnectionInvitationsOutput, error)
}

var _ ListConnectionInvitationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConnectionInvitations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConnectionInvitations",
	}
}
