// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/document"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new benefit application for a partner to request access to AWS
// benefits and programs.
func (c *Client) CreateBenefitApplication(ctx context.Context, params *CreateBenefitApplicationInput, optFns ...func(*Options)) (*CreateBenefitApplicationOutput, error) {
	if params == nil {
		params = &CreateBenefitApplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateBenefitApplication", params, optFns, c.addOperationCreateBenefitApplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateBenefitApplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateBenefitApplicationInput struct {

	// The unique identifier of the benefit being requested in this application.
	//
	// This member is required.
	BenefitIdentifier *string

	// The catalog identifier that specifies which benefit catalog to create the
	// application in.
	//
	// This member is required.
	Catalog *string

	// A unique, case-sensitive identifier to ensure idempotent processing of the
	// creation request.
	//
	// This member is required.
	ClientToken *string

	// AWS resources that are associated with this benefit application.
	AssociatedResources []string

	// Detailed information and requirements specific to the benefit being requested.
	BenefitApplicationDetails document.Interface

	// A detailed description of the benefit application and its intended use.
	Description *string

	// Supporting documents and files attached to the benefit application.
	FileDetails []types.FileInput

	// The types of fulfillment requested for this benefit application (e.g., credits,
	// access, disbursement).
	FulfillmentTypes []types.FulfillmentType

	// A human-readable name for the benefit application.
	Name *string

	// Contact information for partner representatives responsible for this benefit
	// application.
	PartnerContacts []types.Contact

	// Key-value pairs to categorize and organize the benefit application.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateBenefitApplicationOutput struct {

	// The Amazon Resource Name (ARN) of the newly created benefit application.
	Arn *string

	// The unique identifier assigned to the newly created benefit application.
	Id *string

	// The initial revision number of the newly created benefit application.
	Revision *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateBenefitApplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateBenefitApplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateBenefitApplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateBenefitApplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateBenefitApplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateBenefitApplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateBenefitApplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateBenefitApplication",
	}
}
