// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralchannel

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralchannel/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists program management accounts based on specified criteria.
func (c *Client) ListProgramManagementAccounts(ctx context.Context, params *ListProgramManagementAccountsInput, optFns ...func(*Options)) (*ListProgramManagementAccountsOutput, error) {
	if params == nil {
		params = &ListProgramManagementAccountsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListProgramManagementAccounts", params, optFns, c.addOperationListProgramManagementAccountsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListProgramManagementAccountsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListProgramManagementAccountsInput struct {

	// The catalog identifier to filter accounts.
	//
	// This member is required.
	Catalog *string

	// Filter by AWS account IDs.
	AccountIds []string

	// Filter by display names.
	DisplayNames []string

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// Token for retrieving the next page of results.
	NextToken *string

	// Filter by program types.
	Programs []types.Program

	// Sorting options for the results.
	Sort *types.ListProgramManagementAccountsSortBase

	// Filter by program management account statuses.
	Statuses []types.ProgramManagementAccountStatus

	noSmithyDocumentSerde
}

type ListProgramManagementAccountsOutput struct {

	// List of program management accounts matching the criteria.
	Items []types.ProgramManagementAccountSummary

	// Token for retrieving the next page of results, if available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListProgramManagementAccountsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListProgramManagementAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListProgramManagementAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListProgramManagementAccounts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListProgramManagementAccountsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListProgramManagementAccounts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListProgramManagementAccountsPaginatorOptions is the paginator options for
// ListProgramManagementAccounts
type ListProgramManagementAccountsPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListProgramManagementAccountsPaginator is a paginator for
// ListProgramManagementAccounts
type ListProgramManagementAccountsPaginator struct {
	options   ListProgramManagementAccountsPaginatorOptions
	client    ListProgramManagementAccountsAPIClient
	params    *ListProgramManagementAccountsInput
	nextToken *string
	firstPage bool
}

// NewListProgramManagementAccountsPaginator returns a new
// ListProgramManagementAccountsPaginator
func NewListProgramManagementAccountsPaginator(client ListProgramManagementAccountsAPIClient, params *ListProgramManagementAccountsInput, optFns ...func(*ListProgramManagementAccountsPaginatorOptions)) *ListProgramManagementAccountsPaginator {
	if params == nil {
		params = &ListProgramManagementAccountsInput{}
	}

	options := ListProgramManagementAccountsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListProgramManagementAccountsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListProgramManagementAccountsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListProgramManagementAccounts page.
func (p *ListProgramManagementAccountsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListProgramManagementAccountsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListProgramManagementAccounts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListProgramManagementAccountsAPIClient is a client that implements the
// ListProgramManagementAccounts operation.
type ListProgramManagementAccountsAPIClient interface {
	ListProgramManagementAccounts(context.Context, *ListProgramManagementAccountsInput, ...func(*Options)) (*ListProgramManagementAccountsOutput, error)
}

var _ ListProgramManagementAccountsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListProgramManagementAccounts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListProgramManagementAccounts",
	}
}
