// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new context within an existing engagement. This action allows you to
// add contextual information such as customer projects or documents to an
// engagement, providing additional details that help facilitate collaboration
// between engagement members.
func (c *Client) CreateEngagementContext(ctx context.Context, params *CreateEngagementContextInput, optFns ...func(*Options)) (*CreateEngagementContextOutput, error) {
	if params == nil {
		params = &CreateEngagementContextInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEngagementContext", params, optFns, c.addOperationCreateEngagementContextMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEngagementContextOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEngagementContextInput struct {

	// Specifies the catalog associated with the engagement context request. This
	// field takes a string value from a predefined list: AWS or Sandbox . The catalog
	// determines which environment the engagement context is created in. Use AWS to
	// create contexts in the production environment, and Sandbox for testing in
	// secure, isolated environments.
	//
	// This member is required.
	Catalog *string

	// A unique, case-sensitive identifier provided by the client to ensure that the
	// request is handled exactly once. This token helps prevent duplicate context
	// creations and must not exceed sixty-four alphanumeric characters. Use a UUID or
	// other unique string to ensure idempotency.
	//
	// This member is required.
	ClientToken *string

	// The unique identifier of the Engagement for which the context is being created.
	// This parameter ensures the context is associated with the correct engagement and
	// provides the necessary linkage between the engagement and its contextual
	// information.
	//
	// This member is required.
	EngagementIdentifier *string

	// Represents the payload of an Engagement context. The structure of this payload
	// varies based on the context type specified in the EngagementContextDetails.
	//
	// This member is required.
	Payload types.EngagementContextPayload

	// Specifies the type of context being created for the engagement. This field
	// determines the structure and content of the context payload. Valid values
	// include CustomerProject for customer project-related contexts. The type field
	// ensures that the context is properly categorized and processed according to its
	// intended purpose.
	//
	// This member is required.
	Type types.EngagementContextType

	noSmithyDocumentSerde
}

type CreateEngagementContextOutput struct {

	// The unique identifier assigned to the newly created engagement context. This ID
	// can be used to reference the specific context within the engagement for future
	// operations.
	ContextId *string

	// The Amazon Resource Name (ARN) of the engagement to which the context was
	// added. This globally unique identifier can be used for cross-service references
	// and IAM policies.
	EngagementArn *string

	// The unique identifier of the engagement to which the context was added. This ID
	// confirms the successful association of the context with the specified
	// engagement.
	EngagementId *string

	// The timestamp indicating when the engagement was last modified as a result of
	// adding the context, in ISO 8601 format (UTC). Example: "2023-05-01T20:37:46Z".
	EngagementLastModifiedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEngagementContextMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateEngagementContext{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateEngagementContext{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEngagementContext"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateEngagementContextMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEngagementContextValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEngagementContext(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateEngagementContext struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateEngagementContext) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateEngagementContext) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateEngagementContextInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateEngagementContextInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateEngagementContextMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateEngagementContext{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateEngagementContext(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEngagementContext",
	}
}
