// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Similar to StartEngagementByAcceptingInvitationTask , this action is
// asynchronous and performs multiple steps before completion. This action
// orchestrates a comprehensive workflow that combines multiple API operations into
// a single task to create and initiate an engagement from an existing opportunity.
// It automatically executes a sequence of operations including GetOpportunity ,
// CreateEngagement (if it doesn't exist), CreateResourceSnapshot ,
// CreateResourceSnapshotJob , CreateEngagementInvitation (if not already
// invited/accepted), and SubmitOpportunity .
func (c *Client) StartEngagementFromOpportunityTask(ctx context.Context, params *StartEngagementFromOpportunityTaskInput, optFns ...func(*Options)) (*StartEngagementFromOpportunityTaskOutput, error) {
	if params == nil {
		params = &StartEngagementFromOpportunityTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartEngagementFromOpportunityTask", params, optFns, c.addOperationStartEngagementFromOpportunityTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartEngagementFromOpportunityTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartEngagementFromOpportunityTaskInput struct {

	// Indicates the level of AWS involvement in the opportunity. This field helps
	// track AWS participation throughout the engagement, such as providing technical
	// support, deal assistance, and sales support.
	//
	// This member is required.
	AwsSubmission *types.AwsSubmission

	// Specifies the catalog in which the engagement is tracked. Acceptable values
	// include AWS for production and Sandbox for testing environments.
	//
	// This member is required.
	Catalog *string

	// A unique token provided by the client to help ensure the idempotency of the
	// request. It helps prevent the same task from being performed multiple times.
	//
	// This member is required.
	ClientToken *string

	// The unique identifier of the opportunity from which the engagement task is to
	// be initiated. This helps ensure that the task is applied to the correct
	// opportunity.
	//
	// This member is required.
	Identifier *string

	// A map of the key-value pairs of the tag or tags to assign.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type StartEngagementFromOpportunityTaskOutput struct {

	// The identifier of the newly created Engagement. Only populated if TaskStatus is
	// COMPLETE.
	EngagementId *string

	// The identifier of the new Engagement invitation. Only populated if TaskStatus
	// is COMPLETE.
	EngagementInvitationId *string

	// If the task fails, this field contains a detailed message describing the
	// failure and possible recovery steps.
	Message *string

	// Returns the original opportunity identifier passed in the request, which is the
	// unique identifier for the opportunity created in the partner’s system.
	OpportunityId *string

	// Indicates the reason for task failure using an enumerated code.
	ReasonCode types.ReasonCode

	// The identifier of the resource snapshot job created to add the opportunity
	// resource snapshot to the Engagement. Only populated if TaskStatus is COMPLETE
	ResourceSnapshotJobId *string

	// The timestamp indicating when the task was initiated. The format follows RFC
	// 3339 section 5.6.
	StartTime *time.Time

	// The Amazon Resource Name (ARN) of the task, used for tracking and managing the
	// task within AWS.
	TaskArn *string

	// The unique identifier of the task, used to track the task’s progress. This
	// value follows a specific pattern: ^oit-[0-9a-z]{13}$ .
	TaskId *string

	// Indicates the current status of the task. Valid values include IN_PROGRESS ,
	// COMPLETE , and FAILED .
	TaskStatus types.TaskStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartEngagementFromOpportunityTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStartEngagementFromOpportunityTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStartEngagementFromOpportunityTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartEngagementFromOpportunityTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartEngagementFromOpportunityTaskMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartEngagementFromOpportunityTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartEngagementFromOpportunityTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartEngagementFromOpportunityTask struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartEngagementFromOpportunityTask) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartEngagementFromOpportunityTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartEngagementFromOpportunityTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartEngagementFromOpportunityTaskInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartEngagementFromOpportunityTaskMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartEngagementFromOpportunityTask{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartEngagementFromOpportunityTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartEngagementFromOpportunityTask",
	}
}
