// Code generated by smithy-go-codegen DO NOT EDIT.

package pcs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pcs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API action isn't intended for you to use.
//
// PCS uses this API action to register the compute nodes it launches in your
// account.
func (c *Client) RegisterComputeNodeGroupInstance(ctx context.Context, params *RegisterComputeNodeGroupInstanceInput, optFns ...func(*Options)) (*RegisterComputeNodeGroupInstanceOutput, error) {
	if params == nil {
		params = &RegisterComputeNodeGroupInstanceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RegisterComputeNodeGroupInstance", params, optFns, c.addOperationRegisterComputeNodeGroupInstanceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RegisterComputeNodeGroupInstanceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RegisterComputeNodeGroupInstanceInput struct {

	// The client-generated token to allow for retries.
	//
	// This member is required.
	BootstrapId *string

	// The name or ID of the cluster to register the compute node group instance in.
	//
	// This member is required.
	ClusterIdentifier *string

	noSmithyDocumentSerde
}

type RegisterComputeNodeGroupInstanceOutput struct {

	// The list of endpoints available for interaction with the scheduler.
	//
	// This member is required.
	Endpoints []types.Endpoint

	// The scheduler node ID for this instance.
	//
	// This member is required.
	NodeID *string

	// For the Slurm scheduler, this is the shared Munge key the scheduler uses to
	// authenticate compute node group instances.
	//
	// This member is required.
	SharedSecret *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRegisterComputeNodeGroupInstanceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpRegisterComputeNodeGroupInstance{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpRegisterComputeNodeGroupInstance{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RegisterComputeNodeGroupInstance"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRegisterComputeNodeGroupInstanceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRegisterComputeNodeGroupInstance(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRegisterComputeNodeGroupInstance(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RegisterComputeNodeGroupInstance",
	}
}
