// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The accounting configuration includes configurable settings for Slurm
// accounting. It's a property of the ClusterSlurmConfiguration object.
type Accounting struct {

	// The default value for mode is STANDARD . A value of STANDARD means Slurm
	// accounting is enabled.
	//
	// This member is required.
	Mode AccountingMode

	// The default value for all purge settings for slurmdbd.conf . For more
	// information, see the [slurmdbd.conf documentation at SchedMD].
	//
	// The default value for defaultPurgeTimeInDays is -1 .
	//
	// A value of -1 means there is no purge time and records persist as long as the
	// cluster exists.
	//
	// 0 isn't a valid value.
	//
	// [slurmdbd.conf documentation at SchedMD]: https://slurm.schedmd.com/slurmdbd.conf.html
	DefaultPurgeTimeInDays *int32

	noSmithyDocumentSerde
}

// The accounting configuration includes configurable settings for Slurm
// accounting. It's a property of the ClusterSlurmConfiguration object.
type AccountingRequest struct {

	// The default value for mode is STANDARD . A value of STANDARD means Slurm
	// accounting is enabled.
	//
	// This member is required.
	Mode AccountingMode

	// The default value for all purge settings for slurmdbd.conf . For more
	// information, see the [slurmdbd.conf documentation at SchedMD].
	//
	// The default value for defaultPurgeTimeInDays is -1 .
	//
	// A value of -1 means there is no purge time and records persist as long as the
	// cluster exists.
	//
	// 0 isn't a valid value.
	//
	// [slurmdbd.conf documentation at SchedMD]: https://slurm.schedmd.com/slurmdbd.conf.html
	DefaultPurgeTimeInDays *int32

	noSmithyDocumentSerde
}

// The cluster resource and configuration.
type Cluster struct {

	// The unique Amazon Resource Name (ARN) of the cluster.
	//
	// This member is required.
	Arn *string

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The generated unique ID of the cluster.
	//
	// This member is required.
	Id *string

	// The date and time the resource was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name that identifies the cluster.
	//
	// This member is required.
	Name *string

	// The networking configuration for the cluster's control plane.
	//
	// This member is required.
	Networking *Networking

	// The cluster management and job scheduling software associated with the cluster.
	//
	// This member is required.
	Scheduler *Scheduler

	// The size of the cluster.
	//
	//   - SMALL : 32 compute nodes and 256 jobs
	//
	//   - MEDIUM : 512 compute nodes and 8192 jobs
	//
	//   - LARGE : 2048 compute nodes and 16,384 jobs
	//
	// This member is required.
	Size Size

	// The provisioning status of the cluster.
	//
	// The provisioning status doesn't indicate the overall health of the cluster.
	//
	// The resource enters the SUSPENDING and SUSPENDED states when the scheduler is
	// beyond end of life and we have suspended the cluster. When in these states, you
	// can't use the cluster. The cluster controller is down and all compute instances
	// are terminated. The resources still count toward your service quotas. You can
	// delete a resource if its status is SUSPENDED . For more information, see [Frequently asked questions about Slurm versions in PCS] in
	// the PCS User Guide.
	//
	// [Frequently asked questions about Slurm versions in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html
	//
	// This member is required.
	Status ClusterStatus

	// The list of endpoints available for interaction with the scheduler.
	Endpoints []Endpoint

	// The list of errors that occurred during cluster provisioning.
	ErrorInfo []ErrorInfo

	// Additional options related to the Slurm scheduler.
	SlurmConfiguration *ClusterSlurmConfiguration

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type ClusterSlurmConfiguration struct {

	// The accounting configuration includes configurable settings for Slurm
	// accounting.
	Accounting *Accounting

	// The shared Slurm key for authentication, also known as the cluster secret.
	AuthKey *SlurmAuthKey

	// The JWT authentication configuration for Slurm REST API access.
	JwtAuth *JwtAuth

	// The time (in seconds) before an idle node is scaled down.
	//
	// Default: 600
	ScaleDownIdleTimeInSeconds *int32

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	// The Slurm REST API configuration for the cluster.
	SlurmRest *SlurmRest

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type ClusterSlurmConfigurationRequest struct {

	// The accounting configuration includes configurable settings for Slurm
	// accounting.
	Accounting *AccountingRequest

	// The time (in seconds) before an idle node is scaled down.
	//
	// Default: 600
	ScaleDownIdleTimeInSeconds *int32

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	// The Slurm REST API configuration for the cluster.
	SlurmRest *SlurmRestRequest

	noSmithyDocumentSerde
}

// The object returned by the ListClusters API action.
type ClusterSummary struct {

	// The unique Amazon Resource Name (ARN) of the cluster.
	//
	// This member is required.
	Arn *string

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The generated unique ID of the cluster.
	//
	// This member is required.
	Id *string

	// The date and time the resource was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name that identifies the cluster.
	//
	// This member is required.
	Name *string

	// The provisioning status of the cluster.
	//
	// The provisioning status doesn't indicate the overall health of the cluster.
	//
	// The resource enters the SUSPENDING and SUSPENDED states when the scheduler is
	// beyond end of life and we have suspended the cluster. When in these states, you
	// can't use the cluster. The cluster controller is down and all compute instances
	// are terminated. The resources still count toward your service quotas. You can
	// delete a resource if its status is SUSPENDED . For more information, see [Frequently asked questions about Slurm versions in PCS] in
	// the PCS User Guide.
	//
	// [Frequently asked questions about Slurm versions in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html
	//
	// This member is required.
	Status ClusterStatus

	noSmithyDocumentSerde
}

// A compute node group associated with a cluster.
type ComputeNodeGroup struct {

	// The unique Amazon Resource Name (ARN) of the compute node group.
	//
	// This member is required.
	Arn *string

	// The ID of the cluster of the compute node group.
	//
	// This member is required.
	ClusterId *string

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// An Amazon EC2 launch template PCS uses to launch compute nodes.
	//
	// This member is required.
	CustomLaunchTemplate *CustomLaunchTemplate

	// The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM
	// role when launching EC2 instances. The role contained in your instance profile
	// must have the pcs:RegisterComputeNodeGroupInstance permission and the role name
	// must start with AWSPCS or must have the path /aws-pcs/ . For more information,
	// see [IAM instance profiles for PCS]in the PCS User Guide.
	//
	// [IAM instance profiles for PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/security-instance-profiles.html
	//
	// This member is required.
	IamInstanceProfileArn *string

	// The generated unique ID of the compute node group.
	//
	// This member is required.
	Id *string

	// A list of EC2 instance configurations that PCS can provision in the compute
	// node group.
	//
	// This member is required.
	InstanceConfigs []InstanceConfig

	// The date and time the resource was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name that identifies the compute node group.
	//
	// This member is required.
	Name *string

	// Specifies the boundaries of the compute node group auto scaling.
	//
	// This member is required.
	ScalingConfiguration *ScalingConfiguration

	// The provisioning status of the compute node group.
	//
	// The provisioning status doesn't indicate the overall health of the compute node
	// group.
	//
	// The resource enters the SUSPENDING and SUSPENDED states when the scheduler is
	// beyond end of life and we have suspended the cluster. When in these states, you
	// can't use the cluster. The cluster controller is down and all compute instances
	// are terminated. The resources still count toward your service quotas. You can
	// delete a resource if its status is SUSPENDED . For more information, see [Frequently asked questions about Slurm versions in PCS] in
	// the PCS User Guide.
	//
	// [Frequently asked questions about Slurm versions in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html
	//
	// This member is required.
	Status ComputeNodeGroupStatus

	// The list of subnet IDs where instances are provisioned by the compute node
	// group. The subnets must be in the same VPC as the cluster.
	//
	// This member is required.
	SubnetIds []string

	// The ID of the Amazon Machine Image (AMI) that PCS uses to launch instances. If
	// not provided, PCS uses the AMI ID specified in the custom launch template.
	AmiId *string

	// The list of errors that occurred during compute node group provisioning.
	ErrorInfo []ErrorInfo

	// Specifies how EC2 instances are purchased on your behalf. PCS supports
	// On-Demand Instances, Spot Instances, and Amazon EC2 Capacity Blocks for ML. For
	// more information, see [Amazon EC2 billing and purchasing options]in the Amazon Elastic Compute Cloud User Guide. For more
	// information about PCS support for Capacity Blocks, see [Using Amazon EC2 Capacity Blocks for ML with PCS]in the PCS User Guide.
	// If you don't provide this option, it defaults to On-Demand.
	//
	// [Using Amazon EC2 Capacity Blocks for ML with PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html
	// [Amazon EC2 billing and purchasing options]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html
	PurchaseOption PurchaseOption

	// Additional options related to the Slurm scheduler.
	SlurmConfiguration *ComputeNodeGroupSlurmConfiguration

	// Additional configuration when you specify SPOT as the purchaseOption for the
	// CreateComputeNodeGroup API action.
	SpotOptions *SpotOptions

	noSmithyDocumentSerde
}

// The compute node group configuration for a queue.
type ComputeNodeGroupConfiguration struct {

	// The compute node group ID for the compute node group configuration.
	ComputeNodeGroupId *string

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type ComputeNodeGroupSlurmConfiguration struct {

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type ComputeNodeGroupSlurmConfigurationRequest struct {

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	noSmithyDocumentSerde
}

// The object returned by the ListComputeNodeGroups API action.
type ComputeNodeGroupSummary struct {

	// The unique Amazon Resource Name (ARN) of the compute node group.
	//
	// This member is required.
	Arn *string

	// The ID of the cluster of the compute node group.
	//
	// This member is required.
	ClusterId *string

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The generated unique ID of the compute node group.
	//
	// This member is required.
	Id *string

	// The date and time the resource was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name that identifies the compute node group.
	//
	// This member is required.
	Name *string

	// The provisioning status of the compute node group.
	//
	// The provisioning status doesn't indicate the overall health of the compute node
	// group.
	//
	// The resource enters the SUSPENDING and SUSPENDED states when the scheduler is
	// beyond end of life and we have suspended the cluster. When in these states, you
	// can't use the cluster. The cluster controller is down and all compute instances
	// are terminated. The resources still count toward your service quotas. You can
	// delete a resource if its status is SUSPENDED . For more information, see [Frequently asked questions about Slurm versions in PCS] in
	// the PCS User Guide.
	//
	// [Frequently asked questions about Slurm versions in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html
	//
	// This member is required.
	Status ComputeNodeGroupStatus

	noSmithyDocumentSerde
}

// An Amazon EC2 launch template PCS uses to launch compute nodes.
type CustomLaunchTemplate struct {

	// The ID of the EC2 launch template to use to provision instances.
	//
	// Example: lt-xxxx
	//
	// This member is required.
	Id *string

	// The version of the EC2 launch template to use to provision instances.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// An endpoint available for interaction with the scheduler.
type Endpoint struct {

	// The endpoint's connection port number.
	//
	// Example: 1234
	//
	// This member is required.
	Port *string

	// For clusters that use IPv4, this is the endpoint's private IP address.
	//
	// Example: 10.1.2.3
	//
	// For clusters configured to use IPv6, this is an empty string.
	//
	// This member is required.
	PrivateIpAddress *string

	// Indicates the type of endpoint running at the specific IP address.
	//
	// This member is required.
	Type EndpointType

	// The endpoint's IPv6 address.
	//
	// Example: 2001:db8::1
	Ipv6Address *string

	// The endpoint's public IP address.
	//
	// Example: 192.0.2.1
	PublicIpAddress *string

	noSmithyDocumentSerde
}

// An error that occurred during resource creation.
type ErrorInfo struct {

	// The short-form error code.
	Code *string

	// The detailed error information.
	Message *string

	noSmithyDocumentSerde
}

// An EC2 instance configuration PCS uses to launch compute nodes.
type InstanceConfig struct {

	// The EC2 instance type that PCS can provision in the compute node group.
	//
	// Example: t2.xlarge
	InstanceType *string

	noSmithyDocumentSerde
}

// The JWT authentication configuration for Slurm REST API access.
type JwtAuth struct {

	// The JWT key for Slurm REST API authentication.
	JwtKey *JwtKey

	noSmithyDocumentSerde
}

// The JWT key stored in AWS Secrets Manager for Slurm REST API authentication.
type JwtKey struct {

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the
	// JWT key.
	//
	// This member is required.
	SecretArn *string

	// The version of the AWS Secrets Manager secret containing the JWT key.
	//
	// This member is required.
	SecretVersion *string

	noSmithyDocumentSerde
}

// The networking configuration for the cluster's control plane.
type Networking struct {

	// The IP address version the cluster uses. The default is IPV4 .
	NetworkType NetworkType

	// The list of security group IDs associated with the Elastic Network Interface
	// (ENI) created in subnets.
	//
	// The following rules are required:
	//
	//   - Inbound rule 1
	//
	//   - Protocol: All
	//
	//   - Ports: All
	//
	//   - Source: Self
	//
	//   - Outbound rule 1
	//
	//   - Protocol: All
	//
	//   - Ports: All
	//
	//   - Destination: 0.0.0.0/0 (IPv4) or ::/0 (IPv6)
	//
	//   - Outbound rule 2
	//
	//   - Protocol: All
	//
	//   - Ports: All
	//
	//   - Destination: Self
	SecurityGroupIds []string

	// The ID of the subnet where PCS creates an Elastic Network Interface (ENI) to
	// enable communication between managed controllers and PCS resources. The subnet
	// must have an available IP address, cannot reside in Outposts, Wavelength, or an
	// Amazon Web Services Local Zone.
	//
	// Example: subnet-abcd1234
	SubnetIds []string

	noSmithyDocumentSerde
}

// The networking configuration for the cluster's control plane.
type NetworkingRequest struct {

	// The IP address version the cluster uses. The default is IPV4 .
	NetworkType NetworkType

	// A list of security group IDs associated with the Elastic Network Interface
	// (ENI) created in subnets.
	SecurityGroupIds []string

	// The list of subnet IDs where PCS creates an Elastic Network Interface (ENI) to
	// enable communication between managed controllers and PCS resources. Subnet IDs
	// have the form subnet-0123456789abcdef0 .
	//
	// Subnets can't be in Outposts, Wavelength or an Amazon Web Services Local Zone.
	//
	// PCS currently supports only 1 subnet in this list.
	SubnetIds []string

	noSmithyDocumentSerde
}

// A queue resource.
type Queue struct {

	// The unique Amazon Resource Name (ARN) of the queue.
	//
	// This member is required.
	Arn *string

	// The ID of the cluster of the queue.
	//
	// This member is required.
	ClusterId *string

	// The list of compute node group configurations associated with the queue. Queues
	// assign jobs to associated compute node groups.
	//
	// This member is required.
	ComputeNodeGroupConfigurations []ComputeNodeGroupConfiguration

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The generated unique ID of the queue.
	//
	// This member is required.
	Id *string

	// The date and time the resource was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name that identifies the queue.
	//
	// This member is required.
	Name *string

	// The provisioning status of the queue.
	//
	// The provisioning status doesn't indicate the overall health of the queue.
	//
	// The resource enters the SUSPENDING and SUSPENDED states when the scheduler is
	// beyond end of life and we have suspended the cluster. When in these states, you
	// can't use the cluster. The cluster controller is down and all compute instances
	// are terminated. The resources still count toward your service quotas. You can
	// delete a resource if its status is SUSPENDED . For more information, see [Frequently asked questions about Slurm versions in PCS] in
	// the PCS User Guide.
	//
	// [Frequently asked questions about Slurm versions in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html
	//
	// This member is required.
	Status QueueStatus

	// The list of errors that occurred during queue provisioning.
	ErrorInfo []ErrorInfo

	// Additional options related to the Slurm scheduler.
	SlurmConfiguration *QueueSlurmConfiguration

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type QueueSlurmConfiguration struct {

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type QueueSlurmConfigurationRequest struct {

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	noSmithyDocumentSerde
}

// The object returned by the ListQueues API action.
type QueueSummary struct {

	// The unique Amazon Resource Name (ARN) of the queue.
	//
	// This member is required.
	Arn *string

	// The ID of the cluster of the queue.
	//
	// This member is required.
	ClusterId *string

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The generated unique ID of the queue.
	//
	// This member is required.
	Id *string

	// The date and time the resource was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name that identifies the queue.
	//
	// This member is required.
	Name *string

	// The provisioning status of the queue.
	//
	// The provisioning status doesn't indicate the overall health of the queue.
	//
	// The resource enters the SUSPENDING and SUSPENDED states when the scheduler is
	// beyond end of life and we have suspended the cluster. When in these states, you
	// can't use the cluster. The cluster controller is down and all compute instances
	// are terminated. The resources still count toward your service quotas. You can
	// delete a resource if its status is SUSPENDED . For more information, see [Frequently asked questions about Slurm versions in PCS] in
	// the PCS User Guide.
	//
	// [Frequently asked questions about Slurm versions in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html
	//
	// This member is required.
	Status QueueStatus

	noSmithyDocumentSerde
}

// Specifies the boundaries of the compute node group auto scaling.
type ScalingConfiguration struct {

	// The upper bound of the number of instances allowed in the compute fleet.
	//
	// This member is required.
	MaxInstanceCount int32

	// The lower bound of the number of instances allowed in the compute fleet.
	//
	// This member is required.
	MinInstanceCount int32

	noSmithyDocumentSerde
}

// Specifies the boundaries of the compute node group auto scaling.
type ScalingConfigurationRequest struct {

	// The upper bound of the number of instances allowed in the compute fleet.
	//
	// This member is required.
	MaxInstanceCount int32

	// The lower bound of the number of instances allowed in the compute fleet.
	//
	// This member is required.
	MinInstanceCount int32

	noSmithyDocumentSerde
}

// The cluster management and job scheduling software associated with the cluster.
type Scheduler struct {

	// The software PCS uses to manage cluster scaling and job scheduling.
	//
	// This member is required.
	Type SchedulerType

	// The version of the specified scheduling software that PCS uses to manage
	// cluster scaling and job scheduling. For more information, see [Slurm versions in PCS]in the PCS User
	// Guide.
	//
	// Valid Values: 23.11 | 24.05 | 24.11
	//
	// [Slurm versions in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions.html
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// The cluster management and job scheduling software associated with the cluster.
type SchedulerRequest struct {

	// The software PCS uses to manage cluster scaling and job scheduling.
	//
	// This member is required.
	Type SchedulerType

	// The version of the specified scheduling software that PCS uses to manage
	// cluster scaling and job scheduling. For more information, see [Slurm versions in PCS]in the PCS User
	// Guide.
	//
	// Valid Values: 23.11 | 24.05 | 24.11
	//
	// [Slurm versions in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions.html
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// The shared Slurm key for authentication, also known as the cluster secret.
type SlurmAuthKey struct {

	// The Amazon Resource Name (ARN) of the shared Slurm key.
	//
	// This member is required.
	SecretArn *string

	// The version of the shared Slurm key.
	//
	// This member is required.
	SecretVersion *string

	noSmithyDocumentSerde
}

// Additional settings that directly map to Slurm settings.
//
// PCS supports a subset of Slurm settings. For more information, see [Configuring custom Slurm settings in PCS] in the PCS
// User Guide.
//
// [Configuring custom Slurm settings in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-custom-settings.html
type SlurmCustomSetting struct {

	// PCS supports custom Slurm settings for clusters, compute node groups, and
	// queues. For more information, see [Configuring custom Slurm settings in PCS]in the PCS User Guide.
	//
	// [Configuring custom Slurm settings in PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/slurm-custom-settings.html
	//
	// This member is required.
	ParameterName *string

	// The values for the configured Slurm settings.
	//
	// This member is required.
	ParameterValue *string

	noSmithyDocumentSerde
}

// The Slurm REST API configuration includes settings for enabling and configuring
// the Slurm REST API. It's a property of the ClusterSlurmConfiguration object.
type SlurmRest struct {

	// The default value for mode is STANDARD . A value of STANDARD means the Slurm
	// REST API is enabled.
	//
	// This member is required.
	Mode SlurmRestMode

	noSmithyDocumentSerde
}

// The Slurm REST API configuration includes settings for enabling and configuring
// the Slurm REST API. It's a property of the ClusterSlurmConfiguration object.
type SlurmRestRequest struct {

	// The default value for mode is STANDARD . A value of STANDARD means the Slurm
	// REST API is enabled.
	//
	// This member is required.
	Mode SlurmRestMode

	noSmithyDocumentSerde
}

// Additional configuration when you specify SPOT as the purchaseOption for the
// CreateComputeNodeGroup API action.
type SpotOptions struct {

	// The Amazon EC2 allocation strategy PCS uses to provision EC2 instances. PCS
	// supports lowest price, capacity optimized, and price capacity optimized. For
	// more information, see [Use allocation strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity]in the Amazon Elastic Compute Cloud User Guide. If you
	// don't provide this option, it defaults to price capacity optimized.
	//
	// [Use allocation strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html
	AllocationStrategy SpotAllocationStrategy

	noSmithyDocumentSerde
}

// The accounting configuration includes configurable settings for Slurm
// accounting.
type UpdateAccountingRequest struct {

	// The default value for all purge settings for slurmdbd.conf . For more
	// information, see the [slurmdbd.conf documentation at SchedMD].
	//
	// The default value for defaultPurgeTimeInDays is -1 .
	//
	// A value of -1 means there is no purge time and records persist as long as the
	// cluster exists.
	//
	// 0 isn't a valid value.
	//
	// [slurmdbd.conf documentation at SchedMD]: https://slurm.schedmd.com/slurmdbd.conf.html
	DefaultPurgeTimeInDays *int32

	// The default value for mode is STANDARD . A value of STANDARD means Slurm
	// accounting is enabled.
	Mode AccountingMode

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type UpdateClusterSlurmConfigurationRequest struct {

	// The accounting configuration includes configurable settings for Slurm
	// accounting.
	Accounting *UpdateAccountingRequest

	// The time (in seconds) before an idle node is scaled down.
	//
	// Default: 600
	ScaleDownIdleTimeInSeconds *int32

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	// The Slurm REST API configuration for the cluster.
	SlurmRest *UpdateSlurmRestRequest

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type UpdateComputeNodeGroupSlurmConfigurationRequest struct {

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	noSmithyDocumentSerde
}

// Additional options related to the Slurm scheduler.
type UpdateQueueSlurmConfigurationRequest struct {

	// Additional Slurm-specific configuration that directly maps to Slurm settings.
	SlurmCustomSettings []SlurmCustomSetting

	noSmithyDocumentSerde
}

// The Slurm REST API configuration includes settings for enabling and configuring
// the Slurm REST API.
type UpdateSlurmRestRequest struct {

	// The default value for mode is STANDARD . A value of STANDARD means the Slurm
	// REST API is enabled.
	Mode SlurmRestMode

	noSmithyDocumentSerde
}

// Stores information about a field in a request that caused an exception.
type ValidationExceptionField struct {

	// The message body of the exception.
	//
	// This member is required.
	Message *string

	// The name of the exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
