// Code generated by smithy-go-codegen DO NOT EDIT.

package proton

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/proton/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get a list of service pipeline Infrastructure as Code (IaC) outputs.
//
// Deprecated: AWS Proton is not accepting new customers.
func (c *Client) ListServicePipelineOutputs(ctx context.Context, params *ListServicePipelineOutputsInput, optFns ...func(*Options)) (*ListServicePipelineOutputsOutput, error) {
	if params == nil {
		params = &ListServicePipelineOutputsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServicePipelineOutputs", params, optFns, c.addOperationListServicePipelineOutputsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServicePipelineOutputsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServicePipelineOutputsInput struct {

	// The name of the service whose pipeline's outputs you want.
	//
	// This member is required.
	ServiceName *string

	// The ID of the deployment you want the outputs for.
	DeploymentId *string

	// A token that indicates the location of the next output in the array of outputs,
	// after the list of outputs that was previously requested.
	NextToken *string

	noSmithyDocumentSerde
}

type ListServicePipelineOutputsOutput struct {

	// An array of service pipeline Infrastructure as Code (IaC) outputs.
	//
	// This member is required.
	Outputs []types.Output

	// A token that indicates the location of the next output in the array of outputs,
	// after the current requested list of outputs.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServicePipelineOutputsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListServicePipelineOutputs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListServicePipelineOutputs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServicePipelineOutputs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListServicePipelineOutputsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServicePipelineOutputs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListServicePipelineOutputsPaginatorOptions is the paginator options for
// ListServicePipelineOutputs
type ListServicePipelineOutputsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServicePipelineOutputsPaginator is a paginator for
// ListServicePipelineOutputs
type ListServicePipelineOutputsPaginator struct {
	options   ListServicePipelineOutputsPaginatorOptions
	client    ListServicePipelineOutputsAPIClient
	params    *ListServicePipelineOutputsInput
	nextToken *string
	firstPage bool
}

// NewListServicePipelineOutputsPaginator returns a new
// ListServicePipelineOutputsPaginator
func NewListServicePipelineOutputsPaginator(client ListServicePipelineOutputsAPIClient, params *ListServicePipelineOutputsInput, optFns ...func(*ListServicePipelineOutputsPaginatorOptions)) *ListServicePipelineOutputsPaginator {
	if params == nil {
		params = &ListServicePipelineOutputsInput{}
	}

	options := ListServicePipelineOutputsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServicePipelineOutputsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServicePipelineOutputsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServicePipelineOutputs page.
func (p *ListServicePipelineOutputsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServicePipelineOutputsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListServicePipelineOutputs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListServicePipelineOutputsAPIClient is a client that implements the
// ListServicePipelineOutputs operation.
type ListServicePipelineOutputsAPIClient interface {
	ListServicePipelineOutputs(context.Context, *ListServicePipelineOutputsInput, ...func(*Options)) (*ListServicePipelineOutputsOutput, error)
}

var _ ListServicePipelineOutputsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListServicePipelineOutputs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServicePipelineOutputs",
	}
}
