// Code generated by smithy-go-codegen DO NOT EDIT.

package qapps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qapps/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the full details of an Q App, including its definition specifying the
// cards and flow.
func (c *Client) GetQApp(ctx context.Context, params *GetQAppInput, optFns ...func(*Options)) (*GetQAppOutput, error) {
	if params == nil {
		params = &GetQAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetQApp", params, optFns, c.addOperationGetQAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetQAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetQAppInput struct {

	// The unique identifier of the Q App to retrieve.
	//
	// This member is required.
	AppId *string

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// This member is required.
	InstanceId *string

	// The version of the Q App.
	AppVersion *int32

	noSmithyDocumentSerde
}

type GetQAppOutput struct {

	// The Amazon Resource Name (ARN) of the Q App.
	//
	// This member is required.
	AppArn *string

	// The full definition of the Q App, specifying the cards and flow.
	//
	// This member is required.
	AppDefinition *types.AppDefinition

	// The unique identifier of the Q App.
	//
	// This member is required.
	AppId *string

	// The version of the Q App.
	//
	// This member is required.
	AppVersion *int32

	// The date and time the Q App was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user who created the Q App.
	//
	// This member is required.
	CreatedBy *string

	// The status of the Q App.
	//
	// This member is required.
	Status types.AppStatus

	// The title of the Q App.
	//
	// This member is required.
	Title *string

	// The date and time the Q App was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The user who last updated the Q App.
	//
	// This member is required.
	UpdatedBy *string

	// The description of the Q App.
	Description *string

	// The initial prompt displayed when the Q App is started.
	InitialPrompt *string

	// The capabilities required to run the Q App, such as file upload or third-party
	// integrations.
	RequiredCapabilities []types.AppRequiredCapability

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetQAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetQApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetQApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetQApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetQAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetQApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetQApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetQApp",
	}
}
