// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes reviewed answers for Q Topic.
func (c *Client) BatchDeleteTopicReviewedAnswer(ctx context.Context, params *BatchDeleteTopicReviewedAnswerInput, optFns ...func(*Options)) (*BatchDeleteTopicReviewedAnswerOutput, error) {
	if params == nil {
		params = &BatchDeleteTopicReviewedAnswerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDeleteTopicReviewedAnswer", params, optFns, c.addOperationBatchDeleteTopicReviewedAnswerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDeleteTopicReviewedAnswerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDeleteTopicReviewedAnswerInput struct {

	// The ID of the Amazon Web Services account that you want to delete a reviewed
	// answers in.
	//
	// This member is required.
	AwsAccountId *string

	// The ID for the topic reviewed answer that you want to delete. This ID is unique
	// per Amazon Web Services Region for each Amazon Web Services account.
	//
	// This member is required.
	TopicId *string

	// The Answer IDs of the Answers to be deleted.
	AnswerIds []string

	noSmithyDocumentSerde
}

type BatchDeleteTopicReviewedAnswerOutput struct {

	// The definition of Answers that are invalid and not deleted.
	InvalidAnswers []types.InvalidTopicReviewedAnswer

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// The definition of Answers that are successfully deleted.
	SucceededAnswers []types.SucceededTopicReviewedAnswer

	// The Amazon Resource Name (ARN) of the topic.
	TopicArn *string

	// The ID of the topic reviewed answer that you want to delete. This ID is unique
	// per Amazon Web Services Region for each Amazon Web Services account.
	TopicId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDeleteTopicReviewedAnswerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchDeleteTopicReviewedAnswer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchDeleteTopicReviewedAnswer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchDeleteTopicReviewedAnswer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchDeleteTopicReviewedAnswerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDeleteTopicReviewedAnswer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDeleteTopicReviewedAnswer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchDeleteTopicReviewedAnswer",
	}
}
