// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deleting your Quick Sight account subscription has permanent, irreversible
// consequences across all Amazon Web Services regions:
//
//   - Global deletion – Running this operation from any single region will delete
//     your Quick Sight account and all data in every Amazon Web Services region where
//     you have Quick Sight resources.
//
//   - Complete data loss – All dashboards, analyses, datasets, data sources, and
//     custom visuals will be permanently deleted across all regions.
//
//   - Embedded content failure – All embedded dashboards and visuals in your
//     applications will immediately stop working and display errors to end users.
//
//   - Shared resources removed – All shared dashboards, folders, and resources
//     will become inaccessible to other users and external recipients.
//
//   - User access terminated – All Quick Sight users in your account will lose
//     access immediately, including authors, readers, and administrators.
//
//   - No recovery possible – Once deleted, your Quick Sight account and all
//     associated data cannot be restored.
//
// Consider exporting critical dashboards and data before proceeding with account
// deletion.
//
// Use the DeleteAccountSubscription operation to delete an Quick Sight account.
// This operation will result in an error message if you have configured your
// account termination protection settings to True . To change this setting and
// delete your account, call the UpdateAccountSettings API and set the value of
// the TerminationProtectionEnabled parameter to False , then make another call to
// the DeleteAccountSubscription API.
func (c *Client) DeleteAccountSubscription(ctx context.Context, params *DeleteAccountSubscriptionInput, optFns ...func(*Options)) (*DeleteAccountSubscriptionOutput, error) {
	if params == nil {
		params = &DeleteAccountSubscriptionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteAccountSubscription", params, optFns, c.addOperationDeleteAccountSubscriptionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteAccountSubscriptionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteAccountSubscriptionInput struct {

	// The Amazon Web Services account ID of the account that you want to delete.
	//
	// This member is required.
	AwsAccountId *string

	noSmithyDocumentSerde
}

type DeleteAccountSubscriptionOutput struct {

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteAccountSubscriptionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteAccountSubscription{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteAccountSubscription{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteAccountSubscription"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteAccountSubscriptionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteAccountSubscription(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteAccountSubscription(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteAccountSubscription",
	}
}
