// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all action connectors in the specified Amazon Web Services account.
// Returns summary information for each connector including its name, type,
// creation time, and status.
func (c *Client) ListActionConnectors(ctx context.Context, params *ListActionConnectorsInput, optFns ...func(*Options)) (*ListActionConnectorsOutput, error) {
	if params == nil {
		params = &ListActionConnectorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListActionConnectors", params, optFns, c.addOperationListActionConnectorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListActionConnectorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListActionConnectorsInput struct {

	// The Amazon Web Services account ID for which to list action connectors.
	//
	// This member is required.
	AwsAccountId *string

	// The maximum number of action connectors to return in a single response. Valid
	// range is 1 to 100.
	MaxResults *int32

	// A pagination token to retrieve the next set of results. Use the token returned
	// from a previous call to continue listing action connectors.
	NextToken *string

	noSmithyDocumentSerde
}

type ListActionConnectorsOutput struct {

	// A list of action connector summaries containing basic information about each
	// connector.
	//
	// This member is required.
	ActionConnectorSummaries []types.ActionConnectorSummary

	// A pagination token to retrieve the next set of results. If null, there are no
	// more results to retrieve.
	NextToken *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status code of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListActionConnectorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListActionConnectors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListActionConnectors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListActionConnectors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListActionConnectorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListActionConnectors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListActionConnectorsPaginatorOptions is the paginator options for
// ListActionConnectors
type ListActionConnectorsPaginatorOptions struct {
	// The maximum number of action connectors to return in a single response. Valid
	// range is 1 to 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListActionConnectorsPaginator is a paginator for ListActionConnectors
type ListActionConnectorsPaginator struct {
	options   ListActionConnectorsPaginatorOptions
	client    ListActionConnectorsAPIClient
	params    *ListActionConnectorsInput
	nextToken *string
	firstPage bool
}

// NewListActionConnectorsPaginator returns a new ListActionConnectorsPaginator
func NewListActionConnectorsPaginator(client ListActionConnectorsAPIClient, params *ListActionConnectorsInput, optFns ...func(*ListActionConnectorsPaginatorOptions)) *ListActionConnectorsPaginator {
	if params == nil {
		params = &ListActionConnectorsInput{}
	}

	options := ListActionConnectorsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListActionConnectorsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListActionConnectorsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListActionConnectors page.
func (p *ListActionConnectorsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListActionConnectorsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListActionConnectors(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListActionConnectorsAPIClient is a client that implements the
// ListActionConnectors operation.
type ListActionConnectorsAPIClient interface {
	ListActionConnectors(context.Context, *ListActionConnectorsInput, ...func(*Options)) (*ListActionConnectorsOutput, error)
}

var _ ListActionConnectorsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListActionConnectors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListActionConnectors",
	}
}
