// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Aurora global database spread across multiple Amazon Web Services
// Regions. The global database contains a single primary cluster with read-write
// capability, and a read-only secondary cluster that receives data from the
// primary cluster through high-speed replication performed by the Aurora storage
// subsystem.
//
// You can create a global database that is initially empty, and then create the
// primary and secondary DB clusters in the global database. Or you can specify an
// existing Aurora cluster during the create operation, and this cluster becomes
// the primary cluster of the global database.
//
// This operation applies only to Aurora DB clusters.
func (c *Client) CreateGlobalCluster(ctx context.Context, params *CreateGlobalClusterInput, optFns ...func(*Options)) (*CreateGlobalClusterOutput, error) {
	if params == nil {
		params = &CreateGlobalClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGlobalCluster", params, optFns, c.addOperationCreateGlobalClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGlobalClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateGlobalClusterInput struct {

	// The cluster identifier for this global database cluster. This parameter is
	// stored as a lowercase string.
	//
	// This member is required.
	GlobalClusterIdentifier *string

	// The name for your database of up to 64 alphanumeric characters. If you don't
	// specify a name, Amazon Aurora doesn't create a database in the global database
	// cluster.
	//
	// Constraints:
	//
	//   - Can't be specified if SourceDBClusterIdentifier is specified. In this case,
	//   Amazon Aurora uses the database name from the source DB cluster.
	DatabaseName *string

	// Specifies whether to enable deletion protection for the new global database
	// cluster. The global database can't be deleted when deletion protection is
	// enabled.
	DeletionProtection *bool

	// The database engine to use for this global database cluster.
	//
	// Valid Values: aurora-mysql | aurora-postgresql
	//
	// Constraints:
	//
	//   - Can't be specified if SourceDBClusterIdentifier is specified. In this case,
	//   Amazon Aurora uses the engine of the source DB cluster.
	Engine *string

	// The life cycle type for this global database cluster.
	//
	// By default, this value is set to open-source-rds-extended-support , which
	// enrolls your global cluster into Amazon RDS Extended Support. At the end of
	// standard support, you can avoid charges for Extended Support by setting the
	// value to open-source-rds-extended-support-disabled . In this case, creating the
	// global cluster will fail if the DB major version is past its end of standard
	// support date.
	//
	// This setting only applies to Aurora PostgreSQL-based global databases.
	//
	// You can use this setting to enroll your global cluster into Amazon RDS Extended
	// Support. With RDS Extended Support, you can run the selected major engine
	// version on your global cluster past the end of standard support for that engine
	// version. For more information, see [Amazon RDS Extended Support with Amazon Aurora]in the Amazon Aurora User Guide.
	//
	// Valid Values: open-source-rds-extended-support |
	// open-source-rds-extended-support-disabled
	//
	// Default: open-source-rds-extended-support
	//
	// [Amazon RDS Extended Support with Amazon Aurora]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html
	EngineLifecycleSupport *string

	// The engine version to use for this global database cluster.
	//
	// Constraints:
	//
	//   - Can't be specified if SourceDBClusterIdentifier is specified. In this case,
	//   Amazon Aurora uses the engine version of the source DB cluster.
	EngineVersion *string

	// The Amazon Resource Name (ARN) to use as the primary cluster of the global
	// database.
	//
	// If you provide a value for this parameter, don't specify values for the
	// following settings because Amazon Aurora uses the values from the specified
	// source DB cluster:
	//
	//   - DatabaseName
	//
	//   - Engine
	//
	//   - EngineVersion
	//
	//   - StorageEncrypted
	SourceDBClusterIdentifier *string

	// Specifies whether to enable storage encryption for the new global database
	// cluster.
	//
	// Constraints:
	//
	//   - Can't be specified if SourceDBClusterIdentifier is specified. In this case,
	//   Amazon Aurora uses the setting from the source DB cluster.
	StorageEncrypted *bool

	// Tags to assign to the global cluster.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateGlobalClusterOutput struct {

	// A data type representing an Aurora global database.
	GlobalCluster *types.GlobalCluster

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGlobalClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGlobalCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGlobalClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGlobalCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateGlobalCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGlobalCluster",
	}
}
