// Code generated by smithy-go-codegen DO NOT EDIT.

package rekognition

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rekognition/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of media analysis jobs. Results are sorted by CreationTimestamp
// in descending order.
func (c *Client) ListMediaAnalysisJobs(ctx context.Context, params *ListMediaAnalysisJobsInput, optFns ...func(*Options)) (*ListMediaAnalysisJobsOutput, error) {
	if params == nil {
		params = &ListMediaAnalysisJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMediaAnalysisJobs", params, optFns, c.addOperationListMediaAnalysisJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMediaAnalysisJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMediaAnalysisJobsInput struct {

	// The maximum number of results to return per paginated call. The largest value
	// user can specify is 100. If user specifies a value greater than 100, an
	// InvalidParameterException error occurs. The default value is 100.
	MaxResults *int32

	// Pagination token, if the previous response was incomplete.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMediaAnalysisJobsOutput struct {

	// Contains a list of all media analysis jobs.
	//
	// This member is required.
	MediaAnalysisJobs []types.MediaAnalysisJobDescription

	// Pagination token, if the previous response was incomplete.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMediaAnalysisJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListMediaAnalysisJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListMediaAnalysisJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMediaAnalysisJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMediaAnalysisJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMediaAnalysisJobsPaginatorOptions is the paginator options for
// ListMediaAnalysisJobs
type ListMediaAnalysisJobsPaginatorOptions struct {
	// The maximum number of results to return per paginated call. The largest value
	// user can specify is 100. If user specifies a value greater than 100, an
	// InvalidParameterException error occurs. The default value is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMediaAnalysisJobsPaginator is a paginator for ListMediaAnalysisJobs
type ListMediaAnalysisJobsPaginator struct {
	options   ListMediaAnalysisJobsPaginatorOptions
	client    ListMediaAnalysisJobsAPIClient
	params    *ListMediaAnalysisJobsInput
	nextToken *string
	firstPage bool
}

// NewListMediaAnalysisJobsPaginator returns a new ListMediaAnalysisJobsPaginator
func NewListMediaAnalysisJobsPaginator(client ListMediaAnalysisJobsAPIClient, params *ListMediaAnalysisJobsInput, optFns ...func(*ListMediaAnalysisJobsPaginatorOptions)) *ListMediaAnalysisJobsPaginator {
	if params == nil {
		params = &ListMediaAnalysisJobsInput{}
	}

	options := ListMediaAnalysisJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMediaAnalysisJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMediaAnalysisJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMediaAnalysisJobs page.
func (p *ListMediaAnalysisJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMediaAnalysisJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMediaAnalysisJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMediaAnalysisJobsAPIClient is a client that implements the
// ListMediaAnalysisJobs operation.
type ListMediaAnalysisJobsAPIClient interface {
	ListMediaAnalysisJobs(context.Context, *ListMediaAnalysisJobsInput, ...func(*Options)) (*ListMediaAnalysisJobsOutput, error)
}

var _ ListMediaAnalysisJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMediaAnalysisJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMediaAnalysisJobs",
	}
}
