// Code generated by smithy-go-codegen DO NOT EDIT.

package resourceexplorer2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/resourceexplorer2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of Amazon Web Services services that have been granted streaming
// access to your Resource Explorer data. Streaming access allows Amazon Web
// Services services to receive real-time updates about your resources as they are
// indexed by Resource Explorer.
func (c *Client) ListStreamingAccessForServices(ctx context.Context, params *ListStreamingAccessForServicesInput, optFns ...func(*Options)) (*ListStreamingAccessForServicesOutput, error) {
	if params == nil {
		params = &ListStreamingAccessForServicesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListStreamingAccessForServices", params, optFns, c.addOperationListStreamingAccessForServicesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListStreamingAccessForServicesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListStreamingAccessForServicesInput struct {

	// The maximum number of streaming access entries to return in the response. If
	// there are more results available, the response includes a NextToken value that
	// you can use in a subsequent call to get the next set of results. The value must
	// be between 1 and 50. If you don't specify a value, the default is 50.
	MaxResults *int32

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more output
	// is available. Set this parameter to the value of the previous call's NextToken
	// response to indicate where the output should continue from. The pagination
	// tokens expire after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

type ListStreamingAccessForServicesOutput struct {

	// A list of Amazon Web Services services that have streaming access to your
	// Resource Explorer data, including details about when the access was granted.
	//
	// This member is required.
	StreamingAccessForServices []types.StreamingAccessDetails

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You should
	// repeat this until the NextToken response element comes back as null . The
	// pagination tokens expire after 24 hours.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListStreamingAccessForServicesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListStreamingAccessForServices{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListStreamingAccessForServices{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListStreamingAccessForServices"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListStreamingAccessForServices(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListStreamingAccessForServicesPaginatorOptions is the paginator options for
// ListStreamingAccessForServices
type ListStreamingAccessForServicesPaginatorOptions struct {
	// The maximum number of streaming access entries to return in the response. If
	// there are more results available, the response includes a NextToken value that
	// you can use in a subsequent call to get the next set of results. The value must
	// be between 1 and 50. If you don't specify a value, the default is 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListStreamingAccessForServicesPaginator is a paginator for
// ListStreamingAccessForServices
type ListStreamingAccessForServicesPaginator struct {
	options   ListStreamingAccessForServicesPaginatorOptions
	client    ListStreamingAccessForServicesAPIClient
	params    *ListStreamingAccessForServicesInput
	nextToken *string
	firstPage bool
}

// NewListStreamingAccessForServicesPaginator returns a new
// ListStreamingAccessForServicesPaginator
func NewListStreamingAccessForServicesPaginator(client ListStreamingAccessForServicesAPIClient, params *ListStreamingAccessForServicesInput, optFns ...func(*ListStreamingAccessForServicesPaginatorOptions)) *ListStreamingAccessForServicesPaginator {
	if params == nil {
		params = &ListStreamingAccessForServicesInput{}
	}

	options := ListStreamingAccessForServicesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListStreamingAccessForServicesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListStreamingAccessForServicesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListStreamingAccessForServices page.
func (p *ListStreamingAccessForServicesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListStreamingAccessForServicesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListStreamingAccessForServices(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListStreamingAccessForServicesAPIClient is a client that implements the
// ListStreamingAccessForServices operation.
type ListStreamingAccessForServicesAPIClient interface {
	ListStreamingAccessForServices(context.Context, *ListStreamingAccessForServicesInput, ...func(*Options)) (*ListStreamingAccessForServicesOutput, error)
}

var _ ListStreamingAccessForServicesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListStreamingAccessForServices(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListStreamingAccessForServices",
	}
}
