// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The request failed because the target of the operation is currently being
// modified by a different request. Try again later.
type ConcurrentModificationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentModificationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConcurrentModificationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentModificationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request failed because performing the operation would violate a constraint.
//
// Some of the reasons in the following list might not apply to this specific
// operation.
//
//   - You must meet the prerequisites for using tag policies. For information,
//     see [Prerequisites and permissions]in the Tagging Amazon Web Services resources and Tag Editor user guide.
//
//   - You must enable the tag policies service principal (
//     tagpolicies.tag.amazonaws.com ) to integrate with Organizations For
//     information, see [EnableAWSServiceAccess].
//
//   - You must have a tag policy attached to the organization root, an OU, or an
//     account.
//
// [EnableAWSServiceAccess]: https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html
// [Prerequisites and permissions]: https://docs.aws.amazon.com/tag-editor/latest/userguide/tag-policies-orgs.html#tag-policies-prereqs
type ConstraintViolationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConstraintViolationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConstraintViolationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConstraintViolationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConstraintViolationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConstraintViolationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request processing failed because of an unknown error, exception, or
// failure. You can retry the request.
type InternalServiceException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServiceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServiceException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalServiceException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalServiceException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The request failed because of one of the following reasons:
//
//   - A required parameter is missing.
//
//   - A provided string parameter is malformed.
//
//   - An provided parameter value is out of range.
//
//   - The target ID is invalid, unsupported, or doesn't exist.
//
//   - You can't access the Amazon S3 bucket for report storage. For more
//     information, see [Amazon S3 bucket policy for report storage]in the Tagging Amazon Web Services resources and Tag Editor
//     user guide.
//
//   - The partition specified in an ARN parameter in the request doesn't match
//     the partition where you invoked the operation. The partition is specified by the
//     second field of the ARN.
//
// [Amazon S3 bucket policy for report storage]: https://docs.aws.amazon.com/tag-editor/latest/userguide/tag-policies-orgs.html#bucket-policy
type InvalidParameterException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request failed because the specified PaginationToken has expired. A
// PaginationToken is valid for a maximum of 15 minutes.
type PaginationTokenExpiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PaginationTokenExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PaginationTokenExpiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PaginationTokenExpiredException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PaginationTokenExpiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *PaginationTokenExpiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request failed because it exceeded the allowed frequency of submitted
// requests.
type ThrottledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ThrottledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottledException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ThrottledException"
	}
	return *e.ErrorCodeOverride
}
func (e *ThrottledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
