// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Associates a Route 53 private hosted zone with a Route 53 Global Resolver
// resource. This allows the resolver to resolve DNS queries for the private hosted
// zone from anywhere globally.
func (c *Client) AssociateHostedZone(ctx context.Context, params *AssociateHostedZoneInput, optFns ...func(*Options)) (*AssociateHostedZoneOutput, error) {
	if params == nil {
		params = &AssociateHostedZoneInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateHostedZone", params, optFns, c.addOperationAssociateHostedZoneMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateHostedZoneOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateHostedZoneInput struct {

	// The ID of the Route 53 private hosted zone to associate with the Route 53
	// Global Resolver resource.
	//
	// This member is required.
	HostedZoneId *string

	// Name for the private hosted zone association.
	//
	// This member is required.
	Name *string

	// An Amazon Resource Name (ARN) of the Route 53 Global Resolver the private
	// hosted zone will be associated to.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

type AssociateHostedZoneOutput struct {

	// The date and time the private hosted zone association was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// ID of the private hosted zone.
	//
	// This member is required.
	HostedZoneId *string

	// Name of the hosted zone (also the domain associated with the hosted zone).
	//
	// This member is required.
	HostedZoneName *string

	// ID of the association.
	//
	// This member is required.
	Id *string

	// Name for the private hosted zone association.
	//
	// This member is required.
	Name *string

	// An Amazon Resource Name (ARN) of the Route 53 Global Resolver the private
	// hosted zone is associated to.
	//
	// This member is required.
	ResourceArn *string

	// Aggregate status for all the AWS Regions in which the Route 53 Global Resolver
	// exists.
	//
	// This member is required.
	Status types.HostedZoneAssociationStatus

	// The date and time the private hosted zone association was modified.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateHostedZoneMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAssociateHostedZone{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAssociateHostedZone{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssociateHostedZone"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAssociateHostedZoneValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateHostedZone(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAssociateHostedZone(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssociateHostedZone",
	}
}
