// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates an access source for a DNS view. Access sources define IP addresses or
// CIDR ranges that are allowed to send DNS queries to the Route 53 Global
// Resolver, along with the permitted DNS protocols.
func (c *Client) CreateAccessSource(ctx context.Context, params *CreateAccessSourceInput, optFns ...func(*Options)) (*CreateAccessSourceOutput, error) {
	if params == nil {
		params = &CreateAccessSourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAccessSource", params, optFns, c.addOperationCreateAccessSourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAccessSourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAccessSourceInput struct {

	// The IP address or CIDR range that is allowed to send DNS queries to the Route
	// 53 Global Resolver.
	//
	// This member is required.
	Cidr *string

	// The ID of the DNS view to associate with this access source.
	//
	// This member is required.
	DnsViewId *string

	// The DNS protocol that is permitted for this access source. Valid values are
	// Do53 (DNS over port 53), DoT (DNS over TLS), and DoH (DNS over HTTPS).
	//
	// This member is required.
	Protocol types.DnsProtocol

	// A unique string that identifies the request and ensures idempotency.
	ClientToken *string

	// The IP address type for this access source. Valid values are IPv4 and IPv6 (if
	// the Route 53 Global Resolver supports dual-stack).
	IpAddressType types.IpAddressType

	// A descriptive name for the access source.
	Name *string

	// Tags to associate with the access source.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateAccessSourceOutput struct {

	// The Amazon Resource Name (ARN) of the access source.
	//
	// This member is required.
	Arn *string

	// The IP address or CIDR range that is allowed to send DNS queries to the Route
	// 53 Global Resolver.
	//
	// This member is required.
	Cidr *string

	// The date and time when the access source was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view associated with this access source.
	//
	// This member is required.
	DnsViewId *string

	// The unique identifier for the access source.
	//
	// This member is required.
	Id *string

	// The IP address type for this access source (IPv4 or IPv6).
	//
	// This member is required.
	IpAddressType types.IpAddressType

	// The DNS protocol that is permitted for this access source (Do53, DoT, or DoH).
	//
	// This member is required.
	Protocol types.DnsProtocol

	// The operational status of the access source.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time when the access source was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The descriptive name of the access source.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAccessSourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAccessSource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAccessSource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAccessSource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAccessSourceMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAccessSourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAccessSource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAccessSource struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAccessSource) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAccessSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAccessSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAccessSourceInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAccessSourceMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAccessSource{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAccessSource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAccessSource",
	}
}
