// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a firewall domain list. Domain lists are reusable sets of domain
// specifications that you use in DNS firewall rules to allow, block, or alert on
// DNS queries to specific domains.
func (c *Client) CreateFirewallDomainList(ctx context.Context, params *CreateFirewallDomainListInput, optFns ...func(*Options)) (*CreateFirewallDomainListOutput, error) {
	if params == nil {
		params = &CreateFirewallDomainListInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFirewallDomainList", params, optFns, c.addOperationCreateFirewallDomainListMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFirewallDomainListOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFirewallDomainListInput struct {

	// The ID of the Route 53 Global Resolver that the domain list will be associated
	// with.
	//
	// This member is required.
	GlobalResolverId *string

	// A descriptive name for the firewall domain list.
	//
	// This member is required.
	Name *string

	// A unique, case-sensitive identifier to ensure idempotency. This means that
	// making the same request multiple times with the same clientToken has the same
	// result every time.
	ClientToken *string

	// An optional description for the firewall domain list.
	Description *string

	// An array of user-defined keys and optional values. These tags can be used for
	// categorization and organization.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateFirewallDomainListOutput struct {

	// An Amazon Resource Name (ARN) for the domain list.
	//
	// This member is required.
	Arn *string

	// The time and date the domain list was created on.
	//
	// This member is required.
	CreatedAt *time.Time

	// Number of domains in the domain list.
	//
	// This member is required.
	DomainCount *int32

	// The ID of the Route 53 Global Resolver that the domain list is associated with.
	//
	// This member is required.
	GlobalResolverId *string

	// ID of the domain list.
	//
	// This member is required.
	Id *string

	// Name of the domain list.
	//
	// This member is required.
	Name *string

	// Creation status of the domain list.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The time and date the domain list was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description for the domain list.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFirewallDomainListMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateFirewallDomainList{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateFirewallDomainList{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateFirewallDomainList"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateFirewallDomainListMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateFirewallDomainListValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFirewallDomainList(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateFirewallDomainList struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateFirewallDomainList) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateFirewallDomainList) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateFirewallDomainListInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateFirewallDomainListInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateFirewallDomainListMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateFirewallDomainList{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateFirewallDomainList(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateFirewallDomainList",
	}
}
