// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a DNS firewall rule. Firewall rules define actions (ALLOW, BLOCK, or
// ALERT) to take on DNS queries that match specified domain lists, managed domain
// lists, or advanced threat protections.
func (c *Client) CreateFirewallRule(ctx context.Context, params *CreateFirewallRuleInput, optFns ...func(*Options)) (*CreateFirewallRuleOutput, error) {
	if params == nil {
		params = &CreateFirewallRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFirewallRule", params, optFns, c.addOperationCreateFirewallRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFirewallRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFirewallRuleInput struct {

	// The action that DNS Firewall should take on a DNS query when it matches one of
	// the domains in the rule's domain list:
	//
	//   - ALLOW - Permit the request to go through.
	//
	//   - ALERT - Permit the request and send metrics and logs to CloudWatch.
	//
	//   - BLOCK - Disallow the request. This option requires additional details in the
	//   rule's BlockResponse .
	//
	// This member is required.
	Action types.FirewallRuleAction

	// The ID of the DNS view to associate with this firewall rule.
	//
	// This member is required.
	DnsViewId *string

	// A descriptive name for the firewall rule.
	//
	// This member is required.
	Name *string

	// The DNS record's type. This determines the format of the record value that you
	// provided in BlockOverrideDomain . Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	//
	// This setting is required if the BlockResponse setting is OVERRIDE .
	BlockOverrideDnsType types.BlockOverrideDnsQueryType

	// The custom DNS record to send back in response to the query. Used for the rule
	// action BLOCK with a BlockResponse setting of OVERRIDE .
	//
	// This setting is required if the BlockResponse setting is OVERRIDE .
	BlockOverrideDomain *string

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	//
	// This setting is required if the BlockResponse setting is OVERRIDE .
	BlockOverrideTtl *int32

	// The response to return when the action is BLOCK. Valid values are NXDOMAIN
	// (domain does not exist), NODATA (domain exists but no records), or OVERRIDE
	// (return custom response).
	BlockResponse types.FirewallBlockResponse

	// A unique, case-sensitive identifier to ensure idempotency. This means that
	// making the same request multiple times with the same clientToken has the same
	// result every time.
	ClientToken *string

	// The confidence threshold for advanced threat detection. Valid values are HIGH,
	// MEDIUM, or LOW, indicating the accuracy level required for threat detection.
	ConfidenceThreshold types.ConfidenceThreshold

	// An optional description for the firewall rule.
	Description *string

	// Whether to enable advanced DNS threat protection for this rule. Advanced
	// protection can detect and block DNS tunneling and Domain Generation Algorithm
	// (DGA) threats.
	DnsAdvancedProtection types.DnsAdvancedProtection

	// The ID of the firewall domain list to use in this rule.
	FirewallDomainListId *string

	// The priority of this rule. Rules are evaluated in priority order, with lower
	// numbers having higher priority. When a DNS query matches multiple rules, the
	// rule with the highest priority (lowest number) is applied.
	Priority *int64

	// The DNS query type to match for this rule. Examples include A (IPv4 address),
	// AAAA (IPv6 address), MX (mail exchange), or TXT (text record).
	QType *string

	noSmithyDocumentSerde
}

type CreateFirewallRuleOutput struct {

	// The action that DNS Firewall takes on DNS queries that match this rule.
	//
	// This member is required.
	Action types.FirewallRuleAction

	// The date and time when the firewall rule was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view associated with this firewall rule.
	//
	// This member is required.
	DnsViewId *string

	// The unique identifier for the firewall rule.
	//
	// This member is required.
	Id *string

	// The name of the firewall rule.
	//
	// This member is required.
	Name *string

	// The priority of the firewall rule.
	//
	// This member is required.
	Priority *int64

	// The operational status of the firewall rule.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time when the firewall rule was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The DNS record type for the custom response when blockResponse is OVERRIDE.
	BlockOverrideDnsType types.BlockOverrideDnsQueryType

	// The custom domain to return when the action is BLOCK and blockResponse is
	// OVERRIDE.
	BlockOverrideDomain *string

	// The time-to-live (TTL) value for the custom response when blockResponse is
	// OVERRIDE.
	BlockOverrideTtl *int32

	// The response to return when the action is BLOCK.
	BlockResponse types.FirewallBlockResponse

	// The confidence threshold for advanced threat detection.
	ConfidenceThreshold types.ConfidenceThreshold

	// The description of the firewall rule.
	Description *string

	// Whether advanced DNS threat protection is enabled for this rule.
	DnsAdvancedProtection types.DnsAdvancedProtection

	// The ID of the firewall domain list used in this rule.
	FirewallDomainListId *string

	// The DNS query type that this rule matches.
	QueryType *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFirewallRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateFirewallRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateFirewallRuleMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateFirewallRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFirewallRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateFirewallRule struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateFirewallRule) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateFirewallRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateFirewallRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateFirewallRuleInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateFirewallRuleMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateFirewallRule{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateFirewallRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateFirewallRule",
	}
}
