// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Deletes an access source. This operation cannot be undone.
func (c *Client) DeleteAccessSource(ctx context.Context, params *DeleteAccessSourceInput, optFns ...func(*Options)) (*DeleteAccessSourceOutput, error) {
	if params == nil {
		params = &DeleteAccessSourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteAccessSource", params, optFns, c.addOperationDeleteAccessSourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteAccessSourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteAccessSourceInput struct {

	// The unique identifier of the access source to delete.
	//
	// This member is required.
	AccessSourceId *string

	noSmithyDocumentSerde
}

type DeleteAccessSourceOutput struct {

	// The Amazon Resource Name (ARN) of the deleted access source.
	//
	// This member is required.
	Arn *string

	// The IP address or CIDR range of the deleted access source.
	//
	// This member is required.
	Cidr *string

	// The date and time when the access source was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view that was associated with the deleted access source.
	//
	// This member is required.
	DnsViewId *string

	// The unique identifier of the deleted access source.
	//
	// This member is required.
	Id *string

	// The IP address type of the deleted access source (IPv4 or IPv6).
	//
	// This member is required.
	IpAddressType types.IpAddressType

	// The DNS protocol that was permitted for the deleted access source.
	//
	// This member is required.
	Protocol types.DnsProtocol

	// The final status of the deleted access source.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time when the access source was last updated before deletion.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The name of the deleted access source.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteAccessSourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteAccessSource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteAccessSource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteAccessSource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteAccessSourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteAccessSource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteAccessSource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteAccessSource",
	}
}
