// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a paginated list of the AWS Managed DNS Lists and the categories for
// DNS Firewall. The categories are either THREAT or CONTENT .
func (c *Client) ListManagedFirewallDomainLists(ctx context.Context, params *ListManagedFirewallDomainListsInput, optFns ...func(*Options)) (*ListManagedFirewallDomainListsOutput, error) {
	if params == nil {
		params = &ListManagedFirewallDomainListsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedFirewallDomainLists", params, optFns, c.addOperationListManagedFirewallDomainListsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedFirewallDomainListsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedFirewallDomainListsInput struct {

	// The category of the Manage DNS list either THREAT or CONTENT .
	//
	// This member is required.
	ManagedFirewallDomainListType *string

	// The maximum number of results to retrieve in a single call.
	MaxResults *int32

	// A pagination token used for large sets of results that can't be returned in a
	// single response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListManagedFirewallDomainListsOutput struct {

	// List of the Managed Domain Lists.
	//
	// This member is required.
	ManagedFirewallDomainLists []types.ManagedFirewallDomainListsItem

	// A pagination token used for large sets of results that can't be returned in a
	// single response. Provide this token in the next call to get the results not
	// returned in this call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedFirewallDomainListsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListManagedFirewallDomainLists{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListManagedFirewallDomainLists{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListManagedFirewallDomainLists"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListManagedFirewallDomainListsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedFirewallDomainLists(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListManagedFirewallDomainListsPaginatorOptions is the paginator options for
// ListManagedFirewallDomainLists
type ListManagedFirewallDomainListsPaginatorOptions struct {
	// The maximum number of results to retrieve in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedFirewallDomainListsPaginator is a paginator for
// ListManagedFirewallDomainLists
type ListManagedFirewallDomainListsPaginator struct {
	options   ListManagedFirewallDomainListsPaginatorOptions
	client    ListManagedFirewallDomainListsAPIClient
	params    *ListManagedFirewallDomainListsInput
	nextToken *string
	firstPage bool
}

// NewListManagedFirewallDomainListsPaginator returns a new
// ListManagedFirewallDomainListsPaginator
func NewListManagedFirewallDomainListsPaginator(client ListManagedFirewallDomainListsAPIClient, params *ListManagedFirewallDomainListsInput, optFns ...func(*ListManagedFirewallDomainListsPaginatorOptions)) *ListManagedFirewallDomainListsPaginator {
	if params == nil {
		params = &ListManagedFirewallDomainListsInput{}
	}

	options := ListManagedFirewallDomainListsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedFirewallDomainListsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedFirewallDomainListsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListManagedFirewallDomainLists page.
func (p *ListManagedFirewallDomainListsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedFirewallDomainListsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListManagedFirewallDomainLists(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListManagedFirewallDomainListsAPIClient is a client that implements the
// ListManagedFirewallDomainLists operation.
type ListManagedFirewallDomainListsAPIClient interface {
	ListManagedFirewallDomainLists(context.Context, *ListManagedFirewallDomainListsInput, ...func(*Options)) (*ListManagedFirewallDomainListsOutput, error)
}

var _ ListManagedFirewallDomainListsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListManagedFirewallDomainLists(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListManagedFirewallDomainLists",
	}
}
