// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the configuration of a DNS view.
func (c *Client) UpdateDNSView(ctx context.Context, params *UpdateDNSViewInput, optFns ...func(*Options)) (*UpdateDNSViewOutput, error) {
	if params == nil {
		params = &UpdateDNSViewInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDNSView", params, optFns, c.addOperationUpdateDNSViewMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDNSViewOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDNSViewInput struct {

	// The unique identifier of the DNS view to update.
	//
	// This member is required.
	DnsViewId *string

	// A description of the DNS view.
	Description *string

	// Whether to enable DNSSEC validation for the DNS view.
	DnssecValidation types.DnsSecValidationType

	// Whether to enable EDNS Client Subnet injection for the DNS view.
	EdnsClientSubnet types.EdnsClientSubnetType

	// Whether firewall rules should fail open when they cannot be evaluated.
	FirewallRulesFailOpen types.FirewallRulesFailOpenType

	// The name of the DNS view.
	Name *string

	noSmithyDocumentSerde
}

type UpdateDNSViewOutput struct {

	// The Amazon Resource Name (ARN) of the updated DNS view.
	//
	// This member is required.
	Arn *string

	// The date and time when the DNS view was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Whether DNSSEC validation is enabled for the updated DNS view.
	//
	// This member is required.
	DnssecValidation types.DnsSecValidationType

	// Whether EDNS Client Subnet injection is enabled for the updated DNS view.
	//
	// This member is required.
	EdnsClientSubnet types.EdnsClientSubnetType

	// Whether firewall rules fail open when they cannot be evaluated for the updated
	// DNS view.
	//
	// This member is required.
	FirewallRulesFailOpen types.FirewallRulesFailOpenType

	// The ID of the global resolver associated with the updated DNS view.
	//
	// This member is required.
	GlobalResolverId *string

	// The unique identifier of the updated DNS view.
	//
	// This member is required.
	Id *string

	// The name of the updated DNS view.
	//
	// This member is required.
	Name *string

	// The current status of the updated DNS view.
	//
	// This member is required.
	Status types.ProfileResourceStatus

	// The date and time when the DNS view was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The unique string that identifies the request and ensures idempotency.
	ClientToken *string

	// The description of the updated DNS view.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDNSViewMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDNSView"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDNSViewValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDNSView(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDNSView(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDNSView",
	}
}
