// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the configuration of a Route 53 Global Resolver instance. You can
// modify the name, description, and observability region.
func (c *Client) UpdateGlobalResolver(ctx context.Context, params *UpdateGlobalResolverInput, optFns ...func(*Options)) (*UpdateGlobalResolverOutput, error) {
	if params == nil {
		params = &UpdateGlobalResolverInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateGlobalResolver", params, optFns, c.addOperationUpdateGlobalResolverMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateGlobalResolverOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateGlobalResolverInput struct {

	// The ID of the Global Resolver.
	//
	// This member is required.
	GlobalResolverId *string

	// The description of the Global Resolver.
	Description *string

	// The name of the Global Resolver.
	Name *string

	// The AWS Regions in which the users' Global Resolver query resolution logs will
	// be propagated.
	ObservabilityRegion *string

	noSmithyDocumentSerde
}

type UpdateGlobalResolverOutput struct {

	// The Amazon Resource Name (ARN) of the Global Resolver.
	//
	// This member is required.
	Arn *string

	// A unique, case-sensitive identifier to ensure idempotency. This means that
	// making the same request multiple times with the same clientToken has the same
	// result every time.
	//
	// This member is required.
	ClientToken *string

	// The time and date the Global Resolverwas created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The hostname to be used by the customers' DNS clients for certification
	// validation.
	//
	// This member is required.
	DnsName *string

	// The ID of the Global Resolver.
	//
	// This member is required.
	Id *string

	// List of anycast IPv4 addresses associated with the Global Resolver instance.
	//
	// This member is required.
	Ipv4Addresses []string

	// Name of the Global Resolver.
	//
	// This member is required.
	Name *string

	// The AWS Regions in which the Global Resolver will operate.
	//
	// This member is required.
	Regions []string

	// The operational status of the Global Resolver.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The time and date the Global Resolver was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Global Resolver.
	Description *string

	// The AWS Regions in which the users' Global Resolver query resolution logs will
	// be propagated.
	ObservabilityRegion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateGlobalResolverMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateGlobalResolver{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateGlobalResolver{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateGlobalResolver"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateGlobalResolverValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateGlobalResolver(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateGlobalResolver(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateGlobalResolver",
	}
}
