// Code generated by smithy-go-codegen DO NOT EDIT.

package route53resolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53resolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the Resolvers on Outposts that were created using the current Amazon
// Web Services account.
func (c *Client) ListOutpostResolvers(ctx context.Context, params *ListOutpostResolversInput, optFns ...func(*Options)) (*ListOutpostResolversOutput, error) {
	if params == nil {
		params = &ListOutpostResolversInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOutpostResolvers", params, optFns, c.addOperationListOutpostResolversMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOutpostResolversOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOutpostResolversInput struct {

	// The maximum number of Resolvers on the Outpost that you want to return in the
	// response to a ListOutpostResolver request. If you don't specify a value for
	// MaxResults , the request returns up to 100 Resolvers.
	MaxResults *int32

	// For the first ListOutpostResolver request, omit this value.
	NextToken *string

	// The Amazon Resource Name (ARN) of the Outpost.
	OutpostArn *string

	noSmithyDocumentSerde
}

type ListOutpostResolversOutput struct {

	// If more than MaxResults Resolvers match the specified criteria, you can submit
	// another ListOutpostResolver request to get the next group of results. In the
	// next request, specify the value of NextToken from the previous response.
	NextToken *string

	// The Resolvers on Outposts that were created by using the current Amazon Web
	// Services account, and that match the specified filters, if any.
	OutpostResolvers []types.OutpostResolver

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOutpostResolversMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListOutpostResolvers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListOutpostResolvers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOutpostResolvers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOutpostResolvers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListOutpostResolversPaginatorOptions is the paginator options for
// ListOutpostResolvers
type ListOutpostResolversPaginatorOptions struct {
	// The maximum number of Resolvers on the Outpost that you want to return in the
	// response to a ListOutpostResolver request. If you don't specify a value for
	// MaxResults , the request returns up to 100 Resolvers.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOutpostResolversPaginator is a paginator for ListOutpostResolvers
type ListOutpostResolversPaginator struct {
	options   ListOutpostResolversPaginatorOptions
	client    ListOutpostResolversAPIClient
	params    *ListOutpostResolversInput
	nextToken *string
	firstPage bool
}

// NewListOutpostResolversPaginator returns a new ListOutpostResolversPaginator
func NewListOutpostResolversPaginator(client ListOutpostResolversAPIClient, params *ListOutpostResolversInput, optFns ...func(*ListOutpostResolversPaginatorOptions)) *ListOutpostResolversPaginator {
	if params == nil {
		params = &ListOutpostResolversInput{}
	}

	options := ListOutpostResolversPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOutpostResolversPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOutpostResolversPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOutpostResolvers page.
func (p *ListOutpostResolversPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOutpostResolversOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOutpostResolvers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOutpostResolversAPIClient is a client that implements the
// ListOutpostResolvers operation.
type ListOutpostResolversAPIClient interface {
	ListOutpostResolvers(context.Context, *ListOutpostResolversInput, ...func(*Options)) (*ListOutpostResolversOutput, error)
}

var _ ListOutpostResolversAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOutpostResolvers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOutpostResolvers",
	}
}
