// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The container for abort incomplete multipart upload
type AbortIncompleteMultipartUpload struct {

	// Specifies the number of days after which Amazon S3 aborts an incomplete
	// multipart upload to the Outposts bucket.
	DaysAfterInitiation int32

	noSmithyDocumentSerde
}

// A container for information about access control for replicas.
//
// This is not supported by Amazon S3 on Outposts buckets.
type AccessControlTranslation struct {

	// Specifies the replica ownership.
	//
	// This member is required.
	Owner OwnerOverride

	noSmithyDocumentSerde
}

// The configuration options of the S3 Access Grants location. It contains the
// S3SubPrefix field. The grant scope, the data to which you are granting access,
// is the result of appending the Subprefix field to the scope of the registered
// location.
type AccessGrantsLocationConfiguration struct {

	// The S3SubPrefix is appended to the location scope creating the grant scope. Use
	// this field to narrow the scope of the grant to a subset of the location scope.
	// This field is required if the location scope is the default location s3://
	// because you cannot create a grant for all of your S3 data in the Region and must
	// narrow the scope. For example, if the location scope is the default location
	// s3:// , the S3SubPrefx can be a /*, so the full grant scope path would be
	// s3:///* . Or the S3SubPrefx can be /* , so the full grant scope path would be or
	// s3:///* .
	//
	// If the S3SubPrefix includes a prefix, append the wildcard character * after the
	// prefix to indicate that you want to include all object key names in the bucket
	// that start with that prefix.
	S3SubPrefix *string

	noSmithyDocumentSerde
}

// An access point used to access a bucket.
type AccessPoint struct {

	// The name of the bucket associated with this access point.
	//
	// This member is required.
	Bucket *string

	// The name of this access point.
	//
	// This member is required.
	Name *string

	// Indicates whether this access point allows access from the public internet. If
	// VpcConfiguration is specified for this access point, then NetworkOrigin is VPC ,
	// and the access point doesn't allow access from the public internet. Otherwise,
	// NetworkOrigin is Internet , and the access point allows access from the public
	// internet, subject to the access point and bucket access policies.
	//
	// This member is required.
	NetworkOrigin NetworkOrigin

	// The ARN for the access point.
	AccessPointArn *string

	// The name or alias of the access point.
	Alias *string

	// The Amazon Web Services account ID associated with the S3 bucket associated
	// with this access point.
	BucketAccountId *string

	// A unique identifier for the data source of the access point.
	DataSourceId *string

	// The type of the data source that the access point is attached to.
	DataSourceType *string

	// The virtual private cloud (VPC) configuration for this access point, if one
	// exists.
	//
	// This element is empty if this access point is an Amazon S3 on Outposts access
	// point that is used by other Amazon Web Services services.
	VpcConfiguration *VpcConfiguration

	noSmithyDocumentSerde
}

// A container element for the account-level Amazon S3 Storage Lens configuration.
//
// You must enable Storage Lens metrics consistently at both the account level and
// bucket level, or your request will fail.
//
// For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens] in the Amazon S3 User Guide.
// For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary]in the Amazon S3 User Guide.
//
// [Assessing your storage activity and usage with S3 Storage Lens]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html
// [S3 Storage Lens metrics glossary]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html
type AccountLevel struct {

	// A container element for the S3 Storage Lens bucket-level configuration.
	//
	// This member is required.
	BucketLevel *BucketLevel

	// A container element for S3 Storage Lens activity metrics.
	ActivityMetrics *ActivityMetrics

	// A container element for S3 Storage Lens advanced cost-optimization metrics.
	AdvancedCostOptimizationMetrics *AdvancedCostOptimizationMetrics

	// A container element for S3 Storage Lens advanced data-protection metrics.
	AdvancedDataProtectionMetrics *AdvancedDataProtectionMetrics

	// A container element for S3 Storage Lens advanced performance metrics.
	AdvancedPerformanceMetrics *AdvancedPerformanceMetrics

	// A container element for detailed status code metrics.
	DetailedStatusCodesMetrics *DetailedStatusCodesMetrics

	//  A container element for S3 Storage Lens groups metrics.
	StorageLensGroupLevel *StorageLensGroupLevel

	noSmithyDocumentSerde
}

// The container element for Amazon S3 Storage Lens activity metrics. Activity
// metrics show details about how your storage is requested, such as requests (for
// example, All requests, Get requests, Put requests), bytes uploaded or
// downloaded, and errors.
//
// For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens] in the Amazon S3 User Guide.
// For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary]in the Amazon S3 User Guide.
//
// [Assessing your storage activity and usage with S3 Storage Lens]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html
// [S3 Storage Lens metrics glossary]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html
type ActivityMetrics struct {

	// A container that indicates whether activity metrics are enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The container element for Amazon S3 Storage Lens advanced cost-optimization
// metrics. Advanced cost-optimization metrics provide insights that you can use to
// manage and optimize your storage costs, for example, lifecycle rule counts for
// transitions, expirations, and incomplete multipart uploads.
//
// For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens] in the Amazon S3 User Guide.
// For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary]in the Amazon S3 User Guide.
//
// [Assessing your storage activity and usage with S3 Storage Lens]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html
// [S3 Storage Lens metrics glossary]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html
type AdvancedCostOptimizationMetrics struct {

	// A container that indicates whether advanced cost-optimization metrics are
	// enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The container element for Amazon S3 Storage Lens advanced data-protection
// metrics. Advanced data-protection metrics provide insights that you can use to
// perform audits and protect your data, for example replication rule counts within
// and across Regions.
//
// For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens] in the Amazon S3 User Guide.
// For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary]in the Amazon S3 User Guide.
//
// [Assessing your storage activity and usage with S3 Storage Lens]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html
// [S3 Storage Lens metrics glossary]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html
type AdvancedDataProtectionMetrics struct {

	// A container that indicates whether advanced data-protection metrics are enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The container element for S3 Storage Lens advanced performance metrics.
// Advanced performance metrics provide insights into application performance, such
// as request efficiency and access patterns. These metrics help you optimize your
// S3 storage for both cost and performance by providing detailed analytics on how
// your applications interact with S3 resources.
//
// For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens] in the Amazon S3 User Guide.
// For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary]in the Amazon S3 User Guide.
//
// [Assessing your storage activity and usage with S3 Storage Lens]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html
// [S3 Storage Lens metrics glossary]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html
type AdvancedPerformanceMetrics struct {

	// A container that indicates whether S3 Storage Lens advanced performance metrics
	// are enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// Error details for the failed asynchronous operation.
type AsyncErrorDetails struct {

	// A string that uniquely identifies the error condition.
	Code *string

	// A generic description of the error condition in English.
	Message *string

	// The ID of the request associated with the error.
	RequestId *string

	// The identifier of the resource associated with the error.
	Resource *string

	noSmithyDocumentSerde
}

// A container for the information about an asynchronous operation.
type AsyncOperation struct {

	// The time that the request was sent to the service.
	CreationTime *time.Time

	// The specific operation for the asynchronous request.
	Operation AsyncOperationName

	// The parameters associated with the request.
	RequestParameters *AsyncRequestParameters

	// The current status of the request.
	RequestStatus *string

	// The request token associated with the request.
	RequestTokenARN *string

	// The details of the response.
	ResponseDetails *AsyncResponseDetails

	noSmithyDocumentSerde
}

// A container for the request parameters associated with an asynchronous request.
type AsyncRequestParameters struct {

	// A container of the parameters for a [CreateMultiRegionAccessPoint] request.
	//
	// [CreateMultiRegionAccessPoint]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html
	CreateMultiRegionAccessPointRequest *CreateMultiRegionAccessPointInput

	// A container of the parameters for a [DeleteMultiRegionAccessPoint] request.
	//
	// [DeleteMultiRegionAccessPoint]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html
	DeleteMultiRegionAccessPointRequest *DeleteMultiRegionAccessPointInput

	// A container of the parameters for a [PutMultiRegionAccessPoint] request.
	//
	// [PutMultiRegionAccessPoint]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html
	PutMultiRegionAccessPointPolicyRequest *PutMultiRegionAccessPointPolicyInput

	noSmithyDocumentSerde
}

// A container for the response details that are returned when querying about an
// asynchronous request.
type AsyncResponseDetails struct {

	// Error details for an asynchronous request.
	ErrorDetails *AsyncErrorDetails

	// The details for the Multi-Region Access Point.
	MultiRegionAccessPointDetails *MultiRegionAccessPointsAsyncResponse

	noSmithyDocumentSerde
}

// Lambda function used to transform objects through an Object Lambda Access Point.
type AwsLambdaTransformation struct {

	// The Amazon Resource Name (ARN) of the Lambda function.
	//
	// This member is required.
	FunctionArn *string

	// Additional JSON that provides supplemental data to the Lambda function used to
	// transform objects.
	FunctionPayload *string

	noSmithyDocumentSerde
}

// A container for the bucket-level configuration for Amazon S3 Storage Lens.
//
// For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens] in the Amazon S3 User Guide.
//
// [Assessing your storage activity and usage with S3 Storage Lens]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html
type BucketLevel struct {

	// A container for the bucket-level activity metrics for S3 Storage Lens.
	ActivityMetrics *ActivityMetrics

	// A container for bucket-level advanced cost-optimization metrics for S3 Storage
	// Lens.
	AdvancedCostOptimizationMetrics *AdvancedCostOptimizationMetrics

	// A container for bucket-level advanced data-protection metrics for S3 Storage
	// Lens.
	AdvancedDataProtectionMetrics *AdvancedDataProtectionMetrics

	// A container for bucket-level advanced performance metrics for S3 Storage Lens.
	AdvancedPerformanceMetrics *AdvancedPerformanceMetrics

	// A container for bucket-level detailed status code metrics for S3 Storage Lens.
	DetailedStatusCodesMetrics *DetailedStatusCodesMetrics

	// A container for the prefix-level metrics for S3 Storage Lens.
	PrefixLevel *PrefixLevel

	noSmithyDocumentSerde
}

// A container for enabling Amazon CloudWatch publishing for S3 Storage Lens
// metrics.
//
// For more information about publishing S3 Storage Lens metrics to CloudWatch,
// see [Monitor S3 Storage Lens metrics in CloudWatch]in the Amazon S3 User Guide.
//
// [Monitor S3 Storage Lens metrics in CloudWatch]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_view_metrics_cloudwatch.html
type CloudWatchMetrics struct {

	// A container that indicates whether CloudWatch publishing for S3 Storage Lens
	// metrics is enabled. A value of true indicates that CloudWatch publishing for S3
	// Storage Lens metrics is enabled.
	//
	// This member is required.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The container for the bucket configuration.
//
// This is not supported by Amazon S3 on Outposts buckets.
type CreateBucketConfiguration struct {

	// Specifies the Region where the bucket will be created. If you are creating a
	// bucket on the US East (N. Virginia) Region (us-east-1), you do not need to
	// specify the location.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	LocationConstraint BucketLocationConstraint

	noSmithyDocumentSerde
}

// A container for the information associated with a [CreateMultiRegionAccessPoint] request.
//
// [CreateMultiRegionAccessPoint]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html
type CreateMultiRegionAccessPointInput struct {

	// The name of the Multi-Region Access Point associated with this request.
	//
	// This member is required.
	Name *string

	// The buckets in different Regions that are associated with the Multi-Region
	// Access Point.
	//
	// This member is required.
	Regions []Region

	// The PublicAccessBlock configuration that you want to apply to this Amazon S3
	// account. You can enable the configuration options in any combination. For more
	// information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"]in
	// the Amazon S3 User Guide.
	//
	// This data type is not supported for Amazon S3 on Outposts.
	//
	// [The Meaning of "Public"]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status
	PublicAccessBlock *PublicAccessBlockConfiguration

	noSmithyDocumentSerde
}

// The Amazon Web Services Security Token Service temporary credential that S3
// Access Grants vends to grantees and client applications.
type Credentials struct {

	// The unique access key ID of the Amazon Web Services STS temporary credential
	// that S3 Access Grants vends to grantees and client applications.
	AccessKeyId *string

	// The expiration date and time of the temporary credential that S3 Access Grants
	// vends to grantees and client applications.
	Expiration *time.Time

	// The secret access key of the Amazon Web Services STS temporary credential that
	// S3 Access Grants vends to grantees and client applications.
	SecretAccessKey *string

	// The Amazon Web Services STS temporary credential that S3 Access Grants vends to
	// grantees and client applications.
	SessionToken *string

	noSmithyDocumentSerde
}

// Specifies whether S3 on Outposts replicates delete markers. If you specify a
// Filter element in your replication configuration, you must also include a
// DeleteMarkerReplication element. If your Filter includes a Tag element, the
// DeleteMarkerReplication element's Status child element must be set to Disabled ,
// because S3 on Outposts does not support replicating delete markers for tag-based
// rules.
//
// For more information about delete marker replication, see [How delete operations affect replication] in the Amazon S3
// User Guide.
//
// [How delete operations affect replication]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated
type DeleteMarkerReplication struct {

	// Indicates whether to replicate delete markers.
	//
	// This member is required.
	Status DeleteMarkerReplicationStatus

	noSmithyDocumentSerde
}

// A container for the information associated with a [DeleteMultiRegionAccessPoint] request.
//
// [DeleteMultiRegionAccessPoint]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html
type DeleteMultiRegionAccessPointInput struct {

	// The name of the Multi-Region Access Point associated with this request.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Specifies information about the replication destination bucket and its settings
// for an S3 on Outposts replication configuration.
type Destination struct {

	// The Amazon Resource Name (ARN) of the access point for the destination bucket
	// where you want S3 on Outposts to store the replication results.
	//
	// This member is required.
	Bucket *string

	// Specify this property only in a cross-account scenario (where the source and
	// destination bucket owners are not the same), and you want to change replica
	// ownership to the Amazon Web Services account that owns the destination bucket.
	// If this property is not specified in the replication configuration, the replicas
	// are owned by same Amazon Web Services account that owns the source object.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	AccessControlTranslation *AccessControlTranslation

	// The destination bucket owner's account ID.
	Account *string

	// A container that provides information about encryption. If
	// SourceSelectionCriteria is specified, you must specify this element.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	EncryptionConfiguration *EncryptionConfiguration

	//  A container that specifies replication metrics-related settings.
	Metrics *Metrics

	// A container that specifies S3 Replication Time Control (S3 RTC) settings,
	// including whether S3 RTC is enabled and the time when all objects and operations
	// on objects must be replicated. Must be specified together with a Metrics block.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ReplicationTime *ReplicationTime

	//  The storage class to use when replicating objects. All objects stored on S3 on
	// Outposts are stored in the OUTPOSTS storage class. S3 on Outposts uses the
	// OUTPOSTS storage class to create the object replicas.
	//
	// Values other than OUTPOSTS aren't supported by Amazon S3 on Outposts.
	StorageClass ReplicationStorageClass

	noSmithyDocumentSerde
}

// The container element for Amazon S3 Storage Lens detailed status code metrics.
// Detailed status code metrics generate metrics for HTTP status codes, such as
// 200 OK , 403 Forbidden , 503 Service Unavailable and others.
//
// For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens] in the Amazon S3 User Guide.
// For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary]in the Amazon S3 User Guide.
//
// [Assessing your storage activity and usage with S3 Storage Lens]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html
// [S3 Storage Lens metrics glossary]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html
type DetailedStatusCodesMetrics struct {

	// A container that indicates whether detailed status code metrics are enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// A filter that returns objects that are encrypted by dual-layer server-side
// encryption with Amazon Web Services Key Management Service (KMS) keys
// (DSSE-KMS). You can further refine your filtering by optionally providing a KMS
// Key ARN to filter objects encrypted by a specific key.
type DSSEKMSFilter struct {

	// The Amazon Resource Name (ARN) of the customer managed KMS key to use for the
	// filter to return objects that are encrypted by the specified key. For best
	// performance, use keys in the same Region as the S3 Batch Operations job.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Specifies encryption-related information for an Amazon S3 bucket that is a
// destination for replicated objects. If you're specifying a customer managed KMS
// key, we recommend using a fully qualified KMS key ARN. If you use a KMS key
// alias instead, then KMS resolves the key within the requester’s account. This
// behavior can result in data that's encrypted with a KMS key that belongs to the
// requester, and not the bucket owner.
//
// This is not supported by Amazon S3 on Outposts buckets.
type EncryptionConfiguration struct {

	// Specifies the ID of the customer managed KMS key that's stored in Key
	// Management Service (KMS) for the destination bucket. This ID is either the
	// Amazon Resource Name (ARN) for the KMS key or the alias ARN for the KMS key.
	// Amazon S3 uses this KMS key to encrypt replica objects. Amazon S3 supports only
	// symmetric encryption KMS keys. For more information, see [Symmetric encryption KMS keys]in the Amazon Web
	// Services Key Management Service Developer Guide.
	//
	// [Symmetric encryption KMS keys]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks
	ReplicaKmsKeyID *string

	noSmithyDocumentSerde
}

// The last established access control policy for a Multi-Region Access Point.
//
// When you update the policy, the update is first listed as the proposed policy.
// After the update is finished and all Regions have been updated, the proposed
// policy is listed as the established policy. If both policies have the same
// version number, the proposed policy is the established policy.
type EstablishedMultiRegionAccessPointPolicy struct {

	// The details of the last established policy.
	Policy *string

	noSmithyDocumentSerde
}

// A container for what Amazon S3 Storage Lens will exclude.
type Exclude struct {

	// A container for the S3 Storage Lens bucket excludes.
	Buckets []string

	// A container for the S3 Storage Lens Region excludes.
	Regions []string

	noSmithyDocumentSerde
}

// An optional configuration to replicate existing source bucket objects.
//
// This is not supported by Amazon S3 on Outposts buckets.
type ExistingObjectReplication struct {

	// Specifies whether Amazon S3 replicates existing source bucket objects.
	//
	// This member is required.
	Status ExistingObjectReplicationStatus

	noSmithyDocumentSerde
}

// The encryption configuration to use when storing the generated manifest.
type GeneratedManifestEncryption struct {

	// Configuration details on how SSE-KMS is used to encrypt generated manifest
	// objects.
	SSEKMS *SSEKMSEncryption

	// Specifies the use of SSE-S3 to encrypt generated manifest objects.
	SSES3 *SSES3Encryption

	noSmithyDocumentSerde
}

// The user, group, or role to which you are granting access. You can grant access
// to an IAM user or role. If you have added your corporate directory to Amazon Web
// Services IAM Identity Center and associated your Identity Center instance with
// your S3 Access Grants instance, the grantee can also be a corporate directory
// user or group.
type Grantee struct {

	// The unique identifier of the Grantee . If the grantee type is IAM , the
	// identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the
	// grantee type is a directory user or group, the identifier is 128-bit universally
	// unique identifier (UUID) in the format a1b2c3d4-5678-90ab-cdef-EXAMPLE11111 .
	// You can obtain this UUID from your Amazon Web Services IAM Identity Center
	// instance.
	GranteeIdentifier *string

	// The type of the grantee to which access has been granted. It can be one of the
	// following values:
	//
	//   - IAM - An IAM user or role.
	//
	//   - DIRECTORY_USER - Your corporate directory user. You can use this option if
	//   you have added your corporate identity directory to IAM Identity Center and
	//   associated the IAM Identity Center instance with your S3 Access Grants instance.
	//
	//   - DIRECTORY_GROUP - Your corporate directory group. You can use this option if
	//   you have added your corporate identity directory to IAM Identity Center and
	//   associated the IAM Identity Center instance with your S3 Access Grants instance.
	GranteeType GranteeType

	noSmithyDocumentSerde
}

// A container for what Amazon S3 Storage Lens configuration includes.
type Include struct {

	// A container for the S3 Storage Lens bucket includes.
	Buckets []string

	// A container for the S3 Storage Lens Region includes.
	Regions []string

	noSmithyDocumentSerde
}

// A container element for the job configuration and status information returned
// by a Describe Job request.
type JobDescriptor struct {

	// Indicates whether confirmation is required before Amazon S3 begins running the
	// specified job. Confirmation is required only for jobs created through the Amazon
	// S3 console.
	ConfirmationRequired *bool

	// A timestamp indicating when this job was created.
	CreationTime *time.Time

	// The description for this job, if one was provided in this job's Create Job
	// request.
	Description *string

	// If the specified job failed, this field contains information describing the
	// failure.
	FailureReasons []JobFailure

	// The attribute of the JobDescriptor containing details about the job's generated
	// manifest.
	GeneratedManifestDescriptor *S3GeneratedManifestDescriptor

	// The Amazon Resource Name (ARN) for this job.
	JobArn *string

	// The ID for the specified job.
	JobId *string

	// The configuration information for the specified job's manifest object.
	Manifest *JobManifest

	// The manifest generator that was used to generate a job manifest for this job.
	ManifestGenerator JobManifestGenerator

	// The operation that the specified job is configured to run on the objects listed
	// in the manifest.
	Operation *JobOperation

	// The priority of the specified job.
	Priority int32

	// Describes the total number of tasks that the specified job has run, the number
	// of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary

	// Contains the configuration information for the job-completion report if you
	// requested one in the Create Job request.
	Report *JobReport

	// The Amazon Resource Name (ARN) for the Identity and Access Management (IAM)
	// role assigned to run the tasks for this job.
	RoleArn *string

	// The current status of the specified job.
	Status JobStatus

	// The reason for updating the job.
	StatusUpdateReason *string

	// The reason why the specified job was suspended. A job is only suspended if you
	// create it through the Amazon S3 console. When you create the job, it enters the
	// Suspended state to await confirmation before running. After you confirm the job,
	// it automatically exits the Suspended state.
	SuspendedCause *string

	// The timestamp when this job was suspended, if it has been suspended.
	SuspendedDate *time.Time

	// A timestamp indicating when this job terminated. A job's termination date is
	// the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time

	noSmithyDocumentSerde
}

// If this job failed, this element indicates why the job failed.
type JobFailure struct {

	// The failure code, if any, for the specified job.
	FailureCode *string

	// The failure reason, if any, for the specified job.
	FailureReason *string

	noSmithyDocumentSerde
}

// Contains the configuration and status information for a single job retrieved as
// part of a job list.
type JobListDescriptor struct {

	// A timestamp indicating when the specified job was created.
	CreationTime *time.Time

	// The user-specified description that was included in the specified job's Create
	// Job request.
	Description *string

	// The ID for the specified job.
	JobId *string

	// The operation that the specified job is configured to run on every object
	// listed in the manifest.
	Operation OperationName

	// The current priority for the specified job.
	Priority int32

	// Describes the total number of tasks that the specified job has run, the number
	// of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary

	// The specified job's current status.
	Status JobStatus

	// A timestamp indicating when the specified job terminated. A job's termination
	// date is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time

	noSmithyDocumentSerde
}

// Contains the configuration information for a job's manifest.
type JobManifest struct {

	// Contains the information required to locate the specified job's manifest.
	// Manifests can't be imported from directory buckets. For more information, see [Directory buckets].
	//
	// [Directory buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html
	//
	// This member is required.
	Location *JobManifestLocation

	// Describes the format of the specified job's manifest. If the manifest is in CSV
	// format, also describes the columns contained within the manifest.
	//
	// This member is required.
	Spec *JobManifestSpec

	noSmithyDocumentSerde
}

// Configures the type of the job's ManifestGenerator.
//
// The following types satisfy this interface:
//
//	JobManifestGeneratorMemberS3JobManifestGenerator
type JobManifestGenerator interface {
	isJobManifestGenerator()
}

// The S3 job ManifestGenerator's configuration details.
type JobManifestGeneratorMemberS3JobManifestGenerator struct {
	Value S3JobManifestGenerator

	noSmithyDocumentSerde
}

func (*JobManifestGeneratorMemberS3JobManifestGenerator) isJobManifestGenerator() {}

// The filter used to describe a set of objects for the job's manifest.
type JobManifestGeneratorFilter struct {

	// If provided, the generated manifest includes only source bucket objects that
	// were created after this time.
	CreatedAfter *time.Time

	// If provided, the generated manifest includes only source bucket objects that
	// were created before this time.
	CreatedBefore *time.Time

	// Include objects in the generated manifest only if they are eligible for
	// replication according to the Replication configuration on the source bucket.
	EligibleForReplication *bool

	// If provided, the generated manifest includes only source bucket objects whose
	// object keys match the string constraints specified for MatchAnyPrefix ,
	// MatchAnySuffix , and MatchAnySubstring .
	KeyNameConstraint *KeyNameConstraint

	// If provided, the generated object list includes only source bucket objects with
	// the indicated server-side encryption type (SSE-S3, SSE-KMS, DSSE-KMS, SSE-C, or
	// NOT-SSE).
	MatchAnyObjectEncryption []ObjectEncryptionFilter

	// If provided, the generated manifest includes only source bucket objects that
	// are stored with the specified storage class.
	MatchAnyStorageClass []S3StorageClass

	// If provided, the generated manifest includes only source bucket objects that
	// have one of the specified Replication statuses.
	ObjectReplicationStatuses []ReplicationStatus

	// If provided, the generated manifest includes only source bucket objects whose
	// file size is greater than the specified number of bytes.
	ObjectSizeGreaterThanBytes *int64

	// If provided, the generated manifest includes only source bucket objects whose
	// file size is less than the specified number of bytes.
	ObjectSizeLessThanBytes *int64

	noSmithyDocumentSerde
}

// Contains the information required to locate a manifest object. Manifests can't
// be imported from directory buckets. For more information, see [Directory buckets].
//
// [Directory buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html
type JobManifestLocation struct {

	// The ETag for the specified manifest object.
	//
	// This member is required.
	ETag *string

	// The Amazon Resource Name (ARN) for a manifest object.
	//
	// When you're using XML requests, you must replace special characters (such as
	// carriage returns) in object keys with their equivalent XML entity codes. For
	// more information, see [XML-related object key constraints]in the Amazon S3 User Guide.
	//
	// [XML-related object key constraints]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints
	//
	// This member is required.
	ObjectArn *string

	// The optional version ID to identify a specific version of the manifest object.
	ObjectVersionId *string

	noSmithyDocumentSerde
}

// Describes the format of a manifest. If the manifest is in CSV format, also
// describes the columns contained within the manifest.
type JobManifestSpec struct {

	// Indicates which of the available formats the specified manifest uses.
	//
	// This member is required.
	Format JobManifestFormat

	// If the specified manifest object is in the S3BatchOperations_CSV_20180820
	// format, this element describes which columns contain the required data.
	Fields []JobManifestFieldName

	noSmithyDocumentSerde
}

// The operation that you want this job to perform on every object listed in the
// manifest. For more information about the available operations, see [Operations]in the
// Amazon S3 User Guide.
//
// [Operations]: https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html
type JobOperation struct {

	// Directs the specified job to invoke an Lambda function on every object in the
	// manifest.
	LambdaInvoke *LambdaInvokeOperation

	// Directs the specified job to compute checksum values for every object in the
	// manifest.
	S3ComputeObjectChecksum *S3ComputeObjectChecksumOperation

	// Directs the specified job to execute a DELETE Object tagging call on every
	// object in the manifest.
	//
	// This functionality is not supported by directory buckets.
	S3DeleteObjectTagging *S3DeleteObjectTaggingOperation

	// Directs the specified job to initiate restore requests for every archived
	// object in the manifest.
	//
	// This functionality is not supported by directory buckets.
	S3InitiateRestoreObject *S3InitiateRestoreObjectOperation

	// Directs the specified job to run a PutObjectAcl call on every object in the
	// manifest.
	//
	// This functionality is not supported by directory buckets.
	S3PutObjectAcl *S3SetObjectAclOperation

	// Directs the specified job to run a PUT Copy object call on every object in the
	// manifest.
	S3PutObjectCopy *S3CopyObjectOperation

	// Contains the configuration for an S3 Object Lock legal hold operation that an
	// S3 Batch Operations job passes to every object to the underlying
	// PutObjectLegalHold API operation. For more information, see [Using S3 Object Lock legal hold with S3 Batch Operations] in the Amazon S3
	// User Guide.
	//
	// This functionality is not supported by directory buckets.
	//
	// [Using S3 Object Lock legal hold with S3 Batch Operations]: https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html
	S3PutObjectLegalHold *S3SetObjectLegalHoldOperation

	// Contains the configuration parameters for the Object Lock retention action for
	// an S3 Batch Operations job. Batch Operations passes every object to the
	// underlying PutObjectRetention API operation. For more information, see [Using S3 Object Lock retention with S3 Batch Operations] in the
	// Amazon S3 User Guide.
	//
	// This functionality is not supported by directory buckets.
	//
	// [Using S3 Object Lock retention with S3 Batch Operations]: https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html
	S3PutObjectRetention *S3SetObjectRetentionOperation

	// Directs the specified job to run a PUT Object tagging call on every object in
	// the manifest.
	//
	// This functionality is not supported by directory buckets.
	S3PutObjectTagging *S3SetObjectTaggingOperation

	// Directs the specified job to invoke ReplicateObject on every object in the
	// job's manifest.
	//
	// This functionality is not supported by directory buckets.
	S3ReplicateObject *S3ReplicateObjectOperation

	noSmithyDocumentSerde
}

// Describes the total number of tasks that the specified job has started, the
// number of tasks that succeeded, and the number of tasks that failed.
type JobProgressSummary struct {

	//
	NumberOfTasksFailed *int64

	//
	NumberOfTasksSucceeded *int64

	// The JobTimers attribute of a job's progress summary.
	Timers *JobTimers

	//
	TotalNumberOfTasks *int64

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a job-completion report.
type JobReport struct {

	// Indicates whether the specified job will generate a job-completion report.
	//
	// This member is required.
	Enabled bool

	// The Amazon Resource Name (ARN) for the bucket where specified job-completion
	// report will be stored.
	//
	// Directory buckets - Directory buckets aren't supported as a location for Batch
	// Operations to store job completion reports.
	Bucket *string

	// Lists the Amazon Web Services account ID that owns the target bucket, where the
	// completion report is received.
	ExpectedBucketOwner *string

	// The format of the specified job-completion report.
	Format JobReportFormat

	// An optional prefix to describe where in the specified bucket the job-completion
	// report will be stored. Amazon S3 stores the job-completion report at
	// /job-/report.json .
	Prefix *string

	// Indicates whether the job-completion report will include details of all tasks
	// or only failed tasks.
	ReportScope JobReportScope

	noSmithyDocumentSerde
}

// Provides timing details for the job.
type JobTimers struct {

	// Indicates the elapsed time in seconds the job has been in the Active job state.
	ElapsedTimeInActiveSeconds *int64

	noSmithyDocumentSerde
}

// If provided, the generated manifest includes only source bucket objects whose
// object keys match the string constraints specified for MatchAnyPrefix ,
// MatchAnySuffix , and MatchAnySubstring .
type KeyNameConstraint struct {

	// If provided, the generated manifest includes objects where the specified string
	// appears at the start of the object key string. Each KeyNameConstraint filter
	// accepts an array of strings with a length of 1 string.
	MatchAnyPrefix []string

	// If provided, the generated manifest includes objects where the specified string
	// appears anywhere within the object key string. Each KeyNameConstraint filter
	// accepts an array of strings with a length of 1 string.
	MatchAnySubstring []string

	// If provided, the generated manifest includes objects where the specified string
	// appears at the end of the object key string. Each KeyNameConstraint filter
	// accepts an array of strings with a length of 1 string.
	MatchAnySuffix []string

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a Lambda Invoke operation.
type LambdaInvokeOperation struct {

	// The Amazon Resource Name (ARN) for the Lambda function that the specified job
	// will invoke on every object in the manifest.
	FunctionArn *string

	// Specifies the schema version for the payload that Batch Operations sends when
	// invoking an Lambda function. Version 1.0 is the default. Version 2.0 is
	// required when you use Batch Operations to invoke Lambda functions that act on
	// directory buckets, or if you need to specify UserArguments . For more
	// information, see [Automate object processing in Amazon S3 directory buckets with S3 Batch Operations and Lambda]in the Amazon Web Services Storage Blog.
	//
	// Ensure that your Lambda function code expects InvocationSchemaVersion 2.0 and
	// uses bucket name rather than bucket ARN. If the InvocationSchemaVersion does
	// not match what your Lambda function expects, your function might not work as
	// expected.
	//
	// Directory buckets - To initiate Amazon Web Services Lambda function to perform
	// custom actions on objects in directory buckets, you must specify 2.0 .
	//
	// [Automate object processing in Amazon S3 directory buckets with S3 Batch Operations and Lambda]: https://aws.amazon.com/blogs/storage/automate-object-processing-in-amazon-s3-directory-buckets-with-s3-batch-operations-and-aws-lambda/
	InvocationSchemaVersion *string

	// Key-value pairs that are passed in the payload that Batch Operations sends when
	// invoking an Lambda function. You must specify InvocationSchemaVersion 2.0 for
	// LambdaInvoke operations that include UserArguments . For more information, see [Automate object processing in Amazon S3 directory buckets with S3 Batch Operations and Lambda]
	// in the Amazon Web Services Storage Blog.
	//
	// [Automate object processing in Amazon S3 directory buckets with S3 Batch Operations and Lambda]: https://aws.amazon.com/blogs/storage/automate-object-processing-in-amazon-s3-directory-buckets-with-s3-batch-operations-and-aws-lambda/
	UserArguments map[string]string

	noSmithyDocumentSerde
}

// The container for the Outposts bucket lifecycle configuration.
type LifecycleConfiguration struct {

	// A lifecycle rule for individual objects in an Outposts bucket.
	Rules []LifecycleRule

	noSmithyDocumentSerde
}

// The container of the Outposts bucket lifecycle expiration.
type LifecycleExpiration struct {

	// Indicates at what date the object is to be deleted. Should be in GMT ISO 8601
	// format.
	Date *time.Time

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days int32

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired. If set to false,
	// the policy takes no action. This cannot be specified with Days or Date in a
	// Lifecycle Expiration Policy. To learn more about delete markers, see [Working with delete markers].
	//
	// [Working with delete markers]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html
	ExpiredObjectDeleteMarker bool

	noSmithyDocumentSerde
}

// The container for the Outposts bucket lifecycle rule.
type LifecycleRule struct {

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is
	// not currently being applied.
	//
	// This member is required.
	Status ExpirationStatus

	// Specifies the days since the initiation of an incomplete multipart upload that
	// Amazon S3 waits before permanently removing all parts of the upload. For more
	// information, see [Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration]in the Amazon S3 User Guide.
	//
	// [Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload

	// Specifies the expiration for the lifecycle of the object in the form of date,
	// days and, whether the object has a delete marker.
	Expiration *LifecycleExpiration

	// The container for the filter of lifecycle rule.
	Filter *LifecycleRuleFilter

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string

	// The noncurrent version expiration of the lifecycle rule.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration

	//  Specifies the transition rule for the lifecycle rule that describes when
	// noncurrent objects transition to a specific storage class. If your bucket is
	// versioning-enabled (or versioning is suspended), you can set this action to
	// request that Amazon S3 transition noncurrent object versions to a specific
	// storage class at a set period in the object's lifetime.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	NoncurrentVersionTransitions []NoncurrentVersionTransition

	// Specifies when an Amazon S3 object transitions to a specified storage class.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	Transitions []Transition

	noSmithyDocumentSerde
}

// The container for the Outposts bucket lifecycle rule and operator.
type LifecycleRuleAndOperator struct {

	// The non-inclusive minimum object size for the lifecycle rule. Setting this
	// property to 7 means the rule applies to objects with a size that is greater than
	// 7.
	ObjectSizeGreaterThan *int64

	// The non-inclusive maximum object size for the lifecycle rule. Setting this
	// property to 77 means the rule applies to objects with a size that is less than
	// 77.
	ObjectSizeLessThan *int64

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string

	// All of these tags must exist in the object's tag set in order for the rule to
	// apply.
	Tags []S3Tag

	noSmithyDocumentSerde
}

// The container for the filter of the lifecycle rule.
type LifecycleRuleFilter struct {

	// The container for the AND condition for the lifecycle rule.
	And *LifecycleRuleAndOperator

	// Minimum object size to which the rule applies.
	ObjectSizeGreaterThan *int64

	// Maximum object size to which the rule applies.
	ObjectSizeLessThan *int64

	// Prefix identifying one or more objects to which the rule applies.
	//
	// When you're using XML requests, you must replace special characters (such as
	// carriage returns) in object keys with their equivalent XML entity codes. For
	// more information, see [XML-related object key constraints]in the Amazon S3 User Guide.
	//
	// [XML-related object key constraints]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints
	Prefix *string

	// A container for a key-value name pair.
	Tag *S3Tag

	noSmithyDocumentSerde
}

// Information about the access grant.
type ListAccessGrantEntry struct {

	// The Amazon Resource Name (ARN) of the access grant.
	AccessGrantArn *string

	// The ID of the access grant. S3 Access Grants auto-generates this ID when you
	// create the access grant.
	AccessGrantId *string

	// The configuration options of the grant location. The grant location is the S3
	// path to the data to which you are granting access.
	AccessGrantsLocationConfiguration *AccessGrantsLocationConfiguration

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated ID
	// to other locations that you register.
	AccessGrantsLocationId *string

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If the grant includes
	// an application ARN, the grantee can only access the S3 data through this
	// application.
	ApplicationArn *string

	// The date and time when you created the S3 Access Grants instance.
	CreatedAt *time.Time

	// The S3 path of the data to which you are granting access. It is the result of
	// appending the Subprefix to the location scope.
	GrantScope *string

	// The user, group, or role to which you are granting access. You can grant access
	// to an IAM user or role. If you have added your corporate directory to Amazon Web
	// Services IAM Identity Center and associated your Identity Center instance with
	// your S3 Access Grants instance, the grantee can also be a corporate directory
	// user or group.
	Grantee *Grantee

	// The type of access granted to your S3 data, which can be set to one of the
	// following values:
	//
	//   - READ – Grant read-only access to the S3 data.
	//
	//   - WRITE – Grant write-only access to the S3 data.
	//
	//   - READWRITE – Grant both read and write access to the S3 data.
	Permission Permission

	noSmithyDocumentSerde
}

// Information about the S3 Access Grants instance.
type ListAccessGrantsInstanceEntry struct {

	// The Amazon Resource Name (ARN) of the S3 Access Grants instance.
	AccessGrantsInstanceArn *string

	// The ID of the S3 Access Grants instance. The ID is default . You can have one S3
	// Access Grants instance per Region per account.
	AccessGrantsInstanceId *string

	// The date and time when you created the S3 Access Grants instance.
	CreatedAt *time.Time

	// If you associated your S3 Access Grants instance with an Amazon Web Services
	// IAM Identity Center instance, this field returns the Amazon Resource Name (ARN)
	// of the IAM Identity Center instance application; a subresource of the original
	// Identity Center instance. S3 Access Grants creates this Identity Center
	// application for the specific S3 Access Grants instance.
	IdentityCenterApplicationArn *string

	// If you associated your S3 Access Grants instance with an Amazon Web Services
	// IAM Identity Center instance, this field returns the Amazon Resource Name (ARN)
	// of the IAM Identity Center instance application; a subresource of the original
	// Identity Center instance. S3 Access Grants creates this Identity Center
	// application for the specific S3 Access Grants instance.
	//
	// Deprecated: IdentityCenterArn has been deprecated. Use
	// IdentityCenterInstanceArn or IdentityCenterApplicationArn.
	IdentityCenterArn *string

	// The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center
	// instance that you are associating with your S3 Access Grants instance. An IAM
	// Identity Center instance is your corporate identity directory that you added to
	// the IAM Identity Center. You can use the [ListInstances]API operation to retrieve a list of
	// your Identity Center instances and their ARNs.
	//
	// [ListInstances]: https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html
	IdentityCenterInstanceArn *string

	noSmithyDocumentSerde
}

// A container for information about the registered location.
type ListAccessGrantsLocationsEntry struct {

	// The Amazon Resource Name (ARN) of the registered location.
	AccessGrantsLocationArn *string

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated ID
	// to other locations that you register.
	AccessGrantsLocationId *string

	// The date and time when you registered the location.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the IAM role for the registered location. S3
	// Access Grants assumes this role to manage access to the registered location.
	IAMRoleArn *string

	// The S3 path to the location that you are registering. The location scope can be
	// the default S3 location s3:// , the S3 path to a bucket s3:// , or the S3 path
	// to a bucket and prefix s3:/// . A prefix in S3 is a string of characters at the
	// beginning of an object key name used to organize the objects that you store in
	// your S3 buckets. For example, object key names that start with the engineering/
	// prefix or object key names that start with the marketing/campaigns/ prefix.
	LocationScope *string

	noSmithyDocumentSerde
}

// Part of ListCallerAccessGrantsResult . Each entry includes the permission level
// (READ, WRITE, or READWRITE) and the grant scope of the access grant. If the
// grant also includes an application ARN, the grantee can only access the S3 data
// through this application.
type ListCallerAccessGrantsEntry struct {

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If the grant includes
	// an application ARN, the grantee can only access the S3 data through this
	// application.
	ApplicationArn *string

	// The S3 path of the data to which you have been granted access.
	GrantScope *string

	// The type of permission granted, which can be one of the following values:
	//
	//   - READ - Grants read-only access to the S3 data.
	//
	//   - WRITE - Grants write-only access to the S3 data.
	//
	//   - READWRITE - Grants both read and write access to the S3 data.
	Permission Permission

	noSmithyDocumentSerde
}

// Part of ListStorageLensConfigurationResult . Each entry includes the description
// of the S3 Storage Lens configuration, its home Region, whether it is enabled,
// its Amazon Resource Name (ARN), and config ID.
type ListStorageLensConfigurationEntry struct {

	// A container for the S3 Storage Lens home Region. Your metrics data is stored
	// and retained in your designated S3 Storage Lens home Region.
	//
	// This member is required.
	HomeRegion *string

	// A container for the S3 Storage Lens configuration ID.
	//
	// This member is required.
	Id *string

	// The ARN of the S3 Storage Lens configuration. This property is read-only.
	//
	// This member is required.
	StorageLensArn *string

	// A container for whether the S3 Storage Lens configuration is enabled. This
	// property is required.
	IsEnabled bool

	noSmithyDocumentSerde
}

//	Each entry contains a Storage Lens group that exists in the specified home
//
// Region.
type ListStorageLensGroupEntry struct {

	//  Contains the Amazon Web Services Region where the Storage Lens group was
	// created.
	//
	// This member is required.
	HomeRegion *string

	//  Contains the name of the Storage Lens group that exists in the specified home
	// Region.
	//
	// This member is required.
	Name *string

	//  Contains the Amazon Resource Name (ARN) of the Storage Lens group. This
	// property is read-only.
	//
	// This member is required.
	StorageLensGroupArn *string

	noSmithyDocumentSerde
}

//	A filter condition that specifies the object age range of included objects in
//
// days. Only integers are supported.
type MatchObjectAge struct {

	//  Specifies the maximum object age in days. Must be a positive whole number,
	// greater than the minimum object age and less than or equal to 2,147,483,647.
	DaysGreaterThan int32

	//  Specifies the minimum object age in days. The value must be a positive whole
	// number, greater than 0 and less than or equal to 2,147,483,647.
	DaysLessThan int32

	noSmithyDocumentSerde
}

//	A filter condition that specifies the object size range of included objects in
//
// bytes. Only integers are supported.
type MatchObjectSize struct {

	//  Specifies the minimum object size in Bytes. The value must be a positive
	// number, greater than 0 and less than 50 TB.
	BytesGreaterThan int64

	//  Specifies the maximum object size in Bytes. The value must be a positive
	// number, greater than the minimum object size and less than 50 TB.
	BytesLessThan int64

	noSmithyDocumentSerde
}

// A container that specifies replication metrics-related settings.
type Metrics struct {

	// Specifies whether replication metrics are enabled.
	//
	// This member is required.
	Status MetricsStatus

	// A container that specifies the time threshold for emitting the
	// s3:Replication:OperationMissedThreshold event.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	EventThreshold *ReplicationTimeValue

	noSmithyDocumentSerde
}

// The Multi-Region Access Point access control policy.
//
// When you update the policy, the update is first listed as the proposed policy.
// After the update is finished and all Regions have been updated, the proposed
// policy is listed as the established policy. If both policies have the same
// version number, the proposed policy is the established policy.
type MultiRegionAccessPointPolicyDocument struct {

	// The last established policy for the Multi-Region Access Point.
	Established *EstablishedMultiRegionAccessPointPolicy

	// The proposed policy for the Multi-Region Access Point.
	Proposed *ProposedMultiRegionAccessPointPolicy

	noSmithyDocumentSerde
}

// Status information for a single Multi-Region Access Point Region.
type MultiRegionAccessPointRegionalResponse struct {

	// The name of the Region in the Multi-Region Access Point.
	Name *string

	// The current status of the Multi-Region Access Point in this Region.
	RequestStatus *string

	noSmithyDocumentSerde
}

// A collection of statuses for a Multi-Region Access Point in the various Regions
// it supports.
type MultiRegionAccessPointReport struct {

	// The alias for the Multi-Region Access Point. For more information about the
	// distinction between the name and the alias of an Multi-Region Access Point, see [Rules for naming Amazon S3 Multi-Region Access Points]
	// .
	//
	// [Rules for naming Amazon S3 Multi-Region Access Points]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming
	Alias *string

	// When the Multi-Region Access Point create request was received.
	CreatedAt *time.Time

	// The name of the Multi-Region Access Point.
	Name *string

	// The PublicAccessBlock configuration that you want to apply to this Amazon S3
	// account. You can enable the configuration options in any combination. For more
	// information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"]in
	// the Amazon S3 User Guide.
	//
	// This data type is not supported for Amazon S3 on Outposts.
	//
	// [The Meaning of "Public"]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status
	PublicAccessBlock *PublicAccessBlockConfiguration

	// A collection of the Regions and buckets associated with the Multi-Region Access
	// Point.
	Regions []RegionReport

	// The current status of the Multi-Region Access Point.
	//
	// CREATING and DELETING are temporary states that exist while the request is
	// propagating and being completed. If a Multi-Region Access Point has a status of
	// PARTIALLY_CREATED , you can retry creation or send a request to delete the
	// Multi-Region Access Point. If a Multi-Region Access Point has a status of
	// PARTIALLY_DELETED , you can retry a delete request to finish the deletion of the
	// Multi-Region Access Point.
	Status MultiRegionAccessPointStatus

	noSmithyDocumentSerde
}

// A structure for a Multi-Region Access Point that indicates where Amazon S3
// traffic can be routed. Routes can be either active or passive. Active routes can
// process Amazon S3 requests through the Multi-Region Access Point, but passive
// routes are not eligible to process Amazon S3 requests.
//
// Each route contains the Amazon S3 bucket name and the Amazon Web Services
// Region that the bucket is located in. The route also includes the
// TrafficDialPercentage value, which shows whether the bucket and Region are
// active (indicated by a value of 100 ) or passive (indicated by a value of 0 ).
type MultiRegionAccessPointRoute struct {

	// The traffic state for the specified bucket or Amazon Web Services Region.
	//
	// A value of 0 indicates a passive state, which means that no new traffic will be
	// routed to the Region.
	//
	// A value of 100 indicates an active state, which means that traffic will be
	// routed to the specified Region.
	//
	// When the routing configuration for a Region is changed from active to passive,
	// any in-progress operations (uploads, copies, deletes, and so on) to the formerly
	// active Region will continue to run to until a final success or failure status is
	// reached.
	//
	// If all Regions in the routing configuration are designated as passive, you'll
	// receive an InvalidRequest error.
	//
	// This member is required.
	TrafficDialPercentage *int32

	// The name of the Amazon S3 bucket for which you'll submit a routing
	// configuration change. Either the Bucket or the Region value must be provided.
	// If both are provided, the bucket must be in the specified Region.
	Bucket *string

	// The Amazon Web Services Region to which you'll be submitting a routing
	// configuration change. Either the Bucket or the Region value must be provided.
	// If both are provided, the bucket must be in the specified Region.
	Region *string

	noSmithyDocumentSerde
}

// The Multi-Region Access Point details that are returned when querying about an
// asynchronous request.
type MultiRegionAccessPointsAsyncResponse struct {

	// A collection of status information for the different Regions that a
	// Multi-Region Access Point supports.
	Regions []MultiRegionAccessPointRegionalResponse

	noSmithyDocumentSerde
}

// The container of the noncurrent version expiration.
type NoncurrentVersionExpiration struct {

	// Specifies how many noncurrent versions S3 on Outposts will retain. If there are
	// this many more recent noncurrent versions, S3 on Outposts will take the
	// associated action. For more information about noncurrent versions, see [Lifecycle configuration elements]in the
	// Amazon S3 User Guide.
	//
	// [Lifecycle configuration elements]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html
	NewerNoncurrentVersions *int32

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see [How Amazon S3 Calculates When an Object Became Noncurrent]in the Amazon S3 User Guide.
	//
	// [How Amazon S3 Calculates When an Object Became Noncurrent]: https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations
	NoncurrentDays int32

	noSmithyDocumentSerde
}

// The container for the noncurrent version transition.
type NoncurrentVersionTransition struct {

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see [How Amazon S3 Calculates How Long an Object Has Been Noncurrent]in the Amazon S3 User Guide.
	//
	// [How Amazon S3 Calculates How Long an Object Has Been Noncurrent]: https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations
	NoncurrentDays int32

	// The class of storage used to store the object.
	StorageClass TransitionStorageClass

	noSmithyDocumentSerde
}

// A filter that returns objects that aren't server-side encrypted.
type NotSSEFilter struct {
	noSmithyDocumentSerde
}

// An optional filter for the S3JobManifestGenerator that identifies the subset of
// objects by encryption type.
//
// The following types satisfy this interface:
//
//	ObjectEncryptionFilterMemberDSSEKMS
//	ObjectEncryptionFilterMemberNOTSSE
//	ObjectEncryptionFilterMemberSSEC
//	ObjectEncryptionFilterMemberSSEKMS
//	ObjectEncryptionFilterMemberSSES3
type ObjectEncryptionFilter interface {
	isObjectEncryptionFilter()
}

// Filters for objects that are encrypted by dual-layer server-side encryption
// with Amazon Web Services Key Management Service (KMS) keys (DSSE-KMS).
type ObjectEncryptionFilterMemberDSSEKMS struct {
	Value DSSEKMSFilter

	noSmithyDocumentSerde
}

func (*ObjectEncryptionFilterMemberDSSEKMS) isObjectEncryptionFilter() {}

// Filters for objects that are not encrypted by server-side encryption.
type ObjectEncryptionFilterMemberNOTSSE struct {
	Value NotSSEFilter

	noSmithyDocumentSerde
}

func (*ObjectEncryptionFilterMemberNOTSSE) isObjectEncryptionFilter() {}

// Filters for objects that are encrypted by server-side encryption with
// customer-provided keys (SSE-C).
type ObjectEncryptionFilterMemberSSEC struct {
	Value SSECFilter

	noSmithyDocumentSerde
}

func (*ObjectEncryptionFilterMemberSSEC) isObjectEncryptionFilter() {}

// Filters for objects that are encrypted by server-side encryption with Amazon
// Web Services Key Management Service (KMS) keys (SSE-KMS).
type ObjectEncryptionFilterMemberSSEKMS struct {
	Value SSEKMSFilter

	noSmithyDocumentSerde
}

func (*ObjectEncryptionFilterMemberSSEKMS) isObjectEncryptionFilter() {}

// Filters for objects that are encrypted by server-side encryption with Amazon S3
// managed keys (SSE-S3).
type ObjectEncryptionFilterMemberSSES3 struct {
	Value SSES3Filter

	noSmithyDocumentSerde
}

func (*ObjectEncryptionFilterMemberSSES3) isObjectEncryptionFilter() {}

// An access point with an attached Lambda function used to access transformed
// data from an Amazon S3 bucket.
type ObjectLambdaAccessPoint struct {

	// The name of the Object Lambda Access Point.
	//
	// This member is required.
	Name *string

	// The alias of the Object Lambda Access Point.
	Alias *ObjectLambdaAccessPointAlias

	// Specifies the ARN for the Object Lambda Access Point.
	ObjectLambdaAccessPointArn *string

	noSmithyDocumentSerde
}

// The alias of an Object Lambda Access Point. For more information, see [How to use a bucket-style alias for your S3 bucket Object Lambda Access Point].
//
// [How to use a bucket-style alias for your S3 bucket Object Lambda Access Point]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-use.html#ol-access-points-alias
type ObjectLambdaAccessPointAlias struct {

	// The status of the Object Lambda Access Point alias. If the status is
	// PROVISIONING , the Object Lambda Access Point is provisioning the alias and the
	// alias is not ready for use yet. If the status is READY , the Object Lambda
	// Access Point alias is successfully provisioned and ready for use.
	Status ObjectLambdaAccessPointAliasStatus

	// The alias value of the Object Lambda Access Point.
	Value *string

	noSmithyDocumentSerde
}

// A configuration used when creating an Object Lambda Access Point.
type ObjectLambdaConfiguration struct {

	// Standard access point associated with the Object Lambda Access Point.
	//
	// This member is required.
	SupportingAccessPoint *string

	// A container for transformation configurations for an Object Lambda Access Point.
	//
	// This member is required.
	TransformationConfigurations []ObjectLambdaTransformationConfiguration

	// A container for allowed features. Valid inputs are GetObject-Range ,
	// GetObject-PartNumber , HeadObject-Range , and HeadObject-PartNumber .
	AllowedFeatures []ObjectLambdaAllowedFeature

	// A container for whether the CloudWatch metrics configuration is enabled.
	CloudWatchMetricsEnabled bool

	noSmithyDocumentSerde
}

// A container for AwsLambdaTransformation.
//
// The following types satisfy this interface:
//
//	ObjectLambdaContentTransformationMemberAwsLambda
type ObjectLambdaContentTransformation interface {
	isObjectLambdaContentTransformation()
}

// A container for an Lambda function.
type ObjectLambdaContentTransformationMemberAwsLambda struct {
	Value AwsLambdaTransformation

	noSmithyDocumentSerde
}

func (*ObjectLambdaContentTransformationMemberAwsLambda) isObjectLambdaContentTransformation() {}

// A configuration used when creating an Object Lambda Access Point transformation.
type ObjectLambdaTransformationConfiguration struct {

	// A container for the action of an Object Lambda Access Point configuration.
	// Valid inputs are GetObject , ListObjects , HeadObject , and ListObjectsV2 .
	//
	// This member is required.
	Actions []ObjectLambdaTransformationConfigurationAction

	// A container for the content transformation of an Object Lambda Access Point
	// configuration.
	//
	// This member is required.
	ContentTransformation ObjectLambdaContentTransformation

	noSmithyDocumentSerde
}

// Indicates whether this access point policy is public. For more information
// about how Amazon S3 evaluates policies to determine whether they are public, see
// [The Meaning of "Public"]in the Amazon S3 User Guide.
//
// [The Meaning of "Public"]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status
type PolicyStatus struct {

	//
	IsPublic bool

	noSmithyDocumentSerde
}

// A container for the prefix-level configuration.
type PrefixLevel struct {

	// A container for the prefix-level storage metrics for S3 Storage Lens.
	//
	// This member is required.
	StorageMetrics *PrefixLevelStorageMetrics

	noSmithyDocumentSerde
}

// A container for the prefix-level storage metrics for S3 Storage Lens.
type PrefixLevelStorageMetrics struct {

	// A container for whether prefix-level storage metrics are enabled.
	IsEnabled bool

	//
	SelectionCriteria *SelectionCriteria

	noSmithyDocumentSerde
}

// The proposed access control policy for the Multi-Region Access Point.
//
// When you update the policy, the update is first listed as the proposed policy.
// After the update is finished and all Regions have been updated, the proposed
// policy is listed as the established policy. If both policies have the same
// version number, the proposed policy is the established policy.
type ProposedMultiRegionAccessPointPolicy struct {

	// The details of the proposed policy.
	Policy *string

	noSmithyDocumentSerde
}

// The PublicAccessBlock configuration that you want to apply to this Amazon S3
// account. You can enable the configuration options in any combination. For more
// information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"]in
// the Amazon S3 User Guide.
//
// This data type is not supported for Amazon S3 on Outposts.
//
// [The Meaning of "Public"]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status
type PublicAccessBlockConfiguration struct {

	// Specifies whether Amazon S3 should block public access control lists (ACLs) for
	// buckets in this account. Setting this element to TRUE causes the following
	// behavior:
	//
	//   - PutBucketAcl and PutObjectAcl calls fail if the specified ACL is public.
	//
	//   - PUT Object calls fail if the request includes a public ACL.
	//
	//   - PUT Bucket calls fail if the request includes a public ACL.
	//
	// Enabling this setting doesn't affect existing policies or ACLs.
	//
	// This property is not supported for Amazon S3 on Outposts.
	BlockPublicAcls *bool

	// Specifies whether Amazon S3 should block public bucket policies for buckets in
	// this account. Setting this element to TRUE causes Amazon S3 to reject calls to
	// PUT Bucket policy if the specified bucket policy allows public access.
	//
	// Enabling this setting doesn't affect existing bucket policies.
	//
	// This property is not supported for Amazon S3 on Outposts.
	BlockPublicPolicy *bool

	// Specifies whether Amazon S3 should ignore public ACLs for buckets in this
	// account. Setting this element to TRUE causes Amazon S3 to ignore all public
	// ACLs on buckets in this account and any objects that they contain.
	//
	// Enabling this setting doesn't affect the persistence of any existing ACLs and
	// doesn't prevent new public ACLs from being set.
	//
	// This property is not supported for Amazon S3 on Outposts.
	IgnorePublicAcls *bool

	// Specifies whether Amazon S3 should restrict public bucket policies for buckets
	// in this account. Setting this element to TRUE restricts access to buckets with
	// public policies to only Amazon Web Services service principals and authorized
	// users within this account.
	//
	// Enabling this setting doesn't affect previously stored bucket policies, except
	// that public and cross-account access within any public bucket policy, including
	// non-public delegation to specific accounts, is blocked.
	//
	// This property is not supported for Amazon S3 on Outposts.
	RestrictPublicBuckets *bool

	noSmithyDocumentSerde
}

// A container for the information associated with a [PutMultiRegionAccessPoint] request.
//
// [PutMultiRegionAccessPoint]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html
type PutMultiRegionAccessPointPolicyInput struct {

	// The name of the Multi-Region Access Point associated with the request.
	//
	// This member is required.
	Name *string

	// The policy details for the PutMultiRegionAccessPoint request.
	//
	// This member is required.
	Policy *string

	noSmithyDocumentSerde
}

// A Region that supports a Multi-Region Access Point as well as the associated
// bucket for the Region.
type Region struct {

	// The name of the associated bucket for the Region.
	//
	// This member is required.
	Bucket *string

	// The Amazon Web Services account ID that owns the Amazon S3 bucket that's
	// associated with this Multi-Region Access Point.
	BucketAccountId *string

	noSmithyDocumentSerde
}

// The container for the regional bucket.
type RegionalBucket struct {

	//
	//
	// This member is required.
	Bucket *string

	// The creation date of the regional bucket
	//
	// This member is required.
	CreationDate *time.Time

	//
	//
	// This member is required.
	PublicAccessBlockEnabled bool

	// The Amazon Resource Name (ARN) for the regional bucket.
	BucketArn *string

	// The Outposts ID of the regional bucket.
	OutpostId *string

	noSmithyDocumentSerde
}

// A combination of a bucket and Region that's part of a Multi-Region Access Point.
type RegionReport struct {

	// The name of the bucket.
	Bucket *string

	// The Amazon Web Services account ID that owns the Amazon S3 bucket that's
	// associated with this Multi-Region Access Point.
	BucketAccountId *string

	// The name of the Region.
	Region *string

	noSmithyDocumentSerde
}

// A filter that you can use to specify whether replica modification sync is
// enabled. S3 on Outposts replica modification sync can help you keep object
// metadata synchronized between replicas and source objects. By default, S3 on
// Outposts replicates metadata from the source objects to the replicas only. When
// replica modification sync is enabled, S3 on Outposts replicates metadata changes
// made to the replica copies back to the source object, making the replication
// bidirectional.
//
// To replicate object metadata modifications on replicas, you can specify this
// element and set the Status of this element to Enabled .
//
// You must enable replica modification sync on the source and destination buckets
// to replicate replica metadata changes between the source and the replicas.
type ReplicaModifications struct {

	// Specifies whether S3 on Outposts replicates modifications to object metadata on
	// replicas.
	//
	// This member is required.
	Status ReplicaModificationsStatus

	noSmithyDocumentSerde
}

// A container for one or more replication rules. A replication configuration must
// have at least one rule and you can add up to 100 rules. The maximum size of a
// replication configuration is 128 KB.
type ReplicationConfiguration struct {

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// that S3 on Outposts assumes when replicating objects. For information about S3
	// replication on Outposts configuration, see [Setting up replication]in the Amazon S3 User Guide.
	//
	// [Setting up replication]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-how-setup.html
	//
	// This member is required.
	Role *string

	// A container for one or more replication rules. A replication configuration must
	// have at least one rule and can contain an array of 100 rules at the most.
	//
	// This member is required.
	Rules []ReplicationRule

	noSmithyDocumentSerde
}

// Specifies which S3 on Outposts objects to replicate and where to store the
// replicas.
type ReplicationRule struct {

	// The Amazon Resource Name (ARN) of the access point for the source Outposts
	// bucket that you want S3 on Outposts to replicate the objects from.
	//
	// This member is required.
	Bucket *string

	// A container for information about the replication destination and its
	// configurations.
	//
	// This member is required.
	Destination *Destination

	// Specifies whether the rule is enabled.
	//
	// This member is required.
	Status ReplicationRuleStatus

	// Specifies whether S3 on Outposts replicates delete markers. If you specify a
	// Filter element in your replication configuration, you must also include a
	// DeleteMarkerReplication element. If your Filter includes a Tag element, the
	// DeleteMarkerReplication element's Status child element must be set to Disabled ,
	// because S3 on Outposts doesn't support replicating delete markers for tag-based
	// rules.
	//
	// For more information about delete marker replication, see [How delete operations affect replication] in the Amazon S3
	// User Guide.
	//
	// [How delete operations affect replication]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated
	DeleteMarkerReplication *DeleteMarkerReplication

	// An optional configuration to replicate existing source bucket objects.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ExistingObjectReplication *ExistingObjectReplication

	// A filter that identifies the subset of objects to which the replication rule
	// applies. A Filter element must specify exactly one Prefix , Tag , or And child
	// element.
	Filter *ReplicationRuleFilter

	// A unique identifier for the rule. The maximum value is 255 characters.
	ID *string

	// An object key name prefix that identifies the object or objects to which the
	// rule applies. The maximum prefix length is 1,024 characters. To include all
	// objects in an Outposts bucket, specify an empty string.
	//
	// When you're using XML requests, you must replace special characters (such as
	// carriage returns) in object keys with their equivalent XML entity codes. For
	// more information, see [XML-related object key constraints]in the Amazon S3 User Guide.
	//
	// [XML-related object key constraints]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints
	//
	// Deprecated: Prefix has been deprecated
	Prefix *string

	// The priority indicates which rule has precedence whenever two or more
	// replication rules conflict. S3 on Outposts attempts to replicate objects
	// according to all replication rules. However, if there are two or more rules with
	// the same destination Outposts bucket, then objects will be replicated according
	// to the rule with the highest priority. The higher the number, the higher the
	// priority.
	//
	// For more information, see [Creating replication rules on Outposts] in the Amazon S3 User Guide.
	//
	// [Creating replication rules on Outposts]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-between-outposts.html
	Priority *int32

	// A container that describes additional filters for identifying the source
	// Outposts objects that you want to replicate. You can choose to enable or disable
	// the replication of these objects.
	SourceSelectionCriteria *SourceSelectionCriteria

	noSmithyDocumentSerde
}

// A container for specifying rule filters. The filters determine the subset of
// objects to which the rule applies. This element is required only if you specify
// more than one filter.
//
// For example:
//
//   - If you specify both a Prefix and a Tag filter, wrap these filters in an And
//     element.
//
//   - If you specify a filter based on multiple tags, wrap the Tag elements in an
//     And element.
type ReplicationRuleAndOperator struct {

	// An object key name prefix that identifies the subset of objects that the rule
	// applies to.
	Prefix *string

	// An array of tags that contain key and value pairs.
	Tags []S3Tag

	noSmithyDocumentSerde
}

// A filter that identifies the subset of objects to which the replication rule
// applies. A Filter element must specify exactly one Prefix , Tag , or And child
// element.
type ReplicationRuleFilter struct {

	// A container for specifying rule filters. The filters determine the subset of
	// objects that the rule applies to. This element is required only if you specify
	// more than one filter. For example:
	//
	//   - If you specify both a Prefix and a Tag filter, wrap these filters in an And
	//   element.
	//
	//   - If you specify a filter based on multiple tags, wrap the Tag elements in an
	//   And element.
	And *ReplicationRuleAndOperator

	// An object key name prefix that identifies the subset of objects that the rule
	// applies to.
	//
	// When you're using XML requests, you must replace special characters (such as
	// carriage returns) in object keys with their equivalent XML entity codes. For
	// more information, see [XML-related object key constraints]in the Amazon S3 User Guide.
	//
	// [XML-related object key constraints]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints
	Prefix *string

	// A container for a key-value name pair.
	Tag *S3Tag

	noSmithyDocumentSerde
}

// A container that specifies S3 Replication Time Control (S3 RTC) related
// information, including whether S3 RTC is enabled and the time when all objects
// and operations on objects must be replicated.
//
// This is not supported by Amazon S3 on Outposts buckets.
type ReplicationTime struct {

	// Specifies whether S3 Replication Time Control (S3 RTC) is enabled.
	//
	// This member is required.
	Status ReplicationTimeStatus

	// A container that specifies the time by which replication should be complete for
	// all objects and operations on objects.
	//
	// This member is required.
	Time *ReplicationTimeValue

	noSmithyDocumentSerde
}

// A container that specifies the time value for S3 Replication Time Control (S3
// RTC). This value is also used for the replication metrics EventThreshold
// element.
//
// This is not supported by Amazon S3 on Outposts buckets.
type ReplicationTimeValue struct {

	// Contains an integer that specifies the time period in minutes.
	//
	// Valid value: 15
	Minutes *int32

	noSmithyDocumentSerde
}

type S3AccessControlList struct {

	//
	//
	// This member is required.
	Owner *S3ObjectOwner

	//
	Grants []S3Grant

	noSmithyDocumentSerde
}

type S3AccessControlPolicy struct {

	//
	AccessControlList *S3AccessControlList

	//
	CannedAccessControlList S3CannedAccessControlList

	noSmithyDocumentSerde
}

// A container for the bucket where the Amazon S3 Storage Lens metrics export
// files are located.
type S3BucketDestination struct {

	// The account ID of the owner of the S3 Storage Lens metrics export bucket.
	//
	// This member is required.
	AccountId *string

	// The Amazon Resource Name (ARN) of the bucket. This property is read-only and
	// follows the following format:
	// arn:aws:s3:us-east-1:example-account-id:bucket/your-destination-bucket-name
	//
	// This member is required.
	Arn *string

	//
	//
	// This member is required.
	Format Format

	// The schema version of the export file.
	//
	// This member is required.
	OutputSchemaVersion OutputSchemaVersion

	// The container for the type encryption of the metrics exports in this bucket.
	Encryption *StorageLensDataExportEncryption

	// The prefix of the destination bucket where the metrics export will be delivered.
	Prefix *string

	noSmithyDocumentSerde
}

// Directs the specified job to invoke the ComputeObjectChecksum operation on
// every object listed in the job's manifest.
type S3ComputeObjectChecksumOperation struct {

	// Indicates the algorithm that you want Amazon S3 to use to create the checksum.
	// For more information, see [Checking object integrity]in the Amazon S3 User Guide.
	//
	// [Checking object integrity]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html
	ChecksumAlgorithm ComputeObjectChecksumAlgorithm

	// Indicates the checksum type that you want Amazon S3 to use to calculate the
	// object's checksum value. For more information, see [Checking object integrity]in the Amazon S3 User Guide.
	//
	// [Checking object integrity]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html
	ChecksumType ComputeObjectChecksumType

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a PUT Copy object operation. S3 Batch
// Operations passes every object to the underlying CopyObject API operation. For
// more information about the parameters for this operation, see [CopyObject].
//
// [CopyObject]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html
type S3CopyObjectOperation struct {

	// This functionality is not supported by directory buckets.
	AccessControlGrants []S3Grant

	// Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption
	// with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting
	// this header to true causes Amazon S3 to use an S3 Bucket Key for object
	// encryption with SSE-KMS.
	//
	// Specifying this header with an Copy action doesn’t affect bucket-level settings
	// for S3 Bucket Key.
	//
	// Directory buckets - S3 Bucket Keys aren't supported, when you copy SSE-KMS
	// encrypted objects from general purpose buckets to directory buckets, from
	// directory buckets to general purpose buckets, or between directory buckets,
	// through [the Copy operation in Batch Operations]. In this case, Amazon S3 makes a call to KMS every time a copy request
	// is made for a KMS-encrypted object.
	//
	// [the Copy operation in Batch Operations]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops
	BucketKeyEnabled bool

	// This functionality is not supported by directory buckets.
	CannedAccessControlList S3CannedAccessControlList

	// Indicates the algorithm that you want Amazon S3 to use to create the checksum.
	// For more information, see [Checking object integrity]in the Amazon S3 User Guide.
	//
	// [Checking object integrity]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html
	ChecksumAlgorithm S3ChecksumAlgorithm

	//
	MetadataDirective S3MetadataDirective

	//
	ModifiedSinceConstraint *time.Time

	// If you don't provide this parameter, Amazon S3 copies all the metadata from the
	// original objects. If you specify an empty set, the new objects will have no
	// tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.
	NewObjectMetadata *S3ObjectMetadata

	// Specifies a list of tags to add to the destination objects after they are
	// copied. If NewObjectTagging is not specified, the tags of the source objects
	// are copied to destination objects by default.
	//
	// Directory buckets - Tags aren't supported by directory buckets. If your source
	// objects have tags and your destination bucket is a directory bucket, specify an
	// empty tag set in the NewObjectTagging field to prevent copying the source
	// object tags to the directory bucket.
	NewObjectTagging []S3Tag

	// The legal hold status to be applied to all objects in the Batch Operations job.
	//
	// This functionality is not supported by directory buckets.
	ObjectLockLegalHoldStatus S3ObjectLockLegalHoldStatus

	// The retention mode to be applied to all objects in the Batch Operations job.
	//
	// This functionality is not supported by directory buckets.
	ObjectLockMode S3ObjectLockMode

	// The date when the applied object retention configuration expires on all objects
	// in the Batch Operations job.
	//
	// This functionality is not supported by directory buckets.
	ObjectLockRetainUntilDate *time.Time

	// If the destination bucket is configured as a website, specifies an optional
	// metadata property for website redirects, x-amz-website-redirect-location .
	// Allows webpage redirects if the object copy is accessed through a website
	// endpoint.
	//
	// This functionality is not supported by directory buckets.
	RedirectLocation *string

	// This functionality is not supported by directory buckets.
	RequesterPays bool

	// Specifies the KMS key ID (Key ID, Key ARN, or Key Alias) to use for object
	// encryption. If the KMS key doesn't exist in the same account that's issuing the
	// command, you must use the full Key ARN not the Key ID.
	//
	// Directory buckets - If you specify SSEAlgorithm with KMS , you must specify the
	// SSEAwsKmsKeyId parameter with the ID (Key ID or Key ARN) of the KMS symmetric
	// encryption customer managed key to use. Otherwise, you get an HTTP 400 Bad
	// Request error. The key alias format of the KMS key isn't supported. To encrypt
	// new object copies in a directory bucket with SSE-KMS, you must specify SSE-KMS
	// as the directory bucket's default encryption configuration with a KMS key
	// (specifically, a [customer managed key]). The [Amazon Web Services managed key] ( aws/s3 ) isn't supported. Your SSE-KMS configuration
	// can only support 1 [customer managed key]per directory bucket for the lifetime of the bucket. After
	// you specify a customer managed key for SSE-KMS as the bucket default encryption,
	// you can't override the customer managed key for the bucket's SSE-KMS
	// configuration. Then, when you specify server-side encryption settings for new
	// object copies with SSE-KMS, you must make sure the encryption key is the same
	// customer managed key that you specified for the directory bucket's default
	// encryption configuration.
	//
	// [customer managed key]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk
	// [Amazon Web Services managed key]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk
	SSEAwsKmsKeyId *string

	// Specify the storage class for the destination objects in a Copy operation.
	//
	// Directory buckets - This functionality is not supported by directory buckets.
	StorageClass S3StorageClass

	// Specifies the folder prefix that you want the objects to be copied into. For
	// example, to copy objects into a folder named Folder1 in the destination bucket,
	// set the TargetKeyPrefix property to Folder1 .
	TargetKeyPrefix *string

	// Specifies the destination bucket Amazon Resource Name (ARN) for the batch copy
	// operation.
	//
	//   - General purpose buckets - For example, to copy objects to a general purpose
	//   bucket named destinationBucket , set the TargetResource property to
	//   arn:aws:s3:::destinationBucket .
	//
	//   - Directory buckets - For example, to copy objects to a directory bucket
	//   named destinationBucket in the Availability Zone identified by the AZ ID
	//   usw2-az1 , set the TargetResource property to
	//   arn:aws:s3express:region:account_id:/bucket/destination_bucket_base_name--usw2-az1--x-s3
	//   . A directory bucket as a destination bucket can be in Availability Zone or
	//   Local Zone.
	//
	// Copying objects across different Amazon Web Services Regions isn't supported
	//   when the source or destination bucket is in Amazon Web Services Local Zones. The
	//   source and destination buckets must have the same parent Amazon Web Services
	//   Region. Otherwise, you get an HTTP 400 Bad Request error with the error code
	//   InvalidRequest .
	TargetResource *string

	//
	UnModifiedSinceConstraint *time.Time

	noSmithyDocumentSerde
}

// Contains no configuration parameters because the DELETE Object tagging (
// DeleteObjectTagging ) API operation accepts only the bucket name and key name as
// parameters, which are defined in the job's manifest.
type S3DeleteObjectTaggingOperation struct {
	noSmithyDocumentSerde
}

// Describes the specified job's generated manifest. Batch Operations jobs created
// with a ManifestGenerator populate details of this descriptor after execution of
// the ManifestGenerator.
type S3GeneratedManifestDescriptor struct {

	// The format of the generated manifest.
	Format GeneratedManifestFormat

	// Contains the information required to locate a manifest object. Manifests can't
	// be imported from directory buckets. For more information, see [Directory buckets].
	//
	// [Directory buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html
	Location *JobManifestLocation

	noSmithyDocumentSerde
}

type S3Grant struct {

	//
	Grantee *S3Grantee

	//
	Permission S3Permission

	noSmithyDocumentSerde
}

type S3Grantee struct {

	//
	DisplayName *string

	//
	Identifier *string

	//
	TypeIdentifier S3GranteeTypeIdentifier

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a POST Object restore job. S3 Batch
// Operations passes every object to the underlying RestoreObject API operation.
// For more information about the parameters for this operation, see [RestoreObject].
//
// [RestoreObject]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request
type S3InitiateRestoreObjectOperation struct {

	// This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive
	// object remains available in Amazon S3. S3 Initiate Restore Object jobs that
	// target S3 Glacier and S3 Glacier Deep Archive objects require ExpirationInDays
	// set to 1 or greater.
	//
	// Conversely, do not set ExpirationInDays when creating S3 Initiate Restore
	// Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive
	// Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are
	// not subject to restore expiry, so specifying ExpirationInDays results in
	// restore request failure.
	//
	// S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier Deep
	// Archive storage class objects or on S3 Intelligent-Tiering Archive Access and
	// Deep Archive Access storage tier objects, but not both types in the same job. If
	// you need to restore objects of both types you must create separate Batch
	// Operations jobs.
	ExpirationInDays *int32

	// S3 Batch Operations supports STANDARD and BULK retrieval tiers, but not the
	// EXPEDITED retrieval tier.
	GlacierJobTier S3GlacierJobTier

	noSmithyDocumentSerde
}

// The container for the service that will create the S3 manifest.
type S3JobManifestGenerator struct {

	// Determines whether or not to write the job's generated manifest to a bucket.
	//
	// This member is required.
	EnableManifestOutput bool

	// The ARN of the source bucket used by the ManifestGenerator.
	//
	// Directory buckets - Directory buckets aren't supported as the source buckets
	// used by S3JobManifestGenerator to generate the job manifest.
	//
	// This member is required.
	SourceBucket *string

	// The Amazon Web Services account ID that owns the bucket the generated manifest
	// is written to. If provided the generated manifest bucket's owner Amazon Web
	// Services account ID must match this value, else the job fails.
	ExpectedBucketOwner *string

	// Specifies rules the S3JobManifestGenerator should use to decide whether an
	// object in the source bucket should or should not be included in the generated
	// job manifest.
	Filter *JobManifestGeneratorFilter

	// Specifies the location the generated manifest will be written to. Manifests
	// can't be written to directory buckets. For more information, see [Directory buckets].
	//
	// [Directory buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html
	ManifestOutputLocation *S3ManifestOutputLocation

	noSmithyDocumentSerde
}

// Location details for where the generated manifest should be written.
type S3ManifestOutputLocation struct {

	// The bucket ARN the generated manifest should be written to.
	//
	// Directory buckets - Directory buckets aren't supported as the buckets to store
	// the generated manifest.
	//
	// This member is required.
	Bucket *string

	// The format of the generated manifest.
	//
	// This member is required.
	ManifestFormat GeneratedManifestFormat

	// The Account ID that owns the bucket the generated manifest is written to.
	ExpectedManifestBucketOwner *string

	// Specifies what encryption should be used when the generated manifest objects
	// are written.
	ManifestEncryption *GeneratedManifestEncryption

	// Prefix identifying one or more objects to which the manifest applies.
	ManifestPrefix *string

	noSmithyDocumentSerde
}

// Whether S3 Object Lock legal hold will be applied to objects in an S3 Batch
// Operations job.
type S3ObjectLockLegalHold struct {

	// The Object Lock legal hold status to be applied to all objects in the Batch
	// Operations job.
	//
	// This member is required.
	Status S3ObjectLockLegalHoldStatus

	noSmithyDocumentSerde
}

type S3ObjectMetadata struct {

	//
	CacheControl *string

	//
	ContentDisposition *string

	//
	ContentEncoding *string

	//
	ContentLanguage *string

	//  This member has been deprecated.
	ContentLength *int64

	//  This member has been deprecated.
	ContentMD5 *string

	//
	ContentType *string

	//
	HttpExpiresDate *time.Time

	//  This member has been deprecated.
	RequesterCharged bool

	// The server-side encryption algorithm used when storing objects in Amazon S3.
	//
	// Directory buckets - For directory buckets, there are only two supported options
	// for server-side encryption: server-side encryption with Amazon S3 managed keys
	// (SSE-S3) ( AES256 ) and server-side encryption with KMS keys (SSE-KMS) ( KMS ).
	// For more information, see [Protecting data with server-side encryption]in the Amazon S3 User Guide. For [the Copy operation in Batch Operations], see [S3CopyObjectOperation].
	//
	// [Protecting data with server-side encryption]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html
	// [S3CopyObjectOperation]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_S3CopyObjectOperation.html
	// [the Copy operation in Batch Operations]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops
	SSEAlgorithm S3SSEAlgorithm

	//
	UserMetadata map[string]string

	noSmithyDocumentSerde
}

type S3ObjectOwner struct {

	//
	DisplayName *string

	//
	ID *string

	noSmithyDocumentSerde
}

// Directs the specified job to invoke ReplicateObject on every object in the
// job's manifest.
type S3ReplicateObjectOperation struct {
	noSmithyDocumentSerde
}

// Contains the S3 Object Lock retention mode to be applied to all objects in the
// S3 Batch Operations job. If you don't provide Mode and RetainUntilDate data
// types in your operation, you will remove the retention from your objects. For
// more information, see [Using S3 Object Lock retention with S3 Batch Operations]in the Amazon S3 User Guide.
//
// [Using S3 Object Lock retention with S3 Batch Operations]: https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html
type S3Retention struct {

	// The Object Lock retention mode to be applied to all objects in the Batch
	// Operations job.
	Mode S3ObjectLockRetentionMode

	// The date when the applied Object Lock retention will expire on all objects set
	// by the Batch Operations job.
	RetainUntilDate *time.Time

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a PUT Object ACL operation. S3 Batch
// Operations passes every object to the underlying PutObjectAcl API operation.
// For more information about the parameters for this operation, see [PutObjectAcl].
//
// [PutObjectAcl]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html
type S3SetObjectAclOperation struct {

	//
	AccessControlPolicy *S3AccessControlPolicy

	noSmithyDocumentSerde
}

// Contains the configuration for an S3 Object Lock legal hold operation that an
// S3 Batch Operations job passes to every object to the underlying
// PutObjectLegalHold API operation. For more information, see [Using S3 Object Lock legal hold with S3 Batch Operations] in the Amazon S3
// User Guide.
//
// This functionality is not supported by directory buckets.
//
// [Using S3 Object Lock legal hold with S3 Batch Operations]: https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html
type S3SetObjectLegalHoldOperation struct {

	// Contains the Object Lock legal hold status to be applied to all objects in the
	// Batch Operations job.
	//
	// This member is required.
	LegalHold *S3ObjectLockLegalHold

	noSmithyDocumentSerde
}

// Contains the configuration parameters for the Object Lock retention action for
// an S3 Batch Operations job. Batch Operations passes every object to the
// underlying PutObjectRetention API operation. For more information, see [Using S3 Object Lock retention with S3 Batch Operations] in the
// Amazon S3 User Guide.
//
// This functionality is not supported by directory buckets.
//
// [Using S3 Object Lock retention with S3 Batch Operations]: https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html
type S3SetObjectRetentionOperation struct {

	// Contains the Object Lock retention mode to be applied to all objects in the
	// Batch Operations job. For more information, see [Using S3 Object Lock retention with S3 Batch Operations]in the Amazon S3 User Guide.
	//
	// [Using S3 Object Lock retention with S3 Batch Operations]: https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html
	//
	// This member is required.
	Retention *S3Retention

	// Indicates if the action should be applied to objects in the Batch Operations
	// job even if they have Object Lock GOVERNANCE type in place.
	BypassGovernanceRetention *bool

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a PUT Object Tagging operation. S3
// Batch Operations passes every object to the underlying PutObjectTagging API
// operation. For more information about the parameters for this operation, see [PutObjectTagging].
//
// [PutObjectTagging]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTtagging.html
type S3SetObjectTaggingOperation struct {

	//
	TagSet []S3Tag

	noSmithyDocumentSerde
}

// A container for a key-value name pair.
type S3Tag struct {

	// Key of the tag
	//
	// This member is required.
	Key *string

	// Value of the tag
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// You can use the access point scope to restrict access to specific prefixes, API
// operations, or a combination of both.
//
// For more information, see [Manage the scope of your access points for directory buckets].
//
// [Manage the scope of your access points for directory buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-directory-buckets-manage-scope.html
type Scope struct {

	// You can include one or more API operations as permissions.
	Permissions []ScopePermission

	// You can specify any amount of prefixes, but the total length of characters of
	// all prefixes must be less than 256 bytes in size.
	Prefixes []string

	noSmithyDocumentSerde
}

type SelectionCriteria struct {

	// A container for the delimiter of the selection criteria being used.
	Delimiter *string

	// The max depth of the selection criteria
	MaxDepth *int32

	// The minimum number of storage bytes percentage whose metrics will be selected.
	//
	// You must choose a value greater than or equal to 1.0 .
	MinStorageBytesPercentage *float64

	noSmithyDocumentSerde
}

// A container that describes additional filters for identifying the source
// objects that you want to replicate. You can choose to enable or disable the
// replication of these objects.
type SourceSelectionCriteria struct {

	// A filter that you can use to specify whether replica modification sync is
	// enabled. S3 on Outposts replica modification sync can help you keep object
	// metadata synchronized between replicas and source objects. By default, S3 on
	// Outposts replicates metadata from the source objects to the replicas only. When
	// replica modification sync is enabled, S3 on Outposts replicates metadata changes
	// made to the replica copies back to the source object, making the replication
	// bidirectional.
	//
	// To replicate object metadata modifications on replicas, you can specify this
	// element and set the Status of this element to Enabled .
	//
	// You must enable replica modification sync on the source and destination buckets
	// to replicate replica metadata changes between the source and the replicas.
	ReplicaModifications *ReplicaModifications

	// A filter that you can use to select Amazon S3 objects that are encrypted with
	// server-side encryption by using Key Management Service (KMS) keys. If you
	// include SourceSelectionCriteria in the replication configuration, this element
	// is required.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	SseKmsEncryptedObjects *SseKmsEncryptedObjects

	noSmithyDocumentSerde
}

// A filter that returns objects that are encrypted by server-side encryption with
// customer-provided keys (SSE-C).
type SSECFilter struct {
	noSmithyDocumentSerde
}

type SSEKMS struct {

	// A container for the ARN of the SSE-KMS encryption. This property is read-only
	// and follows the following format:
	// arn:aws:kms:us-east-1:example-account-id:key/example-9a73-4afc-8d29-8f5900cef44e
	//
	// This member is required.
	KeyId *string

	noSmithyDocumentSerde
}

// A container for filter information that you can use to select S3 objects that
// are encrypted with Key Management Service (KMS).
//
// This is not supported by Amazon S3 on Outposts buckets.
type SseKmsEncryptedObjects struct {

	// Specifies whether Amazon S3 replicates objects that are created with
	// server-side encryption by using an KMS key stored in Key Management Service.
	//
	// This member is required.
	Status SseKmsEncryptedObjectsStatus

	noSmithyDocumentSerde
}

// Configuration for the use of SSE-KMS to encrypt generated manifest objects.
type SSEKMSEncryption struct {

	// Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web
	// Services KMS) symmetric encryption customer managed key to use for encrypting
	// generated manifest objects.
	//
	// This member is required.
	KeyId *string

	noSmithyDocumentSerde
}

// A filter that returns objects that are encrypted by server-side encryption with
// Amazon Web Services KMS (SSE-KMS).
type SSEKMSFilter struct {

	// Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption
	// with server-side encryption using Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) keys (SSE-KMS). If specified, will filter SSE-KMS
	// encrypted objects by S3 Bucket Key status.
	BucketKeyEnabled *bool

	// The Amazon Resource Name (ARN) of the customer managed KMS key to use for the
	// filter to return objects that are encrypted by the specified key. For best
	// performance, use keys in the same Region as the S3 Batch Operations job.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

type SSES3 struct {
	noSmithyDocumentSerde
}

// Configuration for the use of SSE-S3 to encrypt generated manifest objects.
type SSES3Encryption struct {
	noSmithyDocumentSerde
}

// A filter that returns objects that are encrypted by server-side encryption with
// Amazon S3 managed keys (SSE-S3).
type SSES3Filter struct {
	noSmithyDocumentSerde
}

// The Amazon Web Services organization for your S3 Storage Lens.
type StorageLensAwsOrg struct {

	// A container for the Amazon Resource Name (ARN) of the Amazon Web Services
	// organization. This property is read-only and follows the following format:
	// arn:aws:organizations:us-east-1:example-account-id:organization/o-ex2l495dck
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// A container for the Amazon S3 Storage Lens configuration.
type StorageLensConfiguration struct {

	// A container for all the account-level configurations of your S3 Storage Lens
	// configuration.
	//
	// This member is required.
	AccountLevel *AccountLevel

	// A container for the Amazon S3 Storage Lens configuration ID.
	//
	// This member is required.
	Id *string

	// A container for whether the S3 Storage Lens configuration is enabled.
	//
	// This member is required.
	IsEnabled bool

	// A container for the Amazon Web Services organization for this S3 Storage Lens
	// configuration.
	AwsOrg *StorageLensAwsOrg

	// A container to specify the properties of your S3 Storage Lens metrics export
	// including, the destination, schema and format.
	DataExport *StorageLensDataExport

	// A container for what is excluded in this configuration. This container can only
	// be valid if there is no Include container submitted, and it's not empty.
	Exclude *Exclude

	// A container that configures your S3 Storage Lens expanded prefixes metrics
	// report.
	ExpandedPrefixesDataExport *StorageLensExpandedPrefixesDataExport

	// A container for what is included in this configuration. This container can only
	// be valid if there is no Exclude container submitted, and it's not empty.
	Include *Include

	// A container for all prefix delimiters that are used for object keys in this S3
	// Storage Lens configuration. The prefix delimiters determine how S3 Storage Lens
	// counts prefix depth, by separating the hierarchical levels in object keys.
	//
	//   - If either a prefix delimiter or existing delimiter is undefined, Amazon S3
	//   uses the delimiter that’s defined.
	//
	//   - If both the prefix delimiter and existing delimiter are undefined, S3 uses /
	//   as the default delimiter.
	//
	//   - When custom delimiters are used, both the prefix delimiter and existing
	//   delimiter must specify the same special character. Otherwise, your request
	//   results in an error.
	PrefixDelimiter *string

	// The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This
	// property is read-only and follows the following format:
	// arn:aws:s3:us-east-1:example-account-id:storage-lens/your-dashboard-name
	StorageLensArn *string

	noSmithyDocumentSerde
}

// A container to specify the properties of your S3 Storage Lens metrics export,
// including the destination, schema, and format.
type StorageLensDataExport struct {

	// A container for enabling Amazon CloudWatch publishing for S3 Storage Lens
	// metrics.
	CloudWatchMetrics *CloudWatchMetrics

	// A container for the bucket where the S3 Storage Lens metrics export will be
	// located.
	//
	// This bucket must be located in the same Region as the storage lens
	// configuration.
	S3BucketDestination *S3BucketDestination

	// A container for configuring S3 Storage Lens data exports to read-only S3 table
	// buckets.
	StorageLensTableDestination *StorageLensTableDestination

	noSmithyDocumentSerde
}

// A container for the encryption of the S3 Storage Lens metrics exports.
type StorageLensDataExportEncryption struct {

	//
	SSEKMS *SSEKMS

	//
	SSES3 *SSES3

	noSmithyDocumentSerde
}

// A container for your S3 Storage Lens expanded prefix metrics report
// configuration. Unlike the default Storage Lens metrics report, the enhanced
// prefix metrics report includes all S3 Storage Lens storage and activity data
// related to the full list of prefixes in your Storage Lens configuration.
type StorageLensExpandedPrefixesDataExport struct {

	// A container for the bucket where the Amazon S3 Storage Lens metrics export
	// files are located.
	S3BucketDestination *S3BucketDestination

	// A container for the bucket where the S3 Storage Lens metric export files are
	// located. At least one export destination must be specified.
	StorageLensTableDestination *StorageLensTableDestination

	noSmithyDocumentSerde
}

// A custom grouping of objects that include filters for prefixes, suffixes,
// object tags, object size, or object age. You can create an S3 Storage Lens group
// that includes a single filter or multiple filter conditions. To specify multiple
// filter conditions, you use AND or OR logical operators.
type StorageLensGroup struct {

	// Sets the criteria for the Storage Lens group data that is displayed. For
	// multiple filter conditions, the AND or OR logical operator is used.
	//
	// This member is required.
	Filter *StorageLensGroupFilter

	//  Contains the name of the Storage Lens group.
	//
	// This member is required.
	Name *string

	//  Contains the Amazon Resource Name (ARN) of the Storage Lens group. This
	// property is read-only.
	StorageLensGroupArn *string

	noSmithyDocumentSerde
}

//	A logical operator that allows multiple filter conditions to be joined for
//
// more complex comparisons of Storage Lens group data.
type StorageLensGroupAndOperator struct {

	//  Contains a list of prefixes. At least one prefix must be specified. Up to 10
	// prefixes are allowed.
	MatchAnyPrefix []string

	//  Contains a list of suffixes. At least one suffix must be specified. Up to 10
	// suffixes are allowed.
	MatchAnySuffix []string

	//  Contains the list of object tags. At least one object tag must be specified.
	// Up to 10 object tags are allowed.
	MatchAnyTag []S3Tag

	//  Contains DaysGreaterThan and DaysLessThan to define the object age range
	// (minimum and maximum number of days).
	MatchObjectAge *MatchObjectAge

	//  Contains BytesGreaterThan and BytesLessThan to define the object size range
	// (minimum and maximum number of Bytes).
	MatchObjectSize *MatchObjectSize

	noSmithyDocumentSerde
}

// The filter element sets the criteria for the Storage Lens group data that is
// displayed. For multiple filter conditions, the AND or OR logical operator is
// used.
type StorageLensGroupFilter struct {

	// A logical operator that allows multiple filter conditions to be joined for more
	// complex comparisons of Storage Lens group data. Objects must match all of the
	// listed filter conditions that are joined by the And logical operator. Only one
	// of each filter condition is allowed.
	And *StorageLensGroupAndOperator

	//  Contains a list of prefixes. At least one prefix must be specified. Up to 10
	// prefixes are allowed.
	MatchAnyPrefix []string

	//  Contains a list of suffixes. At least one suffix must be specified. Up to 10
	// suffixes are allowed.
	MatchAnySuffix []string

	//  Contains the list of S3 object tags. At least one object tag must be
	// specified. Up to 10 object tags are allowed.
	MatchAnyTag []S3Tag

	//  Contains DaysGreaterThan and DaysLessThan to define the object age range
	// (minimum and maximum number of days).
	MatchObjectAge *MatchObjectAge

	//  Contains BytesGreaterThan and BytesLessThan to define the object size range
	// (minimum and maximum number of Bytes).
	MatchObjectSize *MatchObjectSize

	// A single logical operator that allows multiple filter conditions to be joined.
	// Objects can match any of the listed filter conditions, which are joined by the
	// Or logical operator. Only one of each filter condition is allowed.
	Or *StorageLensGroupOrOperator

	noSmithyDocumentSerde
}

//	Specifies the Storage Lens groups to include in the Storage Lens group
//
// aggregation.
type StorageLensGroupLevel struct {

	//  Indicates which Storage Lens group ARNs to include or exclude in the Storage
	// Lens group aggregation. If this value is left null, then all Storage Lens groups
	// are selected.
	SelectionCriteria *StorageLensGroupLevelSelectionCriteria

	noSmithyDocumentSerde
}

//	Indicates which Storage Lens group ARNs to include or exclude in the Storage
//
// Lens group aggregation. You can only attach Storage Lens groups to your Storage
// Lens dashboard if they're included in your Storage Lens group aggregation. If
// this value is left null, then all Storage Lens groups are selected.
type StorageLensGroupLevelSelectionCriteria struct {

	//  Indicates which Storage Lens group ARNs to exclude from the Storage Lens group
	// aggregation.
	Exclude []string

	//  Indicates which Storage Lens group ARNs to include in the Storage Lens group
	// aggregation.
	Include []string

	noSmithyDocumentSerde
}

// A container element for specifying Or rule conditions. The rule conditions
// determine the subset of objects to which the Or rule applies. Objects can match
// any of the listed filter conditions, which are joined by the Or logical
// operator. Only one of each filter condition is allowed.
type StorageLensGroupOrOperator struct {

	//  Filters objects that match any of the specified prefixes.
	MatchAnyPrefix []string

	//  Filters objects that match any of the specified suffixes.
	MatchAnySuffix []string

	//  Filters objects that match any of the specified S3 object tags.
	MatchAnyTag []S3Tag

	//  Filters objects that match the specified object age range.
	MatchObjectAge *MatchObjectAge

	//  Filters objects that match the specified object size range.
	MatchObjectSize *MatchObjectSize

	noSmithyDocumentSerde
}

// A container for configuring your S3 Storage Lens reports to export to read-only
// S3 table buckets. This parameter enables you to store your Storage Lens metrics
// in a structured, queryable table format in Apache Iceberg.
//
// For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens] in the Amazon S3 User Guide.
//
// [Assessing your storage activity and usage with S3 Storage Lens]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html
type StorageLensTableDestination struct {

	// A container that indicates whether the export to read-only S3 table buckets is
	// enabled for your S3 Storage Lens configuration. When set to true, Storage Lens
	// reports are automatically exported to tables in addition to other configured
	// destinations.
	//
	// This member is required.
	IsEnabled bool

	// A container for the encryption of the S3 Storage Lens metrics exports.
	Encryption *StorageLensDataExportEncryption

	noSmithyDocumentSerde
}

type StorageLensTag struct {

	//
	//
	// This member is required.
	Key *string

	//
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

//	A key-value pair that you use to label your resources. You can add tags to new
//
// resources when you create them, or you can add tags to existing resources. Tags
// can help you organize, track costs for, and control access to resources.
type Tag struct {

	// The key of the key-value pair of a tag added to your Amazon Web Services
	// resource. A tag key can be up to 128 Unicode characters in length and is
	// case-sensitive. System created tags that begin with aws: aren’t supported.
	//
	// This member is required.
	Key *string

	//  The value of the key-value pair of a tag added to your Amazon Web Services
	// resource. A tag value can be up to 256 Unicode characters in length and is
	// case-sensitive.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type Tagging struct {

	// A collection for a set of tags.
	//
	// This member is required.
	TagSet []S3Tag

	noSmithyDocumentSerde
}

// Specifies when an object transitions to a specified storage class. For more
// information about Amazon S3 Lifecycle configuration rules, see [Transitioning objects using Amazon S3 Lifecycle]in the Amazon S3
// User Guide.
//
// [Transitioning objects using Amazon S3 Lifecycle]: https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html
type Transition struct {

	// Indicates when objects are transitioned to the specified storage class. The
	// date value must be in ISO 8601 format. The time is always midnight UTC.
	Date *time.Time

	// Indicates the number of days after creation when objects are transitioned to
	// the specified storage class. The value must be a positive integer.
	Days int32

	// The storage class to which you want the object to transition.
	StorageClass TransitionStorageClass

	noSmithyDocumentSerde
}

// Describes the versioning state of an Amazon S3 on Outposts bucket. For more
// information, see [PutBucketVersioning].
//
// [PutBucketVersioning]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html
type VersioningConfiguration struct {

	// Specifies whether MFA delete is enabled or disabled in the bucket versioning
	// configuration for the S3 on Outposts bucket.
	MFADelete MFADelete

	// Sets the versioning state of the S3 on Outposts bucket.
	Status BucketVersioningStatus

	noSmithyDocumentSerde
}

// The virtual private cloud (VPC) configuration for an access point.
type VpcConfiguration struct {

	// If this field is specified, this access point will only allow connections from
	// the specified VPC ID.
	//
	// This member is required.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isJobManifestGenerator()              {}
func (*UnknownUnionMember) isObjectEncryptionFilter()            {}
func (*UnknownUnionMember) isObjectLambdaContentTransformation() {}
