// Code generated by smithy-go-codegen DO NOT EDIT.

package s3tables

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3tables/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates the replication configuration for a specific table. This
// operation allows you to define table-level replication independently of
// bucket-level replication, providing granular control over which tables are
// replicated and where.
//
// Permissions
//
//   - You must have the s3tables:PutTableReplication permission to use this
//     operation. The IAM role specified in the configuration must have permissions to
//     read from the source table and write to all destination tables.
//
//   - You must also have the following permissions:
//
//   - s3tables:GetTable permission on the source table being replicated.
//
//   - s3tables:CreateTable permission for the destination.
//
//   - s3tables:CreateNamespace permission for the destination.
//
//   - s3tables:GetTableMaintenanceConfig permission for the source table.
//
//   - s3tables:PutTableMaintenanceConfig permission for the destination table.
//
//   - You must have iam:PassRole permission with condition allowing roles to be
//     passed to replication.s3tables.amazonaws.com .
func (c *Client) PutTableReplication(ctx context.Context, params *PutTableReplicationInput, optFns ...func(*Options)) (*PutTableReplicationOutput, error) {
	if params == nil {
		params = &PutTableReplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutTableReplication", params, optFns, c.addOperationPutTableReplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutTableReplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutTableReplicationInput struct {

	// The replication configuration to apply to the table, including the IAM role and
	// replication rules.
	//
	// This member is required.
	Configuration *types.TableReplicationConfiguration

	// The Amazon Resource Name (ARN) of the source table.
	//
	// This member is required.
	TableArn *string

	// A version token from a previous GetTableReplication call. Use this token to
	// ensure you're updating the expected version of the configuration.
	VersionToken *string

	noSmithyDocumentSerde
}

type PutTableReplicationOutput struct {

	// The status of the replication configuration operation.
	//
	// This member is required.
	Status *string

	// A new version token representing the updated replication configuration.
	//
	// This member is required.
	VersionToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutTableReplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutTableReplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutTableReplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutTableReplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutTableReplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutTableReplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutTableReplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutTableReplication",
	}
}
