// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Attaches your Amazon Elastic Block Store (Amazon EBS) volume to a node in your
//
// EKS orchestrated HyperPod cluster.
//
// This API works with the Amazon Elastic Block Store (Amazon EBS) Container
// Storage Interface (CSI) driver to manage the lifecycle of persistent storage in
// your HyperPod EKS clusters.
func (c *Client) AttachClusterNodeVolume(ctx context.Context, params *AttachClusterNodeVolumeInput, optFns ...func(*Options)) (*AttachClusterNodeVolumeOutput, error) {
	if params == nil {
		params = &AttachClusterNodeVolumeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AttachClusterNodeVolume", params, optFns, c.addOperationAttachClusterNodeVolumeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AttachClusterNodeVolumeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AttachClusterNodeVolumeInput struct {

	//  The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster containing
	// the target node. Your cluster must use EKS as the orchestration and be in the
	// InService state.
	//
	// This member is required.
	ClusterArn *string

	//  The unique identifier of the cluster node to which you want to attach the
	// volume. The node must belong to your specified HyperPod cluster and cannot be
	// part of a Restricted Instance Group (RIG).
	//
	// This member is required.
	NodeId *string

	//  The unique identifier of your EBS volume to attach. The volume must be in the
	// available state.
	//
	// This member is required.
	VolumeId *string

	noSmithyDocumentSerde
}

type AttachClusterNodeVolumeOutput struct {

	//  The timestamp when the volume attachment operation was initiated by the
	// SageMaker HyperPod service.
	//
	// This member is required.
	AttachTime *time.Time

	//  The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster where the
	// volume attachment operation was performed.
	//
	// This member is required.
	ClusterArn *string

	//  The device name assigned to your attached volume on the target instance.
	//
	// This member is required.
	DeviceName *string

	//  The unique identifier of the cluster node where your volume was attached.
	//
	// This member is required.
	NodeId *string

	//  The current status of your volume attachment operation.
	//
	// This member is required.
	Status types.VolumeAttachmentStatus

	//  The unique identifier of your EBS volume that was attached.
	//
	// This member is required.
	VolumeId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAttachClusterNodeVolumeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpAttachClusterNodeVolume{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpAttachClusterNodeVolume{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AttachClusterNodeVolume"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAttachClusterNodeVolumeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAttachClusterNodeVolume(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAttachClusterNodeVolume(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AttachClusterNodeVolume",
	}
}
