// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes specific nodes within a SageMaker HyperPod cluster.
// BatchDeleteClusterNodes accepts a cluster name and a list of node IDs.
//
//   - To safeguard your work, back up your data to Amazon S3 or an FSx for Lustre
//     file system before invoking the API on a worker node group. This will help
//     prevent any potential data loss from the instance root volume. For more
//     information about backup, see [Use the backup script provided by SageMaker HyperPod].
//
//   - If you want to invoke this API on an existing cluster, you'll first need to
//     patch the cluster by running the [UpdateClusterSoftware API]. For more information about patching a
//     cluster, see [Update the SageMaker HyperPod platform software of a cluster].
//
// [UpdateClusterSoftware API]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateClusterSoftware.html
// [Use the backup script provided by SageMaker HyperPod]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software-backup
// [Update the SageMaker HyperPod platform software of a cluster]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software
func (c *Client) BatchDeleteClusterNodes(ctx context.Context, params *BatchDeleteClusterNodesInput, optFns ...func(*Options)) (*BatchDeleteClusterNodesOutput, error) {
	if params == nil {
		params = &BatchDeleteClusterNodesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDeleteClusterNodes", params, optFns, c.addOperationBatchDeleteClusterNodesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDeleteClusterNodesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDeleteClusterNodesInput struct {

	// The name of the SageMaker HyperPod cluster from which to delete the specified
	// nodes.
	//
	// This member is required.
	ClusterName *string

	// A list of node IDs to be deleted from the specified cluster.
	//
	//   - For SageMaker HyperPod clusters using the Slurm workload manager, you
	//   cannot remove instances that are configured as Slurm controller nodes.
	//
	//   - If you need to delete more than 99 instances, contact [Support]for assistance.
	//
	// [Support]: http://aws.amazon.com/contact-us/
	NodeIds []string

	// A list of NodeLogicalIds identifying the nodes to be deleted. You can specify
	// up to 50 NodeLogicalIds . You must specify either NodeLogicalIds , InstanceIds ,
	// or both, with a combined maximum of 50 identifiers.
	NodeLogicalIds []string

	noSmithyDocumentSerde
}

type BatchDeleteClusterNodesOutput struct {

	// A list of errors encountered when deleting the specified nodes.
	Failed []types.BatchDeleteClusterNodesError

	// A list of NodeLogicalIds that could not be deleted, along with error
	// information explaining why the deletion failed.
	FailedNodeLogicalIds []types.BatchDeleteClusterNodeLogicalIdsError

	// A list of node IDs that were successfully deleted from the specified cluster.
	Successful []string

	// A list of NodeLogicalIds that were successfully deleted from the cluster.
	SuccessfulNodeLogicalIds []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDeleteClusterNodesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpBatchDeleteClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpBatchDeleteClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchDeleteClusterNodes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchDeleteClusterNodesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDeleteClusterNodes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDeleteClusterNodes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchDeleteClusterNodes",
	}
}
