// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Replaces specific nodes within a SageMaker HyperPod cluster with new hardware.
// BatchReplaceClusterNodes terminates the specified instances and provisions new
// replacement instances with the same configuration but fresh hardware. The Amazon
// Machine Image (AMI) and instance configuration remain the same.
//
// This operation is useful for recovering from hardware failures or persistent
// issues that cannot be resolved through a reboot.
//
//   - Data Loss Warning: Replacing nodes destroys all instance volumes, including
//     both root and secondary volumes. All data stored on these volumes will be
//     permanently lost and cannot be recovered.
//
//   - To safeguard your work, back up your data to Amazon S3 or an FSx for Lustre
//     file system before invoking the API on a worker node group. This will help
//     prevent any potential data loss from the instance root volume. For more
//     information about backup, see [Use the backup script provided by SageMaker HyperPod].
//
//   - If you want to invoke this API on an existing cluster, you'll first need to
//     patch the cluster by running the [UpdateClusterSoftware API]. For more information about patching a
//     cluster, see [Update the SageMaker HyperPod platform software of a cluster].
//
//   - You can replace up to 25 nodes in a single request.
//
// [UpdateClusterSoftware API]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateClusterSoftware.html
// [Use the backup script provided by SageMaker HyperPod]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software-backup
// [Update the SageMaker HyperPod platform software of a cluster]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software
func (c *Client) BatchReplaceClusterNodes(ctx context.Context, params *BatchReplaceClusterNodesInput, optFns ...func(*Options)) (*BatchReplaceClusterNodesOutput, error) {
	if params == nil {
		params = &BatchReplaceClusterNodesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchReplaceClusterNodes", params, optFns, c.addOperationBatchReplaceClusterNodesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchReplaceClusterNodesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchReplaceClusterNodesInput struct {

	// The name or Amazon Resource Name (ARN) of the SageMaker HyperPod cluster
	// containing the nodes to replace.
	//
	// This member is required.
	ClusterName *string

	// A list of EC2 instance IDs to replace with new hardware. You can specify
	// between 1 and 25 instance IDs.
	//
	// Replace operations destroy all instance volumes (root and secondary). Ensure
	// you have backed up any important data before proceeding.
	//
	//   - Either NodeIds or NodeLogicalIds must be provided (or both), but at least
	//   one is required.
	//
	//   - Each instance ID must follow the pattern i- followed by 17 hexadecimal
	//   characters (for example, i-0123456789abcdef0 ).
	//
	//   - For SageMaker HyperPod clusters using the Slurm workload manager, you
	//   cannot replace instances that are configured as Slurm controller nodes.
	NodeIds []string

	// A list of logical node IDs to replace with new hardware. You can specify
	// between 1 and 25 logical node IDs.
	//
	// The NodeLogicalId is a unique identifier that persists throughout the node's
	// lifecycle and can be used to track nodes that are still being provisioned and
	// don't yet have an EC2 instance ID assigned.
	//
	//   - Replace operations destroy all instance volumes (root and secondary).
	//   Ensure you have backed up any important data before proceeding.
	//
	//   - This parameter is only supported for clusters using Continuous as the
	//   NodeProvisioningMode . For clusters using the default provisioning mode, use
	//   NodeIds instead.
	//
	//   - Either NodeIds or NodeLogicalIds must be provided (or both), but at least
	//   one is required.
	NodeLogicalIds []string

	noSmithyDocumentSerde
}

type BatchReplaceClusterNodesOutput struct {

	// A list of errors encountered for EC2 instance IDs that could not be replaced.
	// Each error includes the instance ID, an error code, and a descriptive message.
	Failed []types.BatchReplaceClusterNodesError

	// A list of errors encountered for logical node IDs that could not be replaced.
	// Each error includes the logical node ID, an error code, and a descriptive
	// message. This field is only present when NodeLogicalIds were provided in the
	// request.
	FailedNodeLogicalIds []types.BatchReplaceClusterNodeLogicalIdsError

	// A list of EC2 instance IDs for which the replacement operation was successfully
	// initiated.
	Successful []string

	// A list of logical node IDs for which the replacement operation was successfully
	// initiated. This field is only present when NodeLogicalIds were provided in the
	// request.
	SuccessfulNodeLogicalIds []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchReplaceClusterNodesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpBatchReplaceClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpBatchReplaceClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchReplaceClusterNodes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchReplaceClusterNodesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchReplaceClusterNodes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchReplaceClusterNodes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchReplaceClusterNodes",
	}
}
