// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as
// the artifact store.
func (c *Client) CreateMlflowApp(ctx context.Context, params *CreateMlflowAppInput, optFns ...func(*Options)) (*CreateMlflowAppOutput, error) {
	if params == nil {
		params = &CreateMlflowAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMlflowApp", params, optFns, c.addOperationCreateMlflowAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMlflowAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMlflowAppInput struct {

	// The S3 URI for a general purpose bucket to use as the MLflow App artifact store.
	//
	// This member is required.
	ArtifactStoreUri *string

	// A string identifying the MLflow app name. This string is not part of the
	// tracking server ARN.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow
	// App uses to access the artifact store in Amazon S3. The role should have the
	// AmazonS3FullAccess permission.
	//
	// This member is required.
	RoleArn *string

	// Indicates whether this MLflow app is the default for the entire account.
	AccountDefaultStatus types.AccountDefaultStatus

	// List of SageMaker domain IDs for which this MLflow App is used as the default.
	DefaultDomainIdList []string

	// Whether to enable or disable automatic registration of new MLflow models to the
	// SageMaker Model Registry. To enable automatic model registration, set this value
	// to AutoModelRegistrationEnabled . To disable automatic model registration, set
	// this value to AutoModelRegistrationDisabled . If not specified,
	// AutomaticModelRegistration defaults to AutoModelRegistrationDisabled .
	ModelRegistrationMode types.ModelRegistrationMode

	// Tags consisting of key-value pairs used to manage metadata for the MLflow App.
	Tags []types.Tag

	// The day and time of the week in Coordinated Universal Time (UTC) 24-hour
	// standard time that weekly maintenance updates are scheduled. For example:
	// TUE:03:30.
	WeeklyMaintenanceWindowStart *string

	noSmithyDocumentSerde
}

type CreateMlflowAppOutput struct {

	// The ARN of the MLflow App.
	Arn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMlflowAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateMlflowApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateMlflowApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMlflowApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMlflowAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMlflowApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateMlflowApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMlflowApp",
	}
}
