// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as
// the artifact store. For more information, see [Create an MLflow Tracking Server].
//
// [Create an MLflow Tracking Server]: https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html
func (c *Client) CreateMlflowTrackingServer(ctx context.Context, params *CreateMlflowTrackingServerInput, optFns ...func(*Options)) (*CreateMlflowTrackingServerOutput, error) {
	if params == nil {
		params = &CreateMlflowTrackingServerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMlflowTrackingServer", params, optFns, c.addOperationCreateMlflowTrackingServerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMlflowTrackingServerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMlflowTrackingServerInput struct {

	// The S3 URI for a general purpose bucket to use as the MLflow Tracking Server
	// artifact store.
	//
	// This member is required.
	ArtifactStoreUri *string

	// The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow
	// Tracking Server uses to access the artifact store in Amazon S3. The role should
	// have AmazonS3FullAccess permissions. For more information on IAM permissions
	// for tracking server creation, see [Set up IAM permissions for MLflow].
	//
	// [Set up IAM permissions for MLflow]: https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html
	//
	// This member is required.
	RoleArn *string

	// A unique string identifying the tracking server name. This string is part of
	// the tracking server ARN.
	//
	// This member is required.
	TrackingServerName *string

	// Whether to enable or disable automatic registration of new MLflow models to the
	// SageMaker Model Registry. To enable automatic model registration, set this value
	// to True . To disable automatic model registration, set this value to False . If
	// not specified, AutomaticModelRegistration defaults to False .
	AutomaticModelRegistration *bool

	// The version of MLflow that the tracking server uses. To see which MLflow
	// versions are available to use, see [How it works].
	//
	// [How it works]: https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works
	MlflowVersion *string

	// Tags consisting of key-value pairs used to manage metadata for the tracking
	// server.
	Tags []types.Tag

	// The size of the tracking server you want to create. You can choose between
	// "Small" , "Medium" , and "Large" . The default MLflow Tracking Server
	// configuration size is "Small" . You can choose a size depending on the projected
	// use of the tracking server such as the volume of data logged, number of users,
	// and frequency of use.
	//
	// We recommend using a small tracking server for teams of up to 25 users, a
	// medium tracking server for teams of up to 50 users, and a large tracking server
	// for teams of up to 100 users.
	TrackingServerSize types.TrackingServerSize

	// The day and time of the week in Coordinated Universal Time (UTC) 24-hour
	// standard time that weekly maintenance updates are scheduled. For example:
	// TUE:03:30.
	WeeklyMaintenanceWindowStart *string

	noSmithyDocumentSerde
}

type CreateMlflowTrackingServerOutput struct {

	// The ARN of the tracking server.
	TrackingServerArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMlflowTrackingServerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateMlflowTrackingServer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateMlflowTrackingServer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMlflowTrackingServer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMlflowTrackingServerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMlflowTrackingServer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateMlflowTrackingServer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMlflowTrackingServer",
	}
}
