// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Amazon SageMaker Partner AI App.
func (c *Client) CreatePartnerApp(ctx context.Context, params *CreatePartnerAppInput, optFns ...func(*Options)) (*CreatePartnerAppOutput, error) {
	if params == nil {
		params = &CreatePartnerAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePartnerApp", params, optFns, c.addOperationCreatePartnerAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePartnerAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePartnerAppInput struct {

	// The authorization type that users use to access the SageMaker Partner AI App.
	//
	// This member is required.
	AuthType types.PartnerAppAuthType

	// The ARN of the IAM role that the partner application uses.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The name to give the SageMaker Partner AI App.
	//
	// This member is required.
	Name *string

	// Indicates the instance type and size of the cluster attached to the SageMaker
	// Partner AI App.
	//
	// This member is required.
	Tier *string

	// The type of SageMaker Partner AI App to create. Must be one of the following:
	// lakera-guard , comet , deepchecks-llm-evaluation , or fiddler .
	//
	// This member is required.
	Type types.PartnerAppType

	// Configuration settings for the SageMaker Partner AI App.
	ApplicationConfig *types.PartnerAppConfig

	// A unique token that guarantees that the call to this API is idempotent.
	ClientToken *string

	// When set to TRUE , the SageMaker Partner AI App is automatically upgraded to the
	// latest minor version during the next scheduled maintenance window, if one is
	// available. Default is FALSE .
	EnableAutoMinorVersionUpgrade *bool

	// When set to TRUE , the SageMaker Partner AI App sets the Amazon Web Services IAM
	// session name or the authenticated IAM user as the identity of the SageMaker
	// Partner AI App user.
	EnableIamSessionBasedIdentity *bool

	// SageMaker Partner AI Apps uses Amazon Web Services KMS to encrypt data at rest
	// using an Amazon Web Services managed key by default. For more control, specify a
	// customer managed key.
	KmsKeyId *string

	// Maintenance configuration settings for the SageMaker Partner AI App.
	MaintenanceConfig *types.PartnerAppMaintenanceConfig

	// Each tag consists of a key and an optional value. Tag keys must be unique per
	// resource.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreatePartnerAppOutput struct {

	// The ARN of the SageMaker Partner AI App.
	Arn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePartnerAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreatePartnerApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreatePartnerApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePartnerApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreatePartnerAppMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePartnerAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePartnerApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreatePartnerApp struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreatePartnerApp) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreatePartnerApp) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreatePartnerAppInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreatePartnerAppInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreatePartnerAppMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreatePartnerApp{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreatePartnerApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePartnerApp",
	}
}
