// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Description of the cluster policy. This policy is used for task prioritization
// and fair-share allocation. This helps prioritize critical workloads and
// distributes idle compute across entities.
func (c *Client) DescribeClusterSchedulerConfig(ctx context.Context, params *DescribeClusterSchedulerConfigInput, optFns ...func(*Options)) (*DescribeClusterSchedulerConfigOutput, error) {
	if params == nil {
		params = &DescribeClusterSchedulerConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeClusterSchedulerConfig", params, optFns, c.addOperationDescribeClusterSchedulerConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeClusterSchedulerConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeClusterSchedulerConfigInput struct {

	// ID of the cluster policy.
	//
	// This member is required.
	ClusterSchedulerConfigId *string

	// Version of the cluster policy.
	ClusterSchedulerConfigVersion *int32

	noSmithyDocumentSerde
}

type DescribeClusterSchedulerConfigOutput struct {

	// ARN of the cluster policy.
	//
	// This member is required.
	ClusterSchedulerConfigArn *string

	// ID of the cluster policy.
	//
	// This member is required.
	ClusterSchedulerConfigId *string

	// Version of the cluster policy.
	//
	// This member is required.
	ClusterSchedulerConfigVersion *int32

	// Creation time of the cluster policy.
	//
	// This member is required.
	CreationTime *time.Time

	// Name of the cluster policy.
	//
	// This member is required.
	Name *string

	// Status of the cluster policy.
	//
	// This member is required.
	Status types.SchedulerResourceStatus

	// ARN of the cluster where the cluster policy is applied.
	ClusterArn *string

	// Information about the user who created or modified a SageMaker resource.
	CreatedBy *types.UserContext

	// Description of the cluster policy.
	Description *string

	// Failure reason of the cluster policy.
	FailureReason *string

	// Information about the user who created or modified a SageMaker resource.
	LastModifiedBy *types.UserContext

	// Last modified time of the cluster policy.
	LastModifiedTime *time.Time

	// Cluster policy configuration. This policy is used for task prioritization and
	// fair-share allocation. This helps prioritize critical workloads and distributes
	// idle compute across entities.
	SchedulerConfig *types.SchedulerConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeClusterSchedulerConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeClusterSchedulerConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeClusterSchedulerConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeClusterSchedulerConfig"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeClusterSchedulerConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeClusterSchedulerConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeClusterSchedulerConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeClusterSchedulerConfig",
	}
}
