// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about an MLflow App.
func (c *Client) DescribeMlflowApp(ctx context.Context, params *DescribeMlflowAppInput, optFns ...func(*Options)) (*DescribeMlflowAppOutput, error) {
	if params == nil {
		params = &DescribeMlflowAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMlflowApp", params, optFns, c.addOperationDescribeMlflowAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMlflowAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMlflowAppInput struct {

	// The ARN of the MLflow App for which to get information.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type DescribeMlflowAppOutput struct {

	// Indicates whether this MLflow app is the default for the entire account.
	AccountDefaultStatus types.AccountDefaultStatus

	// The ARN of the MLflow App.
	Arn *string

	// The S3 URI of the general purpose bucket used as the MLflow App artifact store.
	ArtifactStoreUri *string

	// Information about the user who created or modified a SageMaker resource.
	CreatedBy *types.UserContext

	// The timestamp when the MLflow App was created.
	CreationTime *time.Time

	// List of SageMaker Domain IDs for which this MLflow App is the default.
	DefaultDomainIdList []string

	// Information about the user who created or modified a SageMaker resource.
	LastModifiedBy *types.UserContext

	// The timestamp when the MLflow App was last modified.
	LastModifiedTime *time.Time

	// Current maintenance status of the MLflow App.
	MaintenanceStatus types.MaintenanceStatus

	// The MLflow version used.
	MlflowVersion *string

	// Whether automatic registration of new MLflow models to the SageMaker Model
	// Registry is enabled.
	ModelRegistrationMode types.ModelRegistrationMode

	// The name of the MLflow App.
	Name *string

	// The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow
	// App uses to access the artifact store in Amazon S3.
	RoleArn *string

	// The current creation status of the described MLflow App.
	Status types.MlflowAppStatus

	// The day and time of the week when weekly maintenance occurs.
	WeeklyMaintenanceWindowStart *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMlflowAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeMlflowApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeMlflowApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMlflowApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeMlflowAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMlflowApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeMlflowApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMlflowApp",
	}
}
