// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Detaches your Amazon Elastic Block Store (Amazon EBS) volume from a node in
//
// your EKS orchestrated SageMaker HyperPod cluster.
//
// This API works with the Amazon Elastic Block Store (Amazon EBS) Container
// Storage Interface (CSI) driver to manage the lifecycle of persistent storage in
// your HyperPod EKS clusters.
func (c *Client) DetachClusterNodeVolume(ctx context.Context, params *DetachClusterNodeVolumeInput, optFns ...func(*Options)) (*DetachClusterNodeVolumeOutput, error) {
	if params == nil {
		params = &DetachClusterNodeVolumeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DetachClusterNodeVolume", params, optFns, c.addOperationDetachClusterNodeVolumeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DetachClusterNodeVolumeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DetachClusterNodeVolumeInput struct {

	//  The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster containing
	// the target node. Your cluster must use EKS as the orchestration and be in the
	// InService state.
	//
	// This member is required.
	ClusterArn *string

	//  The unique identifier of the cluster node from which you want to detach the
	// volume.
	//
	// This member is required.
	NodeId *string

	//  The unique identifier of your EBS volume that you want to detach. Your volume
	// must be currently attached to the specified node.
	//
	// This member is required.
	VolumeId *string

	noSmithyDocumentSerde
}

type DetachClusterNodeVolumeOutput struct {

	//  The original timestamp when your volume was initially attached to the node.
	//
	// This member is required.
	AttachTime *time.Time

	//  The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster where the
	// volume detachment operation was performed.
	//
	// This member is required.
	ClusterArn *string

	//  The device name assigned to your attached volume on the target instance.
	//
	// This member is required.
	DeviceName *string

	//  The unique identifier of the cluster node from which your volume was detached.
	//
	// This member is required.
	NodeId *string

	//  The current status of your volume detachment operation.
	//
	// This member is required.
	Status types.VolumeAttachmentStatus

	//  The unique identifier of your EBS volume that was detached.
	//
	// This member is required.
	VolumeId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDetachClusterNodeVolumeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDetachClusterNodeVolume{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDetachClusterNodeVolume{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DetachClusterNodeVolume"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDetachClusterNodeVolumeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDetachClusterNodeVolume(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDetachClusterNodeVolume(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DetachClusterNodeVolume",
	}
}
