// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists all MLflow Apps
func (c *Client) ListMlflowApps(ctx context.Context, params *ListMlflowAppsInput, optFns ...func(*Options)) (*ListMlflowAppsOutput, error) {
	if params == nil {
		params = &ListMlflowAppsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMlflowApps", params, optFns, c.addOperationListMlflowAppsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMlflowAppsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMlflowAppsInput struct {

	// Filter for MLflow Apps with the specified AccountDefaultStatus .
	AccountDefaultStatus types.AccountDefaultStatus

	// Use the CreatedAfter filter to only list MLflow Apps created after a specific
	// date and time. Listed MLflow Apps are shown with a date and time such as
	// "2024-03-16T01:46:56+00:00" . The CreatedAfter parameter takes in a Unix
	// timestamp.
	CreatedAfter *time.Time

	// Use the CreatedBefore filter to only list MLflow Apps created before a specific
	// date and time. Listed MLflow Apps are shown with a date and time such as
	// "2024-03-16T01:46:56+00:00" . The CreatedAfter parameter takes in a Unix
	// timestamp.
	CreatedBefore *time.Time

	// Filter for MLflow Apps with the specified default SageMaker Domain ID.
	DefaultForDomainId *string

	// The maximum number of MLflow Apps to list.
	MaxResults *int32

	// Filter for Mlflow Apps with the specified version.
	MlflowVersion *string

	// If the previous response was truncated, use this token in your next request to
	// receive the next set of results.
	NextToken *string

	// Filter for MLflow Apps sorting by name, creation time, or creation status.
	SortBy types.SortMlflowAppBy

	// Change the order of the listed MLflow Apps. By default, MLflow Apps are listed
	// in Descending order by creation time. To change the list order, specify
	// SortOrder to be Ascending .
	SortOrder types.SortOrder

	// Filter for Mlflow apps with a specific creation status.
	Status types.MlflowAppStatus

	noSmithyDocumentSerde
}

type ListMlflowAppsOutput struct {

	// If the previous response was truncated, you will receive this token. Use it in
	// your next request to receive the next set of results.
	NextToken *string

	// A list of MLflow Apps according to chosen filters.
	Summaries []types.MlflowAppSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMlflowAppsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListMlflowApps{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListMlflowApps{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMlflowApps"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMlflowApps(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMlflowAppsPaginatorOptions is the paginator options for ListMlflowApps
type ListMlflowAppsPaginatorOptions struct {
	// The maximum number of MLflow Apps to list.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMlflowAppsPaginator is a paginator for ListMlflowApps
type ListMlflowAppsPaginator struct {
	options   ListMlflowAppsPaginatorOptions
	client    ListMlflowAppsAPIClient
	params    *ListMlflowAppsInput
	nextToken *string
	firstPage bool
}

// NewListMlflowAppsPaginator returns a new ListMlflowAppsPaginator
func NewListMlflowAppsPaginator(client ListMlflowAppsAPIClient, params *ListMlflowAppsInput, optFns ...func(*ListMlflowAppsPaginatorOptions)) *ListMlflowAppsPaginator {
	if params == nil {
		params = &ListMlflowAppsInput{}
	}

	options := ListMlflowAppsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMlflowAppsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMlflowAppsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMlflowApps page.
func (p *ListMlflowAppsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMlflowAppsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMlflowApps(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMlflowAppsAPIClient is a client that implements the ListMlflowApps
// operation.
type ListMlflowAppsAPIClient interface {
	ListMlflowApps(context.Context, *ListMlflowAppsInput, ...func(*Options)) (*ListMlflowAppsOutput, error)
}

var _ ListMlflowAppsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMlflowApps(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMlflowApps",
	}
}
