// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakergeospatial

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a Vector Enrichment job for the supplied job type. Currently, there are
// two supported job types: reverse geocoding and map matching.
func (c *Client) StartVectorEnrichmentJob(ctx context.Context, params *StartVectorEnrichmentJobInput, optFns ...func(*Options)) (*StartVectorEnrichmentJobOutput, error) {
	if params == nil {
		params = &StartVectorEnrichmentJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartVectorEnrichmentJob", params, optFns, c.addOperationStartVectorEnrichmentJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartVectorEnrichmentJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartVectorEnrichmentJobInput struct {

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
	//
	// This member is required.
	ExecutionRoleArn *string

	// Input configuration information for the Vector Enrichment job.
	//
	// This member is required.
	InputConfig *types.VectorEnrichmentJobInputConfig

	// An object containing information about the job configuration.
	//
	// This member is required.
	JobConfig types.VectorEnrichmentJobConfig

	// The name of the Vector Enrichment job.
	//
	// This member is required.
	Name *string

	// A unique token that guarantees that the call to this API is idempotent.
	ClientToken *string

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string

	// Each tag consists of a key and a value.
	Tags map[string]string

	noSmithyDocumentSerde
}

type StartVectorEnrichmentJobOutput struct {

	// The Amazon Resource Name (ARN) of the Vector Enrichment job.
	//
	// This member is required.
	Arn *string

	// The creation time.
	//
	// This member is required.
	CreationTime *time.Time

	// The duration of the Vector Enrichment job, in seconds.
	//
	// This member is required.
	DurationInSeconds *int32

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
	//
	// This member is required.
	ExecutionRoleArn *string

	// Input configuration information for starting the Vector Enrichment job.
	//
	// This member is required.
	InputConfig *types.VectorEnrichmentJobInputConfig

	// An object containing information about the job configuration.
	//
	// This member is required.
	JobConfig types.VectorEnrichmentJobConfig

	// The name of the Vector Enrichment job.
	//
	// This member is required.
	Name *string

	// The status of the Vector Enrichment job being started.
	//
	// This member is required.
	Status types.VectorEnrichmentJobStatus

	// The type of the Vector Enrichment job.
	//
	// This member is required.
	Type types.VectorEnrichmentJobType

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string

	// Each tag consists of a key and a value.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartVectorEnrichmentJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartVectorEnrichmentJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartVectorEnrichmentJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartVectorEnrichmentJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartVectorEnrichmentJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartVectorEnrichmentJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartVectorEnrichmentJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartVectorEnrichmentJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartVectorEnrichmentJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartVectorEnrichmentJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartVectorEnrichmentJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartVectorEnrichmentJobInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartVectorEnrichmentJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartVectorEnrichmentJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartVectorEnrichmentJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartVectorEnrichmentJob",
	}
}
