// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/document"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Return a list of findings that match the specified criteria. GetFindings and
// GetFindingsV2 both use securityhub:GetFindings in the Action element of an IAM
// policy statement. You must have permission to perform the
// securityhub:GetFindings action.
func (c *Client) GetFindingsV2(ctx context.Context, params *GetFindingsV2Input, optFns ...func(*Options)) (*GetFindingsV2Output, error) {
	if params == nil {
		params = &GetFindingsV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFindingsV2", params, optFns, c.addOperationGetFindingsV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFindingsV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFindingsV2Input struct {

	// The finding attributes used to define a condition to filter the returned OCSF
	// findings. You can filter up to 10 composite filters. For each filter type inside
	// of a composite filter, you can provide up to 20 filters.
	Filters *types.OcsfFindingFilters

	// The maximum number of results to return.
	MaxResults *int32

	//  The token required for pagination. On your first call, set the value of this
	// parameter to NULL . For subsequent calls, to continue listing data, set the
	// value of this parameter to the value returned in the previous response.
	NextToken *string

	// The finding attributes used to sort the list of returned findings.
	SortCriteria []types.SortCriterion

	noSmithyDocumentSerde
}

type GetFindingsV2Output struct {

	// An array of security findings returned by the operation.
	Findings []document.Interface

	// The pagination token to use to request the next page of results. Otherwise,
	// this parameter is null.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFindingsV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFindingsV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFindingsV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFindingsV2"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFindingsV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetFindingsV2PaginatorOptions is the paginator options for GetFindingsV2
type GetFindingsV2PaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetFindingsV2Paginator is a paginator for GetFindingsV2
type GetFindingsV2Paginator struct {
	options   GetFindingsV2PaginatorOptions
	client    GetFindingsV2APIClient
	params    *GetFindingsV2Input
	nextToken *string
	firstPage bool
}

// NewGetFindingsV2Paginator returns a new GetFindingsV2Paginator
func NewGetFindingsV2Paginator(client GetFindingsV2APIClient, params *GetFindingsV2Input, optFns ...func(*GetFindingsV2PaginatorOptions)) *GetFindingsV2Paginator {
	if params == nil {
		params = &GetFindingsV2Input{}
	}

	options := GetFindingsV2PaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetFindingsV2Paginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetFindingsV2Paginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetFindingsV2 page.
func (p *GetFindingsV2Paginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetFindingsV2Output, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetFindingsV2(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetFindingsV2APIClient is a client that implements the GetFindingsV2 operation.
type GetFindingsV2APIClient interface {
	GetFindingsV2(context.Context, *GetFindingsV2Input, ...func(*Options)) (*GetFindingsV2Output, error)
}

var _ GetFindingsV2APIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetFindingsV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFindingsV2",
	}
}
