// Code generated by smithy-go-codegen DO NOT EDIT.

package securityir

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityir/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Investigation performed by an agent for a security incident...
func (c *Client) ListInvestigations(ctx context.Context, params *ListInvestigationsInput, optFns ...func(*Options)) (*ListInvestigationsOutput, error) {
	if params == nil {
		params = &ListInvestigationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInvestigations", params, optFns, c.addOperationListInvestigationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInvestigationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInvestigationsInput struct {

	// Investigation performed by an agent for a security incident per caseID
	//
	// This member is required.
	CaseId *string

	// Investigation performed by an agent for a security incident request, returning
	// max results
	MaxResults *int32

	// Investigation performed by an agent for a security incident request
	NextToken *string

	noSmithyDocumentSerde
}

type ListInvestigationsOutput struct {

	// Investigation performed by an agent for a security incid…Unique identifier for
	// the specific investigation>
	//
	// This member is required.
	InvestigationActions []types.InvestigationAction

	// Investigation performed by an agent for a security incident for next Token
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInvestigationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListInvestigations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListInvestigations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInvestigations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListInvestigationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInvestigations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListInvestigationsPaginatorOptions is the paginator options for
// ListInvestigations
type ListInvestigationsPaginatorOptions struct {
	// Investigation performed by an agent for a security incident request, returning
	// max results
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInvestigationsPaginator is a paginator for ListInvestigations
type ListInvestigationsPaginator struct {
	options   ListInvestigationsPaginatorOptions
	client    ListInvestigationsAPIClient
	params    *ListInvestigationsInput
	nextToken *string
	firstPage bool
}

// NewListInvestigationsPaginator returns a new ListInvestigationsPaginator
func NewListInvestigationsPaginator(client ListInvestigationsAPIClient, params *ListInvestigationsInput, optFns ...func(*ListInvestigationsPaginatorOptions)) *ListInvestigationsPaginator {
	if params == nil {
		params = &ListInvestigationsInput{}
	}

	options := ListInvestigationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInvestigationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInvestigationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInvestigations page.
func (p *ListInvestigationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInvestigationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInvestigations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInvestigationsAPIClient is a client that implements the ListInvestigations
// operation.
type ListInvestigationsAPIClient interface {
	ListInvestigations(context.Context, *ListInvestigationsInput, ...func(*Options)) (*ListInvestigationsOutput, error)
}

var _ ListInvestigationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInvestigations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInvestigations",
	}
}
