// Code generated by smithy-go-codegen DO NOT EDIT.

package servicecatalog

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Disable portfolio sharing through the Organizations service. This command will
// not delete your current shares, but prevents you from creating new shares
// throughout your organization. Current shares are not kept in sync with your
// organization structure if the structure changes after calling this API. Only the
// management account in the organization can call this API.
//
// You cannot call this API if there are active delegated administrators in the
// organization.
//
// Note that a delegated administrator is not authorized to invoke
// DisableAWSOrganizationsAccess .
//
// If you share an Service Catalog portfolio in an organization within
// Organizations, and then disable Organizations access for Service Catalog, the
// portfolio access permissions will not sync with the latest changes to the
// organization structure. Specifically, accounts that you removed from the
// organization after disabling Service Catalog access will retain access to the
// previously shared portfolio.
func (c *Client) DisableAWSOrganizationsAccess(ctx context.Context, params *DisableAWSOrganizationsAccessInput, optFns ...func(*Options)) (*DisableAWSOrganizationsAccessOutput, error) {
	if params == nil {
		params = &DisableAWSOrganizationsAccessInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisableAWSOrganizationsAccess", params, optFns, c.addOperationDisableAWSOrganizationsAccessMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisableAWSOrganizationsAccessOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisableAWSOrganizationsAccessInput struct {
	noSmithyDocumentSerde
}

type DisableAWSOrganizationsAccessOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisableAWSOrganizationsAccessMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDisableAWSOrganizationsAccess{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDisableAWSOrganizationsAccess{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisableAWSOrganizationsAccess"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisableAWSOrganizationsAccess(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisableAWSOrganizationsAccess(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisableAWSOrganizationsAccess",
	}
}
