// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Gives a detailed description of failed messages in the batch.
type BatchResultErrorEntry struct {

	// An error code representing why the action failed on this entry.
	//
	// This member is required.
	Code *string

	// The Id of an entry in a batch request
	//
	// This member is required.
	Id *string

	// Specifies whether the error happened due to the caller of the batch API action.
	//
	// This member is required.
	SenderFault bool

	// A message explaining why the action failed on this entry.
	Message *string

	noSmithyDocumentSerde
}

// The endpoint for mobile app and device.
type Endpoint struct {

	// Attributes for endpoint.
	Attributes map[string]string

	// The EndpointArn for mobile app and device.
	EndpointArn *string

	noSmithyDocumentSerde
}

// The user-specified message attribute value. For string data types, the value
// attribute has the same restrictions on the content as the message body. For more
// information, see [Publish].
//
// Name, type, and value must not be empty or null. In addition, the message body
// should not be empty or null. All parts of the message attribute, including name,
// type, and value, are included in the message size restriction, which is
// currently 256 KB (262,144 bytes). For more information, see [Amazon SNS message attributes]and [Publishing to a mobile phone] in the Amazon
// SNS Developer Guide.
//
// [Publishing to a mobile phone]: https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html
// [Amazon SNS message attributes]: https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html
// [Publish]: https://docs.aws.amazon.com/sns/latest/api/API_Publish.html
type MessageAttributeValue struct {

	// Amazon SNS supports the following logical data types: String, String.Array,
	// Number, and Binary. For more information, see [Message Attribute Data Types].
	//
	// [Message Attribute Data Types]: https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes
	//
	// This member is required.
	DataType *string

	// Binary type attributes can store any binary data, for example, compressed data,
	// encrypted data, or images.
	BinaryValue []byte

	// Strings are Unicode with UTF8 binary encoding. For a list of code values, see [ASCII Printable Characters].
	//
	// [ASCII Printable Characters]: https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	StringValue *string

	noSmithyDocumentSerde
}

// A list of phone numbers and their metadata.
type PhoneNumberInformation struct {

	// The date and time when the phone number was created.
	CreatedAt *time.Time

	// The two-character code for the country or region, in ISO 3166-1 alpha-2 format.
	Iso2CountryCode *string

	// The capabilities of each phone number.
	NumberCapabilities []NumberCapability

	// The phone number.
	PhoneNumber *string

	// The list of supported routes.
	RouteType RouteType

	// The status of the phone number.
	Status *string

	noSmithyDocumentSerde
}

// Platform application object.
type PlatformApplication struct {

	// Attributes for platform application object.
	Attributes map[string]string

	// PlatformApplicationArn for platform application object.
	PlatformApplicationArn *string

	noSmithyDocumentSerde
}

// Contains the details of a single Amazon SNS message along with an Id that
// identifies a message within the batch.
type PublishBatchRequestEntry struct {

	// An identifier for the message in this batch.
	//
	// The Ids of a batch request must be unique within a request.
	//
	// This identifier can have up to 80 characters. The following characters are
	// accepted: alphanumeric characters, hyphens(-), and underscores (_).
	//
	// This member is required.
	Id *string

	// The body of the message.
	//
	// This member is required.
	Message *string

	// Each message attribute consists of a Name , Type , and Value . For more
	// information, see [Amazon SNS message attributes]in the Amazon SNS Developer Guide.
	//
	// [Amazon SNS message attributes]: https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html
	MessageAttributes map[string]MessageAttributeValue

	// This parameter applies only to FIFO (first-in-first-out) topics.
	//
	//   - This parameter applies only to FIFO (first-in-first-out) topics. The
	//   MessageDeduplicationId can contain up to 128 alphanumeric characters (a-z,
	//   A-Z, 0-9) and punctuation (!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~) .
	//
	//   - Every message must have a unique MessageDeduplicationId , which is a token
	//   used for deduplication of sent messages within the 5 minute minimum
	//   deduplication interval.
	//
	//   - The scope of deduplication depends on the FifoThroughputScope attribute,
	//   when set to Topic the message deduplication scope is across the entire topic,
	//   when set to MessageGroup the message deduplication scope is within each
	//   individual message group.
	//
	//   - If a message with a particular MessageDeduplicationId is sent successfully,
	//   subsequent messages within the deduplication scope and interval, with the same
	//   MessageDeduplicationId , are accepted successfully but aren't delivered.
	//
	//   - Every message must have a unique MessageDeduplicationId .
	//
	//   - You may provide a MessageDeduplicationId explicitly.
	//
	//   - If you aren't able to provide a MessageDeduplicationId and you enable
	//   ContentBasedDeduplication for your topic, Amazon SNS uses a SHA-256 hash to
	//   generate the MessageDeduplicationId using the body of the message (but not the
	//   attributes of the message).
	//
	//   - If you don't provide a MessageDeduplicationId and the topic doesn't have
	//   ContentBasedDeduplication set, the action fails with an error.
	//
	//   - If the topic has a ContentBasedDeduplication set, your
	//   MessageDeduplicationId overrides the generated one.
	//
	//   - When ContentBasedDeduplication is in effect, messages with identical content
	//   sent within the deduplication scope and interval are treated as duplicates and
	//   only one copy of the message is delivered.
	//
	//   - If you send one message with ContentBasedDeduplication enabled, and then
	//   another message with a MessageDeduplicationId that is the same as the one
	//   generated for the first MessageDeduplicationId , the two messages are treated
	//   as duplicates, within the deduplication scope and interval, and only one copy of
	//   the message is delivered.
	//
	// The MessageDeduplicationId is available to the consumer of the message (this
	// can be useful for troubleshooting delivery issues).
	//
	// If a message is sent successfully but the acknowledgement is lost and the
	// message is resent with the same MessageDeduplicationId after the deduplication
	// interval, Amazon SNS can't detect duplicate messages.
	//
	// Amazon SNS continues to keep track of the message deduplication ID even after
	// the message is received and deleted.
	MessageDeduplicationId *string

	// FIFO topics: The tag that specifies that a message belongs to a specific
	// message group. Messages that belong to the same message group are processed in a
	// FIFO manner (however, messages in different message groups might be processed
	// out of order). To interleave multiple ordered streams within a single topic, use
	// MessageGroupId values (for example, session data for multiple users). In this
	// scenario, multiple consumers can process the topic, but the session data of each
	// user is processed in a FIFO fashion. You must associate a non-empty
	// MessageGroupId with a message. If you do not provide a MessageGroupId , the
	// action fails.
	//
	// Standard topics: The MessageGroupId is optional and is forwarded only to Amazon
	// SQS standard subscriptions to activate [fair queues]. The MessageGroupId is not used for, or
	// sent to, any other endpoint types.
	//
	// The length of MessageGroupId is 128 characters.
	//
	// MessageGroupId can contain alphanumeric characters (a-z, A-Z, 0-9) and
	// punctuation (!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~) .
	//
	// [fair queues]: https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-fair-queues.html
	MessageGroupId *string

	// Set MessageStructure to json if you want to send a different message for each
	// protocol. For example, using one publish action, you can send a short message to
	// your SMS subscribers and a longer message to your email subscribers. If you set
	// MessageStructure to json , the value of the Message parameter must:
	//
	//   - be a syntactically valid JSON object; and
	//
	//   - contain at least a top-level JSON key of "default" with a value that is a
	//   string.
	//
	// You can define other top-level keys that define the message you want to send to
	// a specific transport protocol (for example, http).
	MessageStructure *string

	// The subject of the batch message.
	Subject *string

	noSmithyDocumentSerde
}

// Encloses data related to a successful message in a batch request for topic.
type PublishBatchResultEntry struct {

	// The Id of an entry in a batch request.
	Id *string

	// An identifier for the message.
	MessageId *string

	// This parameter applies only to FIFO (first-in-first-out) topics.
	//
	// The large, non-consecutive number that Amazon SNS assigns to each message.
	//
	// The length of SequenceNumber is 128 bits. SequenceNumber continues to increase
	// for a particular MessageGroupId .
	SequenceNumber *string

	noSmithyDocumentSerde
}

// A verified or pending destination phone number in the SMS sandbox.
//
// When you start using Amazon SNS to send SMS messages, your Amazon Web Services
// account is in the SMS sandbox. The SMS sandbox provides a safe environment for
// you to try Amazon SNS features without risking your reputation as an SMS sender.
// While your Amazon Web Services account is in the SMS sandbox, you can use all of
// the features of Amazon SNS. However, you can send SMS messages only to verified
// destination phone numbers. For more information, including how to move out of
// the sandbox to send messages without restrictions, see [SMS sandbox]in the Amazon SNS
// Developer Guide.
//
// [SMS sandbox]: https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html
type SMSSandboxPhoneNumber struct {

	// The destination phone number.
	PhoneNumber *string

	// The destination phone number's verification status.
	Status SMSSandboxPhoneNumberVerificationStatus

	noSmithyDocumentSerde
}

// A wrapper type for the attributes of an Amazon SNS subscription.
type Subscription struct {

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string

	// The subscription's owner.
	Owner *string

	// The subscription's protocol.
	Protocol *string

	// The subscription's ARN.
	SubscriptionArn *string

	// The ARN of the subscription's topic.
	TopicArn *string

	noSmithyDocumentSerde
}

// The list of tags to be added to the specified topic.
type Tag struct {

	// The required key portion of the tag.
	//
	// This member is required.
	Key *string

	// The optional value portion of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A wrapper type for the topic's Amazon Resource Name (ARN). To retrieve a
// topic's attributes, use GetTopicAttributes .
type Topic struct {

	// The topic's ARN.
	TopicArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
