// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmcontacts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssmcontacts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the information specified for an on-call rotation.
func (c *Client) UpdateRotation(ctx context.Context, params *UpdateRotationInput, optFns ...func(*Options)) (*UpdateRotationOutput, error) {
	if params == nil {
		params = &UpdateRotationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateRotation", params, optFns, c.addOperationUpdateRotationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateRotationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateRotationInput struct {

	// Information about how long the updated rotation lasts before restarting at the
	// beginning of the shift order.
	//
	// This member is required.
	Recurrence *types.RecurrenceSettings

	// The Amazon Resource Name (ARN) of the rotation to update.
	//
	// This member is required.
	RotationId *string

	// The Amazon Resource Names (ARNs) of the contacts to include in the updated
	// rotation.
	//
	// Only the PERSONAL contact type is supported. The contact types ESCALATION and
	// ONCALL_SCHEDULE are not supported for this operation.
	//
	// The order in which you list the contacts is their shift order in the rotation
	// schedule.
	ContactIds []string

	// The date and time the rotation goes into effect.
	StartTime *time.Time

	// The time zone to base the updated rotation’s activity on, in Internet Assigned
	// Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
	// "Asia/Seoul". For more information, see the [Time Zone Database]on the IANA website.
	//
	// Designators for time zones that don’t support Daylight Savings Time Rules, such
	// as Pacific Standard Time (PST), aren't supported.
	//
	// [Time Zone Database]: https://www.iana.org/time-zones
	TimeZoneId *string

	noSmithyDocumentSerde
}

type UpdateRotationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateRotationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateRotation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateRotation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateRotation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateRotationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateRotation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateRotation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateRotation",
	}
}
