// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of existing cache reports for all file shares associated with
// your Amazon Web Services account. This list includes all information provided by
// the DescribeCacheReport action, such as report name, status, completion
// progress, start time, end time, filters, and tags.
func (c *Client) ListCacheReports(ctx context.Context, params *ListCacheReportsInput, optFns ...func(*Options)) (*ListCacheReportsOutput, error) {
	if params == nil {
		params = &ListCacheReportsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCacheReports", params, optFns, c.addOperationListCacheReportsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCacheReportsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCacheReportsInput struct {

	// Opaque pagination token returned from a previous ListCacheReports operation. If
	// present, Marker specifies where to continue the list from after a previous call
	// to ListCacheReports . Optional.
	Marker *string

	noSmithyDocumentSerde
}

type ListCacheReportsOutput struct {

	// A list of existing cache reports for all file shares associated with your
	// Amazon Web Services account. This list includes all information provided by the
	// DescribeCacheReport action, such as report status, completion progress, start
	// time, end time, filters, and tags.
	CacheReportList []types.CacheReportInfo

	// If the request includes Marker , the response returns that value in this field.
	Marker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCacheReportsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListCacheReports{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListCacheReports{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCacheReports"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCacheReports(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCacheReportsPaginatorOptions is the paginator options for ListCacheReports
type ListCacheReportsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCacheReportsPaginator is a paginator for ListCacheReports
type ListCacheReportsPaginator struct {
	options   ListCacheReportsPaginatorOptions
	client    ListCacheReportsAPIClient
	params    *ListCacheReportsInput
	nextToken *string
	firstPage bool
}

// NewListCacheReportsPaginator returns a new ListCacheReportsPaginator
func NewListCacheReportsPaginator(client ListCacheReportsAPIClient, params *ListCacheReportsInput, optFns ...func(*ListCacheReportsPaginatorOptions)) *ListCacheReportsPaginator {
	if params == nil {
		params = &ListCacheReportsInput{}
	}

	options := ListCacheReportsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCacheReportsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCacheReportsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCacheReports page.
func (p *ListCacheReportsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCacheReportsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCacheReports(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCacheReportsAPIClient is a client that implements the ListCacheReports
// operation.
type ListCacheReportsAPIClient interface {
	ListCacheReports(context.Context, *ListCacheReportsInput, ...func(*Options)) (*ListCacheReportsOutput, error)
}

var _ ListCacheReportsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCacheReports(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCacheReports",
	}
}
