// Code generated by smithy-go-codegen DO NOT EDIT.

package supplychain

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/supplychain/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Send the data payload for the event with real-time data for analysis or
// monitoring. The real-time data events are stored in an Amazon Web Services
// service before being processed and stored in data lake.
func (c *Client) SendDataIntegrationEvent(ctx context.Context, params *SendDataIntegrationEventInput, optFns ...func(*Options)) (*SendDataIntegrationEventOutput, error) {
	if params == nil {
		params = &SendDataIntegrationEventInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SendDataIntegrationEvent", params, optFns, c.addOperationSendDataIntegrationEventMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SendDataIntegrationEventOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request parameters for SendDataIntegrationEvent.
type SendDataIntegrationEventInput struct {

	// The data payload of the event, should follow the data schema of the target
	// dataset, or see [Data entities supported in AWS Supply Chain]. To send single data record, use JsonObject format; to send
	// multiple data records, use JsonArray format.
	//
	// Note that for AWS Supply Chain dataset under asc namespace, it has a
	// connection_id internal field that is not allowed to be provided by client
	// directly, they will be auto populated.
	//
	// [Data entities supported in AWS Supply Chain]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html
	//
	// This member is required.
	Data *string

	// Event identifier (for example, orderId for InboundOrder) used for data sharding
	// or partitioning. Noted under one eventGroupId of same eventType and instanceId,
	// events are processed sequentially in the order they are received by the server.
	//
	// This member is required.
	EventGroupId *string

	// The data event type.
	//
	//   - scn.data.dataset - Send data directly to any specified dataset.
	//
	//   - scn.data.supplyplan - Send data to [supply_plan]dataset.
	//
	//   - scn.data.shipmentstoporder - Send data to [shipment_stop_order]dataset.
	//
	//   - scn.data.shipmentstop - Send data to [shipment_stop]dataset.
	//
	//   - scn.data.shipment - Send data to [shipment]dataset.
	//
	//   - scn.data.reservation - Send data to [reservation]dataset.
	//
	//   - scn.data.processproduct - Send data to [process_product]dataset.
	//
	//   - scn.data.processoperation - Send data to [process_operation]dataset.
	//
	//   - scn.data.processheader - Send data to [process_header]dataset.
	//
	//   - scn.data.forecast - Send data to [forecast]dataset.
	//
	//   - scn.data.inventorylevel - Send data to [inv_level]dataset.
	//
	//   - scn.data.inboundorder - Send data to [inbound_order]dataset.
	//
	//   - scn.data.inboundorderline - Send data to [inbound_order_line]dataset.
	//
	//   - scn.data.inboundorderlineschedule - Send data to [inbound_order_line_schedule]dataset.
	//
	//   - scn.data.outboundorderline - Send data to [outbound_order_line]dataset.
	//
	//   - scn.data.outboundshipment - Send data to [outbound_shipment]dataset.
	//
	// [process_header]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/operation-process-header-entity.html
	// [inbound_order_line_schedule]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/replenishment-inbound-order-line-schedule-entity.html
	// [shipment]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/replenishment-shipment-entity.html
	// [inv_level]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/inventory_mgmnt-inv-level-entity.html
	// [shipment_stop]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/replenishment-shipment-stop-entity.html
	// [process_product]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/operation-process-product-entity.html
	// [inbound_order_line]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/replenishment-inbound-order-line-entity.html
	// [forecast]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/forecast-forecast-entity.html
	// [outbound_order_line]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/outbound-fulfillment-order-line-entity.html
	// [outbound_shipment]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/outbound-fulfillment-shipment-entity.html
	// [supply_plan]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/supply-plan-entity.html
	// [process_operation]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/operation-process-operation-entity.html
	// [inbound_order]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/replenishment-inbound-order-entity.html
	// [reservation]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/planning-reservation-entity.html
	// [shipment_stop_order]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/replenishment-shipment-stop-order-entity.html
	//
	// This member is required.
	EventType types.DataIntegrationEventType

	// The AWS Supply Chain instance identifier.
	//
	// This member is required.
	InstanceId *string

	// The idempotent client token. The token is active for 8 hours, and within its
	// lifetime, it ensures the request completes only once upon retry with same client
	// token. If omitted, the AWS SDK generates a unique value so that AWS SDK can
	// safely retry the request upon network errors.
	ClientToken *string

	// The target dataset configuration for scn.data.dataset event type.
	DatasetTarget *types.DataIntegrationEventDatasetTargetConfiguration

	// The timestamp (in epoch seconds) associated with the event. If not provided, it
	// will be assigned with current timestamp.
	EventTimestamp *time.Time

	noSmithyDocumentSerde
}

// The response parameters for SendDataIntegrationEvent.
type SendDataIntegrationEventOutput struct {

	// The unique event identifier.
	//
	// This member is required.
	EventId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSendDataIntegrationEventMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSendDataIntegrationEvent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSendDataIntegrationEvent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SendDataIntegrationEvent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opSendDataIntegrationEventMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpSendDataIntegrationEventValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSendDataIntegrationEvent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpSendDataIntegrationEvent struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpSendDataIntegrationEvent) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpSendDataIntegrationEvent) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*SendDataIntegrationEventInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *SendDataIntegrationEventInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opSendDataIntegrationEventMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpSendDataIntegrationEvent{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opSendDataIntegrationEvent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SendDataIntegrationEvent",
	}
}
