// Code generated by smithy-go-codegen DO NOT EDIT.

package synthetics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/synthetics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation returns a list of the canaries in your account, along with full
// details about each canary.
//
// This operation supports resource-level authorization using an IAM policy and
// the Names parameter. If you specify the Names parameter, the operation is
// successful only if you have authorization to view all the canaries that you
// specify in your request. If you do not have permission to view any of the
// canaries, the request fails with a 403 response.
//
// You are required to use the Names parameter if you are logged on to a user or
// role that has an IAM policy that restricts which canaries that you are allowed
// to view. For more information, see [Limiting a user to viewing specific canaries].
//
// [Limiting a user to viewing specific canaries]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html
func (c *Client) DescribeCanaries(ctx context.Context, params *DescribeCanariesInput, optFns ...func(*Options)) (*DescribeCanariesOutput, error) {
	if params == nil {
		params = &DescribeCanariesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCanaries", params, optFns, c.addOperationDescribeCanariesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCanariesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCanariesInput struct {

	// Specify this parameter to limit how many canaries are returned each time you
	// use the DescribeCanaries operation. If you omit this parameter, the default of
	// 20 is used.
	MaxResults *int32

	// Use this parameter to return only canaries that match the names that you
	// specify here. You can specify as many as five canary names.
	//
	// If you specify this parameter, the operation is successful only if you have
	// authorization to view all the canaries that you specify in your request. If you
	// do not have permission to view any of the canaries, the request fails with a 403
	// response.
	//
	// You are required to use this parameter if you are logged on to a user or role
	// that has an IAM policy that restricts which canaries that you are allowed to
	// view. For more information, see [Limiting a user to viewing specific canaries].
	//
	// [Limiting a user to viewing specific canaries]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html
	Names []string

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent operation to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeCanariesOutput struct {

	// Returns an array. Each item in the array contains the full information about
	// one canary.
	Canaries []types.Canary

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeCanaries operation to retrieve the next set of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCanariesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeCanaries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeCanaries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeCanaries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCanaries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeCanariesPaginatorOptions is the paginator options for DescribeCanaries
type DescribeCanariesPaginatorOptions struct {
	// Specify this parameter to limit how many canaries are returned each time you
	// use the DescribeCanaries operation. If you omit this parameter, the default of
	// 20 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeCanariesPaginator is a paginator for DescribeCanaries
type DescribeCanariesPaginator struct {
	options   DescribeCanariesPaginatorOptions
	client    DescribeCanariesAPIClient
	params    *DescribeCanariesInput
	nextToken *string
	firstPage bool
}

// NewDescribeCanariesPaginator returns a new DescribeCanariesPaginator
func NewDescribeCanariesPaginator(client DescribeCanariesAPIClient, params *DescribeCanariesInput, optFns ...func(*DescribeCanariesPaginatorOptions)) *DescribeCanariesPaginator {
	if params == nil {
		params = &DescribeCanariesInput{}
	}

	options := DescribeCanariesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeCanariesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeCanariesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeCanaries page.
func (p *DescribeCanariesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeCanariesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeCanaries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeCanariesAPIClient is a client that implements the DescribeCanaries
// operation.
type DescribeCanariesAPIClient interface {
	DescribeCanaries(context.Context, *DescribeCanariesInput, ...func(*Options)) (*DescribeCanariesOutput, error)
}

var _ DescribeCanariesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeCanaries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeCanaries",
	}
}
