// Code generated by smithy-go-codegen DO NOT EDIT.

package timestreaminfluxdb

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsjson10_serializeOpCreateDbCluster struct {
}

func (*awsAwsjson10_serializeOpCreateDbCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateDbCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDbClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.CreateDbCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateDbClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateDbInstance struct {
}

func (*awsAwsjson10_serializeOpCreateDbInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateDbInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDbInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.CreateDbInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateDbInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateDbParameterGroup struct {
}

func (*awsAwsjson10_serializeOpCreateDbParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateDbParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDbParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.CreateDbParameterGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateDbParameterGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteDbCluster struct {
}

func (*awsAwsjson10_serializeOpDeleteDbCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteDbCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDbClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.DeleteDbCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteDbClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteDbInstance struct {
}

func (*awsAwsjson10_serializeOpDeleteDbInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteDbInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDbInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.DeleteDbInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteDbInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetDbCluster struct {
}

func (*awsAwsjson10_serializeOpGetDbCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetDbCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDbClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.GetDbCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetDbClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetDbInstance struct {
}

func (*awsAwsjson10_serializeOpGetDbInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetDbInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDbInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.GetDbInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetDbInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetDbParameterGroup struct {
}

func (*awsAwsjson10_serializeOpGetDbParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetDbParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDbParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.GetDbParameterGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetDbParameterGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListDbClusters struct {
}

func (*awsAwsjson10_serializeOpListDbClusters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListDbClusters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDbClustersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.ListDbClusters")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListDbClustersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListDbInstances struct {
}

func (*awsAwsjson10_serializeOpListDbInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListDbInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDbInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.ListDbInstances")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListDbInstancesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListDbInstancesForCluster struct {
}

func (*awsAwsjson10_serializeOpListDbInstancesForCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListDbInstancesForCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDbInstancesForClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.ListDbInstancesForCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListDbInstancesForClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListDbParameterGroups struct {
}

func (*awsAwsjson10_serializeOpListDbParameterGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListDbParameterGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDbParameterGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.ListDbParameterGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListDbParameterGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListTagsForResource struct {
}

func (*awsAwsjson10_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpTagResource struct {
}

func (*awsAwsjson10_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUntagResource struct {
}

func (*awsAwsjson10_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateDbCluster struct {
}

func (*awsAwsjson10_serializeOpUpdateDbCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateDbCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDbClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.UpdateDbCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateDbClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateDbInstance struct {
}

func (*awsAwsjson10_serializeOpUpdateDbInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateDbInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDbInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonTimestreamInfluxDB.UpdateDbInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateDbInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson10_serializeDocumentDuration(v *types.Duration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DurationType) > 0 {
		ok := object.Key("durationType")
		ok.String(string(v.DurationType))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.Long(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentInfluxDBv2Parameters(v *types.InfluxDBv2Parameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FluxLogEnabled != nil {
		ok := object.Key("fluxLogEnabled")
		ok.Boolean(*v.FluxLogEnabled)
	}

	if v.HttpIdleTimeout != nil {
		ok := object.Key("httpIdleTimeout")
		if err := awsAwsjson10_serializeDocumentDuration(v.HttpIdleTimeout, ok); err != nil {
			return err
		}
	}

	if v.HttpReadHeaderTimeout != nil {
		ok := object.Key("httpReadHeaderTimeout")
		if err := awsAwsjson10_serializeDocumentDuration(v.HttpReadHeaderTimeout, ok); err != nil {
			return err
		}
	}

	if v.HttpReadTimeout != nil {
		ok := object.Key("httpReadTimeout")
		if err := awsAwsjson10_serializeDocumentDuration(v.HttpReadTimeout, ok); err != nil {
			return err
		}
	}

	if v.HttpWriteTimeout != nil {
		ok := object.Key("httpWriteTimeout")
		if err := awsAwsjson10_serializeDocumentDuration(v.HttpWriteTimeout, ok); err != nil {
			return err
		}
	}

	if v.InfluxqlMaxSelectBuckets != nil {
		ok := object.Key("influxqlMaxSelectBuckets")
		ok.Long(*v.InfluxqlMaxSelectBuckets)
	}

	if v.InfluxqlMaxSelectPoint != nil {
		ok := object.Key("influxqlMaxSelectPoint")
		ok.Long(*v.InfluxqlMaxSelectPoint)
	}

	if v.InfluxqlMaxSelectSeries != nil {
		ok := object.Key("influxqlMaxSelectSeries")
		ok.Long(*v.InfluxqlMaxSelectSeries)
	}

	if len(v.LogLevel) > 0 {
		ok := object.Key("logLevel")
		ok.String(string(v.LogLevel))
	}

	if v.MetricsDisabled != nil {
		ok := object.Key("metricsDisabled")
		ok.Boolean(*v.MetricsDisabled)
	}

	if v.NoTasks != nil {
		ok := object.Key("noTasks")
		ok.Boolean(*v.NoTasks)
	}

	if v.PprofDisabled != nil {
		ok := object.Key("pprofDisabled")
		ok.Boolean(*v.PprofDisabled)
	}

	if v.QueryConcurrency != nil {
		ok := object.Key("queryConcurrency")
		ok.Integer(*v.QueryConcurrency)
	}

	if v.QueryInitialMemoryBytes != nil {
		ok := object.Key("queryInitialMemoryBytes")
		ok.Long(*v.QueryInitialMemoryBytes)
	}

	if v.QueryMaxMemoryBytes != nil {
		ok := object.Key("queryMaxMemoryBytes")
		ok.Long(*v.QueryMaxMemoryBytes)
	}

	if v.QueryMemoryBytes != nil {
		ok := object.Key("queryMemoryBytes")
		ok.Long(*v.QueryMemoryBytes)
	}

	if v.QueryQueueSize != nil {
		ok := object.Key("queryQueueSize")
		ok.Integer(*v.QueryQueueSize)
	}

	if v.SessionLength != nil {
		ok := object.Key("sessionLength")
		ok.Integer(*v.SessionLength)
	}

	if v.SessionRenewDisabled != nil {
		ok := object.Key("sessionRenewDisabled")
		ok.Boolean(*v.SessionRenewDisabled)
	}

	if v.StorageCacheMaxMemorySize != nil {
		ok := object.Key("storageCacheMaxMemorySize")
		ok.Long(*v.StorageCacheMaxMemorySize)
	}

	if v.StorageCacheSnapshotMemorySize != nil {
		ok := object.Key("storageCacheSnapshotMemorySize")
		ok.Long(*v.StorageCacheSnapshotMemorySize)
	}

	if v.StorageCacheSnapshotWriteColdDuration != nil {
		ok := object.Key("storageCacheSnapshotWriteColdDuration")
		if err := awsAwsjson10_serializeDocumentDuration(v.StorageCacheSnapshotWriteColdDuration, ok); err != nil {
			return err
		}
	}

	if v.StorageCompactFullWriteColdDuration != nil {
		ok := object.Key("storageCompactFullWriteColdDuration")
		if err := awsAwsjson10_serializeDocumentDuration(v.StorageCompactFullWriteColdDuration, ok); err != nil {
			return err
		}
	}

	if v.StorageCompactThroughputBurst != nil {
		ok := object.Key("storageCompactThroughputBurst")
		ok.Long(*v.StorageCompactThroughputBurst)
	}

	if v.StorageMaxConcurrentCompactions != nil {
		ok := object.Key("storageMaxConcurrentCompactions")
		ok.Integer(*v.StorageMaxConcurrentCompactions)
	}

	if v.StorageMaxIndexLogFileSize != nil {
		ok := object.Key("storageMaxIndexLogFileSize")
		ok.Long(*v.StorageMaxIndexLogFileSize)
	}

	if v.StorageNoValidateFieldSize != nil {
		ok := object.Key("storageNoValidateFieldSize")
		ok.Boolean(*v.StorageNoValidateFieldSize)
	}

	if v.StorageRetentionCheckInterval != nil {
		ok := object.Key("storageRetentionCheckInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.StorageRetentionCheckInterval, ok); err != nil {
			return err
		}
	}

	if v.StorageSeriesFileMaxConcurrentSnapshotCompactions != nil {
		ok := object.Key("storageSeriesFileMaxConcurrentSnapshotCompactions")
		ok.Integer(*v.StorageSeriesFileMaxConcurrentSnapshotCompactions)
	}

	if v.StorageSeriesIdSetCacheSize != nil {
		ok := object.Key("storageSeriesIdSetCacheSize")
		ok.Long(*v.StorageSeriesIdSetCacheSize)
	}

	if v.StorageWalMaxConcurrentWrites != nil {
		ok := object.Key("storageWalMaxConcurrentWrites")
		ok.Integer(*v.StorageWalMaxConcurrentWrites)
	}

	if v.StorageWalMaxWriteDelay != nil {
		ok := object.Key("storageWalMaxWriteDelay")
		if err := awsAwsjson10_serializeDocumentDuration(v.StorageWalMaxWriteDelay, ok); err != nil {
			return err
		}
	}

	if len(v.TracingType) > 0 {
		ok := object.Key("tracingType")
		ok.String(string(v.TracingType))
	}

	if v.UiDisabled != nil {
		ok := object.Key("uiDisabled")
		ok.Boolean(*v.UiDisabled)
	}

	return nil
}

func awsAwsjson10_serializeDocumentInfluxDBv3CoreParameters(v *types.InfluxDBv3CoreParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataFusionConfig != nil {
		ok := object.Key("dataFusionConfig")
		ok.String(*v.DataFusionConfig)
	}

	if v.DataFusionMaxParquetFanout != nil {
		ok := object.Key("dataFusionMaxParquetFanout")
		ok.Integer(*v.DataFusionMaxParquetFanout)
	}

	if v.DataFusionNumThreads != nil {
		ok := object.Key("dataFusionNumThreads")
		ok.Integer(*v.DataFusionNumThreads)
	}

	if v.DataFusionRuntimeDisableLifoSlot != nil {
		ok := object.Key("dataFusionRuntimeDisableLifoSlot")
		ok.Boolean(*v.DataFusionRuntimeDisableLifoSlot)
	}

	if v.DataFusionRuntimeEventInterval != nil {
		ok := object.Key("dataFusionRuntimeEventInterval")
		ok.Integer(*v.DataFusionRuntimeEventInterval)
	}

	if v.DataFusionRuntimeGlobalQueueInterval != nil {
		ok := object.Key("dataFusionRuntimeGlobalQueueInterval")
		ok.Integer(*v.DataFusionRuntimeGlobalQueueInterval)
	}

	if v.DataFusionRuntimeMaxBlockingThreads != nil {
		ok := object.Key("dataFusionRuntimeMaxBlockingThreads")
		ok.Integer(*v.DataFusionRuntimeMaxBlockingThreads)
	}

	if v.DataFusionRuntimeMaxIoEventsPerTick != nil {
		ok := object.Key("dataFusionRuntimeMaxIoEventsPerTick")
		ok.Integer(*v.DataFusionRuntimeMaxIoEventsPerTick)
	}

	if v.DataFusionRuntimeThreadKeepAlive != nil {
		ok := object.Key("dataFusionRuntimeThreadKeepAlive")
		if err := awsAwsjson10_serializeDocumentDuration(v.DataFusionRuntimeThreadKeepAlive, ok); err != nil {
			return err
		}
	}

	if v.DataFusionRuntimeThreadPriority != nil {
		ok := object.Key("dataFusionRuntimeThreadPriority")
		ok.Integer(*v.DataFusionRuntimeThreadPriority)
	}

	if len(v.DataFusionRuntimeType) > 0 {
		ok := object.Key("dataFusionRuntimeType")
		ok.String(string(v.DataFusionRuntimeType))
	}

	if v.DataFusionUseCachedParquetLoader != nil {
		ok := object.Key("dataFusionUseCachedParquetLoader")
		ok.Boolean(*v.DataFusionUseCachedParquetLoader)
	}

	if v.DeleteGracePeriod != nil {
		ok := object.Key("deleteGracePeriod")
		if err := awsAwsjson10_serializeDocumentDuration(v.DeleteGracePeriod, ok); err != nil {
			return err
		}
	}

	if v.DisableParquetMemCache != nil {
		ok := object.Key("disableParquetMemCache")
		ok.Boolean(*v.DisableParquetMemCache)
	}

	if v.DistinctCacheEvictionInterval != nil {
		ok := object.Key("distinctCacheEvictionInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.DistinctCacheEvictionInterval, ok); err != nil {
			return err
		}
	}

	if v.ExecMemPoolBytes != nil {
		ok := object.Key("execMemPoolBytes")
		if err := awsAwsjson10_serializeDocumentPercentOrAbsoluteLong(v.ExecMemPoolBytes, ok); err != nil {
			return err
		}
	}

	if v.ForceSnapshotMemThreshold != nil {
		ok := object.Key("forceSnapshotMemThreshold")
		if err := awsAwsjson10_serializeDocumentPercentOrAbsoluteLong(v.ForceSnapshotMemThreshold, ok); err != nil {
			return err
		}
	}

	if v.Gen1Duration != nil {
		ok := object.Key("gen1Duration")
		if err := awsAwsjson10_serializeDocumentDuration(v.Gen1Duration, ok); err != nil {
			return err
		}
	}

	if v.Gen1LookbackDuration != nil {
		ok := object.Key("gen1LookbackDuration")
		if err := awsAwsjson10_serializeDocumentDuration(v.Gen1LookbackDuration, ok); err != nil {
			return err
		}
	}

	if v.HardDeleteDefaultDuration != nil {
		ok := object.Key("hardDeleteDefaultDuration")
		if err := awsAwsjson10_serializeDocumentDuration(v.HardDeleteDefaultDuration, ok); err != nil {
			return err
		}
	}

	if v.LastCacheEvictionInterval != nil {
		ok := object.Key("lastCacheEvictionInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.LastCacheEvictionInterval, ok); err != nil {
			return err
		}
	}

	if v.LogFilter != nil {
		ok := object.Key("logFilter")
		ok.String(*v.LogFilter)
	}

	if len(v.LogFormat) > 0 {
		ok := object.Key("logFormat")
		ok.String(string(v.LogFormat))
	}

	if v.MaxHttpRequestSize != nil {
		ok := object.Key("maxHttpRequestSize")
		ok.Long(*v.MaxHttpRequestSize)
	}

	if v.ParquetMemCachePruneInterval != nil {
		ok := object.Key("parquetMemCachePruneInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.ParquetMemCachePruneInterval, ok); err != nil {
			return err
		}
	}

	if v.ParquetMemCachePrunePercentage != nil {
		ok := object.Key("parquetMemCachePrunePercentage")
		switch {
		case math.IsNaN(float64(*v.ParquetMemCachePrunePercentage)):
			ok.String("NaN")

		case math.IsInf(float64(*v.ParquetMemCachePrunePercentage), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.ParquetMemCachePrunePercentage), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.ParquetMemCachePrunePercentage)

		}
	}

	if v.ParquetMemCacheQueryPathDuration != nil {
		ok := object.Key("parquetMemCacheQueryPathDuration")
		if err := awsAwsjson10_serializeDocumentDuration(v.ParquetMemCacheQueryPathDuration, ok); err != nil {
			return err
		}
	}

	if v.ParquetMemCacheSize != nil {
		ok := object.Key("parquetMemCacheSize")
		if err := awsAwsjson10_serializeDocumentPercentOrAbsoluteLong(v.ParquetMemCacheSize, ok); err != nil {
			return err
		}
	}

	if v.PreemptiveCacheAge != nil {
		ok := object.Key("preemptiveCacheAge")
		if err := awsAwsjson10_serializeDocumentDuration(v.PreemptiveCacheAge, ok); err != nil {
			return err
		}
	}

	if v.QueryFileLimit != nil {
		ok := object.Key("queryFileLimit")
		ok.Integer(*v.QueryFileLimit)
	}

	if v.QueryLogSize != nil {
		ok := object.Key("queryLogSize")
		ok.Integer(*v.QueryLogSize)
	}

	if v.RetentionCheckInterval != nil {
		ok := object.Key("retentionCheckInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.RetentionCheckInterval, ok); err != nil {
			return err
		}
	}

	if v.SnapshottedWalFilesToKeep != nil {
		ok := object.Key("snapshottedWalFilesToKeep")
		ok.Integer(*v.SnapshottedWalFilesToKeep)
	}

	if v.TableIndexCacheConcurrencyLimit != nil {
		ok := object.Key("tableIndexCacheConcurrencyLimit")
		ok.Integer(*v.TableIndexCacheConcurrencyLimit)
	}

	if v.TableIndexCacheMaxEntries != nil {
		ok := object.Key("tableIndexCacheMaxEntries")
		ok.Integer(*v.TableIndexCacheMaxEntries)
	}

	if v.WalMaxWriteBufferSize != nil {
		ok := object.Key("walMaxWriteBufferSize")
		ok.Integer(*v.WalMaxWriteBufferSize)
	}

	if v.WalReplayConcurrencyLimit != nil {
		ok := object.Key("walReplayConcurrencyLimit")
		ok.Integer(*v.WalReplayConcurrencyLimit)
	}

	if v.WalReplayFailOnError != nil {
		ok := object.Key("walReplayFailOnError")
		ok.Boolean(*v.WalReplayFailOnError)
	}

	if v.WalSnapshotSize != nil {
		ok := object.Key("walSnapshotSize")
		ok.Integer(*v.WalSnapshotSize)
	}

	return nil
}

func awsAwsjson10_serializeDocumentInfluxDBv3EnterpriseParameters(v *types.InfluxDBv3EnterpriseParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogSyncInterval != nil {
		ok := object.Key("catalogSyncInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.CatalogSyncInterval, ok); err != nil {
			return err
		}
	}

	if v.CompactionCheckInterval != nil {
		ok := object.Key("compactionCheckInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.CompactionCheckInterval, ok); err != nil {
			return err
		}
	}

	if v.CompactionCleanupWait != nil {
		ok := object.Key("compactionCleanupWait")
		if err := awsAwsjson10_serializeDocumentDuration(v.CompactionCleanupWait, ok); err != nil {
			return err
		}
	}

	if v.CompactionGen2Duration != nil {
		ok := object.Key("compactionGen2Duration")
		if err := awsAwsjson10_serializeDocumentDuration(v.CompactionGen2Duration, ok); err != nil {
			return err
		}
	}

	if v.CompactionMaxNumFilesPerPlan != nil {
		ok := object.Key("compactionMaxNumFilesPerPlan")
		ok.Integer(*v.CompactionMaxNumFilesPerPlan)
	}

	if v.CompactionMultipliers != nil {
		ok := object.Key("compactionMultipliers")
		ok.String(*v.CompactionMultipliers)
	}

	if v.CompactionRowLimit != nil {
		ok := object.Key("compactionRowLimit")
		ok.Integer(*v.CompactionRowLimit)
	}

	if v.DataFusionConfig != nil {
		ok := object.Key("dataFusionConfig")
		ok.String(*v.DataFusionConfig)
	}

	if v.DataFusionMaxParquetFanout != nil {
		ok := object.Key("dataFusionMaxParquetFanout")
		ok.Integer(*v.DataFusionMaxParquetFanout)
	}

	if v.DataFusionNumThreads != nil {
		ok := object.Key("dataFusionNumThreads")
		ok.Integer(*v.DataFusionNumThreads)
	}

	if v.DataFusionRuntimeDisableLifoSlot != nil {
		ok := object.Key("dataFusionRuntimeDisableLifoSlot")
		ok.Boolean(*v.DataFusionRuntimeDisableLifoSlot)
	}

	if v.DataFusionRuntimeEventInterval != nil {
		ok := object.Key("dataFusionRuntimeEventInterval")
		ok.Integer(*v.DataFusionRuntimeEventInterval)
	}

	if v.DataFusionRuntimeGlobalQueueInterval != nil {
		ok := object.Key("dataFusionRuntimeGlobalQueueInterval")
		ok.Integer(*v.DataFusionRuntimeGlobalQueueInterval)
	}

	if v.DataFusionRuntimeMaxBlockingThreads != nil {
		ok := object.Key("dataFusionRuntimeMaxBlockingThreads")
		ok.Integer(*v.DataFusionRuntimeMaxBlockingThreads)
	}

	if v.DataFusionRuntimeMaxIoEventsPerTick != nil {
		ok := object.Key("dataFusionRuntimeMaxIoEventsPerTick")
		ok.Integer(*v.DataFusionRuntimeMaxIoEventsPerTick)
	}

	if v.DataFusionRuntimeThreadKeepAlive != nil {
		ok := object.Key("dataFusionRuntimeThreadKeepAlive")
		if err := awsAwsjson10_serializeDocumentDuration(v.DataFusionRuntimeThreadKeepAlive, ok); err != nil {
			return err
		}
	}

	if v.DataFusionRuntimeThreadPriority != nil {
		ok := object.Key("dataFusionRuntimeThreadPriority")
		ok.Integer(*v.DataFusionRuntimeThreadPriority)
	}

	if len(v.DataFusionRuntimeType) > 0 {
		ok := object.Key("dataFusionRuntimeType")
		ok.String(string(v.DataFusionRuntimeType))
	}

	if v.DataFusionUseCachedParquetLoader != nil {
		ok := object.Key("dataFusionUseCachedParquetLoader")
		ok.Boolean(*v.DataFusionUseCachedParquetLoader)
	}

	if v.DedicatedCompactor != nil {
		ok := object.Key("dedicatedCompactor")
		ok.Boolean(*v.DedicatedCompactor)
	}

	if v.DeleteGracePeriod != nil {
		ok := object.Key("deleteGracePeriod")
		if err := awsAwsjson10_serializeDocumentDuration(v.DeleteGracePeriod, ok); err != nil {
			return err
		}
	}

	if v.DisableParquetMemCache != nil {
		ok := object.Key("disableParquetMemCache")
		ok.Boolean(*v.DisableParquetMemCache)
	}

	if v.DistinctCacheEvictionInterval != nil {
		ok := object.Key("distinctCacheEvictionInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.DistinctCacheEvictionInterval, ok); err != nil {
			return err
		}
	}

	if v.DistinctValueCacheDisableFromHistory != nil {
		ok := object.Key("distinctValueCacheDisableFromHistory")
		ok.Boolean(*v.DistinctValueCacheDisableFromHistory)
	}

	if v.ExecMemPoolBytes != nil {
		ok := object.Key("execMemPoolBytes")
		if err := awsAwsjson10_serializeDocumentPercentOrAbsoluteLong(v.ExecMemPoolBytes, ok); err != nil {
			return err
		}
	}

	if v.ForceSnapshotMemThreshold != nil {
		ok := object.Key("forceSnapshotMemThreshold")
		if err := awsAwsjson10_serializeDocumentPercentOrAbsoluteLong(v.ForceSnapshotMemThreshold, ok); err != nil {
			return err
		}
	}

	if v.Gen1Duration != nil {
		ok := object.Key("gen1Duration")
		if err := awsAwsjson10_serializeDocumentDuration(v.Gen1Duration, ok); err != nil {
			return err
		}
	}

	if v.Gen1LookbackDuration != nil {
		ok := object.Key("gen1LookbackDuration")
		if err := awsAwsjson10_serializeDocumentDuration(v.Gen1LookbackDuration, ok); err != nil {
			return err
		}
	}

	if v.HardDeleteDefaultDuration != nil {
		ok := object.Key("hardDeleteDefaultDuration")
		if err := awsAwsjson10_serializeDocumentDuration(v.HardDeleteDefaultDuration, ok); err != nil {
			return err
		}
	}

	if v.IngestQueryInstances != nil {
		ok := object.Key("ingestQueryInstances")
		ok.Integer(*v.IngestQueryInstances)
	}

	if v.LastCacheEvictionInterval != nil {
		ok := object.Key("lastCacheEvictionInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.LastCacheEvictionInterval, ok); err != nil {
			return err
		}
	}

	if v.LastValueCacheDisableFromHistory != nil {
		ok := object.Key("lastValueCacheDisableFromHistory")
		ok.Boolean(*v.LastValueCacheDisableFromHistory)
	}

	if v.LogFilter != nil {
		ok := object.Key("logFilter")
		ok.String(*v.LogFilter)
	}

	if len(v.LogFormat) > 0 {
		ok := object.Key("logFormat")
		ok.String(string(v.LogFormat))
	}

	if v.MaxHttpRequestSize != nil {
		ok := object.Key("maxHttpRequestSize")
		ok.Long(*v.MaxHttpRequestSize)
	}

	if v.ParquetMemCachePruneInterval != nil {
		ok := object.Key("parquetMemCachePruneInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.ParquetMemCachePruneInterval, ok); err != nil {
			return err
		}
	}

	if v.ParquetMemCachePrunePercentage != nil {
		ok := object.Key("parquetMemCachePrunePercentage")
		switch {
		case math.IsNaN(float64(*v.ParquetMemCachePrunePercentage)):
			ok.String("NaN")

		case math.IsInf(float64(*v.ParquetMemCachePrunePercentage), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.ParquetMemCachePrunePercentage), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.ParquetMemCachePrunePercentage)

		}
	}

	if v.ParquetMemCacheQueryPathDuration != nil {
		ok := object.Key("parquetMemCacheQueryPathDuration")
		if err := awsAwsjson10_serializeDocumentDuration(v.ParquetMemCacheQueryPathDuration, ok); err != nil {
			return err
		}
	}

	if v.ParquetMemCacheSize != nil {
		ok := object.Key("parquetMemCacheSize")
		if err := awsAwsjson10_serializeDocumentPercentOrAbsoluteLong(v.ParquetMemCacheSize, ok); err != nil {
			return err
		}
	}

	if v.PreemptiveCacheAge != nil {
		ok := object.Key("preemptiveCacheAge")
		if err := awsAwsjson10_serializeDocumentDuration(v.PreemptiveCacheAge, ok); err != nil {
			return err
		}
	}

	if v.QueryFileLimit != nil {
		ok := object.Key("queryFileLimit")
		ok.Integer(*v.QueryFileLimit)
	}

	if v.QueryLogSize != nil {
		ok := object.Key("queryLogSize")
		ok.Integer(*v.QueryLogSize)
	}

	if v.QueryOnlyInstances != nil {
		ok := object.Key("queryOnlyInstances")
		ok.Integer(*v.QueryOnlyInstances)
	}

	if v.ReplicationInterval != nil {
		ok := object.Key("replicationInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.ReplicationInterval, ok); err != nil {
			return err
		}
	}

	if v.RetentionCheckInterval != nil {
		ok := object.Key("retentionCheckInterval")
		if err := awsAwsjson10_serializeDocumentDuration(v.RetentionCheckInterval, ok); err != nil {
			return err
		}
	}

	if v.SnapshottedWalFilesToKeep != nil {
		ok := object.Key("snapshottedWalFilesToKeep")
		ok.Integer(*v.SnapshottedWalFilesToKeep)
	}

	if v.TableIndexCacheConcurrencyLimit != nil {
		ok := object.Key("tableIndexCacheConcurrencyLimit")
		ok.Integer(*v.TableIndexCacheConcurrencyLimit)
	}

	if v.TableIndexCacheMaxEntries != nil {
		ok := object.Key("tableIndexCacheMaxEntries")
		ok.Integer(*v.TableIndexCacheMaxEntries)
	}

	if v.WalMaxWriteBufferSize != nil {
		ok := object.Key("walMaxWriteBufferSize")
		ok.Integer(*v.WalMaxWriteBufferSize)
	}

	if v.WalReplayConcurrencyLimit != nil {
		ok := object.Key("walReplayConcurrencyLimit")
		ok.Integer(*v.WalReplayConcurrencyLimit)
	}

	if v.WalReplayFailOnError != nil {
		ok := object.Key("walReplayFailOnError")
		ok.Boolean(*v.WalReplayFailOnError)
	}

	if v.WalSnapshotSize != nil {
		ok := object.Key("walSnapshotSize")
		ok.Integer(*v.WalSnapshotSize)
	}

	return nil
}

func awsAwsjson10_serializeDocumentLogDeliveryConfiguration(v *types.LogDeliveryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Configuration != nil {
		ok := object.Key("s3Configuration")
		if err := awsAwsjson10_serializeDocumentS3Configuration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentParameters(v types.Parameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ParametersMemberInfluxDBv2:
		av := object.Key("InfluxDBv2")
		if err := awsAwsjson10_serializeDocumentInfluxDBv2Parameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.ParametersMemberInfluxDBv3Core:
		av := object.Key("InfluxDBv3Core")
		if err := awsAwsjson10_serializeDocumentInfluxDBv3CoreParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.ParametersMemberInfluxDBv3Enterprise:
		av := object.Key("InfluxDBv3Enterprise")
		if err := awsAwsjson10_serializeDocumentInfluxDBv3EnterpriseParameters(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentPercentOrAbsoluteLong(v types.PercentOrAbsoluteLong, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PercentOrAbsoluteLongMemberAbsolute:
		av := object.Key("absolute")
		av.Long(uv.Value)

	case *types.PercentOrAbsoluteLongMemberPercent:
		av := object.Key("percent")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentRequestTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson10_serializeDocumentS3Configuration(v *types.S3Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTagKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentVpcSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentVpcSubnetIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeOpDocumentCreateDbClusterInput(v *CreateDbClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedStorage != nil {
		ok := object.Key("allocatedStorage")
		ok.Integer(*v.AllocatedStorage)
	}

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if len(v.DbInstanceType) > 0 {
		ok := object.Key("dbInstanceType")
		ok.String(string(v.DbInstanceType))
	}

	if v.DbParameterGroupIdentifier != nil {
		ok := object.Key("dbParameterGroupIdentifier")
		ok.String(*v.DbParameterGroupIdentifier)
	}

	if len(v.DbStorageType) > 0 {
		ok := object.Key("dbStorageType")
		ok.String(string(v.DbStorageType))
	}

	if len(v.DeploymentType) > 0 {
		ok := object.Key("deploymentType")
		ok.String(string(v.DeploymentType))
	}

	if len(v.FailoverMode) > 0 {
		ok := object.Key("failoverMode")
		ok.String(string(v.FailoverMode))
	}

	if v.LogDeliveryConfiguration != nil {
		ok := object.Key("logDeliveryConfiguration")
		if err := awsAwsjson10_serializeDocumentLogDeliveryConfiguration(v.LogDeliveryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.NetworkType) > 0 {
		ok := object.Key("networkType")
		ok.String(string(v.NetworkType))
	}

	if v.Organization != nil {
		ok := object.Key("organization")
		ok.String(*v.Organization)
	}

	if v.Password != nil {
		ok := object.Key("password")
		ok.String(*v.Password)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if v.PubliclyAccessible != nil {
		ok := object.Key("publiclyAccessible")
		ok.Boolean(*v.PubliclyAccessible)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentRequestTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	if v.VpcSecurityGroupIds != nil {
		ok := object.Key("vpcSecurityGroupIds")
		if err := awsAwsjson10_serializeDocumentVpcSecurityGroupIdList(v.VpcSecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.VpcSubnetIds != nil {
		ok := object.Key("vpcSubnetIds")
		if err := awsAwsjson10_serializeDocumentVpcSubnetIdList(v.VpcSubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateDbInstanceInput(v *CreateDbInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedStorage != nil {
		ok := object.Key("allocatedStorage")
		ok.Integer(*v.AllocatedStorage)
	}

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if len(v.DbInstanceType) > 0 {
		ok := object.Key("dbInstanceType")
		ok.String(string(v.DbInstanceType))
	}

	if v.DbParameterGroupIdentifier != nil {
		ok := object.Key("dbParameterGroupIdentifier")
		ok.String(*v.DbParameterGroupIdentifier)
	}

	if len(v.DbStorageType) > 0 {
		ok := object.Key("dbStorageType")
		ok.String(string(v.DbStorageType))
	}

	if len(v.DeploymentType) > 0 {
		ok := object.Key("deploymentType")
		ok.String(string(v.DeploymentType))
	}

	if v.LogDeliveryConfiguration != nil {
		ok := object.Key("logDeliveryConfiguration")
		if err := awsAwsjson10_serializeDocumentLogDeliveryConfiguration(v.LogDeliveryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.NetworkType) > 0 {
		ok := object.Key("networkType")
		ok.String(string(v.NetworkType))
	}

	if v.Organization != nil {
		ok := object.Key("organization")
		ok.String(*v.Organization)
	}

	if v.Password != nil {
		ok := object.Key("password")
		ok.String(*v.Password)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if v.PubliclyAccessible != nil {
		ok := object.Key("publiclyAccessible")
		ok.Boolean(*v.PubliclyAccessible)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentRequestTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	if v.VpcSecurityGroupIds != nil {
		ok := object.Key("vpcSecurityGroupIds")
		if err := awsAwsjson10_serializeDocumentVpcSecurityGroupIdList(v.VpcSecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.VpcSubnetIds != nil {
		ok := object.Key("vpcSubnetIds")
		if err := awsAwsjson10_serializeDocumentVpcSubnetIdList(v.VpcSubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateDbParameterGroupInput(v *CreateDbParameterGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("parameters")
		if err := awsAwsjson10_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentRequestTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteDbClusterInput(v *DeleteDbClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DbClusterId != nil {
		ok := object.Key("dbClusterId")
		ok.String(*v.DbClusterId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteDbInstanceInput(v *DeleteDbInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetDbClusterInput(v *GetDbClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DbClusterId != nil {
		ok := object.Key("dbClusterId")
		ok.String(*v.DbClusterId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetDbInstanceInput(v *GetDbInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetDbParameterGroupInput(v *GetDbParameterGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListDbClustersInput(v *ListDbClustersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListDbInstancesForClusterInput(v *ListDbInstancesForClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DbClusterId != nil {
		ok := object.Key("dbClusterId")
		ok.String(*v.DbClusterId)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListDbInstancesInput(v *ListDbInstancesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListDbParameterGroupsInput(v *ListDbParameterGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentRequestTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsAwsjson10_serializeDocumentTagKeys(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateDbClusterInput(v *UpdateDbClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DbClusterId != nil {
		ok := object.Key("dbClusterId")
		ok.String(*v.DbClusterId)
	}

	if len(v.DbInstanceType) > 0 {
		ok := object.Key("dbInstanceType")
		ok.String(string(v.DbInstanceType))
	}

	if v.DbParameterGroupIdentifier != nil {
		ok := object.Key("dbParameterGroupIdentifier")
		ok.String(*v.DbParameterGroupIdentifier)
	}

	if len(v.FailoverMode) > 0 {
		ok := object.Key("failoverMode")
		ok.String(string(v.FailoverMode))
	}

	if v.LogDeliveryConfiguration != nil {
		ok := object.Key("logDeliveryConfiguration")
		if err := awsAwsjson10_serializeDocumentLogDeliveryConfiguration(v.LogDeliveryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateDbInstanceInput(v *UpdateDbInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedStorage != nil {
		ok := object.Key("allocatedStorage")
		ok.Integer(*v.AllocatedStorage)
	}

	if len(v.DbInstanceType) > 0 {
		ok := object.Key("dbInstanceType")
		ok.String(string(v.DbInstanceType))
	}

	if v.DbParameterGroupIdentifier != nil {
		ok := object.Key("dbParameterGroupIdentifier")
		ok.String(*v.DbParameterGroupIdentifier)
	}

	if len(v.DbStorageType) > 0 {
		ok := object.Key("dbStorageType")
		ok.String(string(v.DbStorageType))
	}

	if len(v.DeploymentType) > 0 {
		ok := object.Key("deploymentType")
		ok.String(string(v.DeploymentType))
	}

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	if v.LogDeliveryConfiguration != nil {
		ok := object.Key("logDeliveryConfiguration")
		if err := awsAwsjson10_serializeDocumentLogDeliveryConfiguration(v.LogDeliveryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	return nil
}
