// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Describes a summary of a Timestream for InfluxDB cluster.
type DbClusterSummary struct {

	// The Amazon Resource Name (ARN) of the DB cluster.
	//
	// This member is required.
	Arn *string

	// Service-generated unique identifier of the DB cluster to retrieve.
	//
	// This member is required.
	Id *string

	// Customer supplied name of the Timestream for InfluxDB cluster.
	//
	// This member is required.
	Name *string

	// The amount of storage allocated for your DB storage type (in gibibytes).
	AllocatedStorage *int32

	// The Timestream for InfluxDB DB instance type that InfluxDB runs on.
	DbInstanceType DbInstanceType

	// The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
	DbStorageType DbStorageType

	// Deployment type of the DB cluster
	DeploymentType ClusterDeploymentType

	// The endpoint used to connect to the Timestream for InfluxDB cluster for write
	// and read operations.
	Endpoint *string

	// The engine type of your DB cluster.
	EngineType EngineType

	// Specifies whether the network type of the Timestream for InfluxDB Cluster is
	// IPv4, which can communicate over IPv4 protocol only, or DUAL, which can
	// communicate over both IPv4 and IPv6 protocols.
	NetworkType NetworkType

	// The port number on which InfluxDB accepts connections.
	Port *int32

	// The endpoint used to connect to the Timestream for InfluxDB cluster for
	// read-only operations.
	ReaderEndpoint *string

	// The status of the DB cluster.
	Status ClusterStatus

	noSmithyDocumentSerde
}

// Contains a summary of a DB instance belonging to a DB cluster.
type DbInstanceForClusterSummary struct {

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// This member is required.
	Arn *string

	// The service-generated unique identifier of the DB instance.
	//
	// This member is required.
	Id *string

	// A service-generated name for the DB instance based on the customer-supplied
	// name for the DB cluster.
	//
	// This member is required.
	Name *string

	// The amount of storage allocated for your DB storage type in GiB (gibibytes).
	AllocatedStorage *int32

	// The Timestream for InfluxDB instance type to run InfluxDB on.
	DbInstanceType DbInstanceType

	// The storage type for your DB instance.
	DbStorageType DbStorageType

	// Specifies the deployment type if applicable.
	DeploymentType DeploymentType

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string

	// Specifies the DB instance's role in the cluster.
	InstanceMode InstanceMode

	// Specifies the DB instance's roles in the cluster.
	InstanceModes []InstanceMode

	// Specifies whether the network type of the Timestream for InfluxDB instance is
	// IPv4, which can communicate over IPv4 protocol only, or DUAL, which can
	// communicate over both IPv4 and IPv6 protocols.
	NetworkType NetworkType

	// The port number on which InfluxDB accepts connections.
	Port *int32

	// The status of the DB instance.
	Status Status

	noSmithyDocumentSerde
}

// Contains a summary of a DB instance.
type DbInstanceSummary struct {

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// This member is required.
	Arn *string

	// The service-generated unique identifier of the DB instance.
	//
	// This member is required.
	Id *string

	// This customer-supplied name uniquely identifies the DB instance when
	// interacting with the Amazon Timestream for InfluxDB API and CLI commands.
	//
	// This member is required.
	Name *string

	// The amount of storage to allocate for your DbStorageType in GiB (gibibytes).
	AllocatedStorage *int32

	// The Timestream for InfluxDB instance type to run InfluxDB on.
	DbInstanceType DbInstanceType

	// The storage type for your DB instance.
	DbStorageType DbStorageType

	// Single-Instance or with a MultiAZ Standby for High availability.
	DeploymentType DeploymentType

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string

	// Specifies whether the networkType of the Timestream for InfluxDB instance is
	// IPV4, which can communicate over IPv4 protocol only, or DUAL, which can
	// communicate over both IPv4 and IPv6 protocols.
	NetworkType NetworkType

	// The port number on which InfluxDB accepts connections.
	Port *int32

	// The status of the DB instance.
	Status Status

	noSmithyDocumentSerde
}

// Contains a summary of a DB parameter group.
type DbParameterGroupSummary struct {

	// The Amazon Resource Name (ARN) of the DB parameter group.
	//
	// This member is required.
	Arn *string

	// A service-generated unique identifier.
	//
	// This member is required.
	Id *string

	// This customer-supplied name uniquely identifies the parameter group.
	//
	// This member is required.
	Name *string

	// A description of the DB parameter group.
	Description *string

	noSmithyDocumentSerde
}

// Duration for InfluxDB parameters in Timestream for InfluxDB.
type Duration struct {

	// The type of duration for InfluxDB parameters.
	//
	// This member is required.
	DurationType DurationType

	// The value of duration for InfluxDB parameters.
	//
	// This member is required.
	Value *int64

	noSmithyDocumentSerde
}

// All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
type InfluxDBv2Parameters struct {

	// Include option to show detailed logs for Flux queries.
	//
	// Default: false
	FluxLogEnabled *bool

	// Maximum duration the server should keep established connections alive while
	// waiting for new requests. Set to 0 for no timeout.
	//
	// Default: 3 minutes
	HttpIdleTimeout *Duration

	// Maximum duration the server should try to read HTTP headers for new requests.
	// Set to 0 for no timeout.
	//
	// Default: 10 seconds
	HttpReadHeaderTimeout *Duration

	// Maximum duration the server should try to read the entirety of new requests.
	// Set to 0 for no timeout.
	//
	// Default: 0
	HttpReadTimeout *Duration

	// Maximum duration the server should spend processing and responding to write
	// requests. Set to 0 for no timeout.
	//
	// Default: 0
	HttpWriteTimeout *Duration

	// Maximum number of group by time buckets a SELECT statement can create. 0 allows
	// an unlimited number of buckets.
	//
	// Default: 0
	InfluxqlMaxSelectBuckets *int64

	// Maximum number of points a SELECT statement can process. 0 allows an unlimited
	// number of points. InfluxDB checks the point count every second (so queries
	// exceeding the maximum aren’t immediately aborted).
	//
	// Default: 0
	InfluxqlMaxSelectPoint *int64

	// Maximum number of series a SELECT statement can return. 0 allows an unlimited
	// number of series.
	//
	// Default: 0
	InfluxqlMaxSelectSeries *int64

	// Log output level. InfluxDB outputs log entries with severity levels greater
	// than or equal to the level specified.
	//
	// Default: info
	LogLevel LogLevel

	// Disable the HTTP /metrics endpoint which exposes [internal InfluxDB metrics].
	//
	// Default: false
	//
	// [internal InfluxDB metrics]: https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/
	MetricsDisabled *bool

	// Disable the task scheduler. If problematic tasks prevent InfluxDB from
	// starting, use this option to start InfluxDB without scheduling or executing
	// tasks.
	//
	// Default: false
	NoTasks *bool

	// Disable the /debug/pprof HTTP endpoint. This endpoint provides runtime
	// profiling data and can be helpful when debugging.
	//
	// Default: true
	PprofDisabled *bool

	// Number of queries allowed to execute concurrently. Setting to 0 allows an
	// unlimited number of concurrent queries.
	//
	// Default: 0
	QueryConcurrency *int32

	// Initial bytes of memory allocated for a query.
	//
	// Default: 0
	QueryInitialMemoryBytes *int64

	// Maximum number of queries allowed in execution queue. When queue limit is
	// reached, new queries are rejected. Setting to 0 allows an unlimited number of
	// queries in the queue.
	//
	// Default: 0
	QueryMaxMemoryBytes *int64

	// Maximum bytes of memory allowed for a single query. Must be greater or equal to
	// queryInitialMemoryBytes.
	//
	// Default: 0
	QueryMemoryBytes *int64

	// Maximum number of queries allowed in execution queue. When queue limit is
	// reached, new queries are rejected. Setting to 0 allows an unlimited number of
	// queries in the queue.
	//
	// Default: 0
	QueryQueueSize *int32

	// Specifies the Time to Live (TTL) in minutes for newly created user sessions.
	//
	// Default: 60
	SessionLength *int32

	// Disables automatically extending a user’s session TTL on each request. By
	// default, every request sets the session’s expiration time to five minutes from
	// now. When disabled, sessions expire after the specified [session length]and the user is
	// redirected to the login page, even if recently active.
	//
	// Default: false
	//
	// [session length]: https://docs.influxdata.com/influxdb/v2/reference/config-options/#session-length
	SessionRenewDisabled *bool

	// Maximum size (in bytes) a shard’s cache can reach before it starts rejecting
	// writes. Must be greater than storageCacheSnapShotMemorySize and lower than
	// instance’s total memory capacity. We recommend setting it to below 15% of the
	// total memory capacity.
	//
	// Default: 1073741824
	StorageCacheMaxMemorySize *int64

	// Size (in bytes) at which the storage engine will snapshot the cache and write
	// it to a TSM file to make more memory available. Must not be greater than
	// storageCacheMaxMemorySize.
	//
	// Default: 26214400
	StorageCacheSnapshotMemorySize *int64

	// Duration at which the storage engine will snapshot the cache and write it to a
	// new TSM file if the shard hasn’t received writes or deletes.
	//
	// Default: 10 minutes
	StorageCacheSnapshotWriteColdDuration *Duration

	// Duration at which the storage engine will compact all TSM files in a shard if
	// it hasn't received writes or deletes.
	//
	// Default: 4 hours
	StorageCompactFullWriteColdDuration *Duration

	// Rate limit (in bytes per second) that TSM compactions can write to disk.
	//
	// Default: 50331648
	StorageCompactThroughputBurst *int64

	// Maximum number of full and level compactions that can run concurrently. A value
	// of 0 results in 50% of runtime.GOMAXPROCS(0) used at runtime. Any number greater
	// than zero limits compactions to that value. This setting does not apply to cache
	// snapshotting.
	//
	// Default: 0
	StorageMaxConcurrentCompactions *int32

	// Size (in bytes) at which an index write-ahead log (WAL) file will compact into
	// an index file. Lower sizes will cause log files to be compacted more quickly and
	// result in lower heap usage at the expense of write throughput.
	//
	// Default: 1048576
	StorageMaxIndexLogFileSize *int64

	// Skip field size validation on incoming write requests.
	//
	// Default: false
	StorageNoValidateFieldSize *bool

	// Interval of retention policy enforcement checks. Must be greater than 0.
	//
	// Default: 30 minutes
	StorageRetentionCheckInterval *Duration

	// Maximum number of snapshot compactions that can run concurrently across all
	// series partitions in a database.
	//
	// Default: 0
	StorageSeriesFileMaxConcurrentSnapshotCompactions *int32

	// Size of the internal cache used in the TSI index to store previously calculated
	// series results. Cached results are returned quickly rather than needing to be
	// recalculated when a subsequent query with the same tag key/value predicate is
	// executed. Setting this value to 0 will disable the cache and may decrease query
	// performance.
	//
	// Default: 100
	StorageSeriesIdSetCacheSize *int64

	// Maximum number writes to the WAL directory to attempt at the same time. Setting
	// this value to 0 results in number of processing units available x2.
	//
	// Default: 0
	StorageWalMaxConcurrentWrites *int32

	// Maximum amount of time a write request to the WAL directory will wait when the [maximum number of concurrent active writes to the WAL directory has been met]
	// . Set to 0 to disable the timeout.
	//
	// Default: 10 minutes
	//
	// [maximum number of concurrent active writes to the WAL directory has been met]: https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes
	StorageWalMaxWriteDelay *Duration

	// Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled
	// by default.
	TracingType TracingType

	// Disable the InfluxDB user interface (UI). The UI is enabled by default.
	//
	// Default: false
	UiDisabled *bool

	noSmithyDocumentSerde
}

// All the customer-modifiable InfluxDB v3 Core parameters in Timestream for
// InfluxDB.
type InfluxDBv3CoreParameters struct {

	// Provides custom configuration to DataFusion as a comma-separated list of
	// key:value pairs.
	DataFusionConfig *string

	// When multiple parquet files are required in a sorted way (deduplication for
	// example), specifies the maximum fanout.
	//
	// Default: 1000
	DataFusionMaxParquetFanout *int32

	// Sets the maximum number of DataFusion runtime threads to use.
	DataFusionNumThreads *int32

	// Disables the LIFO slot of the DataFusion runtime.
	DataFusionRuntimeDisableLifoSlot *bool

	// Sets the number of scheduler ticks after which the scheduler of the DataFusion
	// tokio runtime polls for external events–for example: timers, I/O.
	DataFusionRuntimeEventInterval *int32

	// Sets the number of scheduler ticks after which the scheduler of the DataFusion
	// runtime polls the global task queue.
	DataFusionRuntimeGlobalQueueInterval *int32

	// Specifies the limit for additional threads spawned by the DataFusion runtime.
	DataFusionRuntimeMaxBlockingThreads *int32

	// Configures the maximum number of events processed per tick by the tokio
	// DataFusion runtime.
	DataFusionRuntimeMaxIoEventsPerTick *int32

	// Sets a custom timeout for a thread in the blocking pool of the tokio DataFusion
	// runtime.
	DataFusionRuntimeThreadKeepAlive *Duration

	// Sets the thread priority for tokio DataFusion runtime workers.
	//
	// Default: 10
	DataFusionRuntimeThreadPriority *int32

	// Specifies the DataFusion tokio runtime type.
	//
	// Default: multi-thread
	DataFusionRuntimeType DataFusionRuntimeType

	// Uses a cached parquet loader when reading parquet files from the object store.
	DataFusionUseCachedParquetLoader *bool

	// Specifies the grace period before permanently deleting data.
	//
	// Default: 24h
	DeleteGracePeriod *Duration

	// Disables the in-memory Parquet cache. By default, the cache is enabled.
	DisableParquetMemCache *bool

	// Specifies the interval to evict expired entries from the distinct value cache,
	// expressed as a human-readable duration–for example: 20s, 1m, 1h.
	//
	// Default: 10s
	DistinctCacheEvictionInterval *Duration

	// Specifies the size of memory pool used during query execution. Can be given as
	// absolute value in bytes or as a percentage of the total available memory–for
	// example: 8000000000 or 10%.
	//
	// Default: 20%
	ExecMemPoolBytes PercentOrAbsoluteLong

	// Specifies the threshold for the internal memory buffer. Supports either a
	// percentage (portion of available memory) or absolute value in MB–for example:
	// 70% or 100
	//
	// Default: 70%
	ForceSnapshotMemThreshold PercentOrAbsoluteLong

	// Specifies the duration that Parquet files are arranged into. Data timestamps
	// land each row into a file of this duration. Supported durations are 1m, 5m, and
	// 10m. These files are known as “generation 1” files that the compactor in
	// InfluxDB 3 Enterprise can merge into larger generations.
	//
	// Default: 10m
	Gen1Duration *Duration

	// Specifies how far back to look when creating generation 1 Parquet files.
	//
	// Default: 24h
	Gen1LookbackDuration *Duration

	// Sets the default duration for hard deletion of data.
	//
	// Default: 90d
	HardDeleteDefaultDuration *Duration

	// Specifies the interval to evict expired entries from the Last-N-Value cache,
	// expressed as a human-readable duration–for example: 20s, 1m, 1h.
	//
	// Default: 10s
	LastCacheEvictionInterval *Duration

	// Sets the filter directive for logs.
	LogFilter *string

	// Defines the message format for logs.
	//
	// Default: full
	LogFormat LogFormats

	// Specifies the maximum size of HTTP requests.
	//
	// Default: 10485760
	MaxHttpRequestSize *int64

	// Sets the interval to check if the in-memory Parquet cache needs to be pruned.
	//
	// Default: 1s
	ParquetMemCachePruneInterval *Duration

	// Specifies the percentage of entries to prune during a prune operation on the
	// in-memory Parquet cache.
	//
	// Default: 0.1
	ParquetMemCachePrunePercentage *float32

	// Specifies the time window for caching recent Parquet files in memory.
	//
	// Default: 5h
	ParquetMemCacheQueryPathDuration *Duration

	// Specifies the size of the in-memory Parquet cache in megabytes or percentage of
	// total available memory.
	//
	// Default: 20%
	ParquetMemCacheSize PercentOrAbsoluteLong

	// Specifies the interval to prefetch into the Parquet cache during compaction.
	//
	// Default: 3d
	PreemptiveCacheAge *Duration

	// Limits the number of Parquet files a query can access. If a query attempts to
	// read more than this limit, InfluxDB 3 returns an error.
	//
	// Default: 432
	QueryFileLimit *int32

	// Defines the size of the query log. Up to this many queries remain in the log
	// before older queries are evicted to make room for new ones.
	//
	// Default: 1000
	QueryLogSize *int32

	// The interval at which retention policies are checked and enforced. Enter as a
	// human-readable time–for example: 30m or 1h.
	//
	// Default: 30m
	RetentionCheckInterval *Duration

	// Specifies the number of snapshotted WAL files to retain in the object store.
	// Flushing the WAL files does not clear the WAL files immediately; they are
	// deleted when the number of snapshotted WAL files exceeds this number.
	//
	// Default: 300
	SnapshottedWalFilesToKeep *int32

	// Limits the concurrency level for table index cache operations.
	//
	// Default: 8
	TableIndexCacheConcurrencyLimit *int32

	// Specifies the maximum number of entries in the table index cache.
	//
	// Default: 1000
	TableIndexCacheMaxEntries *int32

	// Specifies the maximum number of write requests that can be buffered before a
	// flush must be executed and succeed.
	//
	// Default: 100000
	WalMaxWriteBufferSize *int32

	// Concurrency limit during WAL replay. Setting this number too high can lead to
	// OOM. The default is dynamically determined.
	//
	// Default: max(num_cpus, 10)
	WalReplayConcurrencyLimit *int32

	// Determines whether WAL replay should fail when encountering errors.
	//
	// Default: false
	WalReplayFailOnError *bool

	// Defines the number of WAL files to attempt to remove in a snapshot. This,
	// multiplied by the interval, determines how often snapshots are taken.
	//
	// Default: 600
	WalSnapshotSize *int32

	noSmithyDocumentSerde
}

// All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for
// InfluxDB.
type InfluxDBv3EnterpriseParameters struct {

	// Specifies if the compactor instance should be a standalone instance or not.
	//
	// This member is required.
	DedicatedCompactor *bool

	// Specifies number of instances in the DbCluster which can both ingest and query.
	//
	// This member is required.
	IngestQueryInstances *int32

	// Specifies number of instances in the DbCluster which can only query.
	//
	// This member is required.
	QueryOnlyInstances *int32

	// Defines how often the catalog synchronizes across cluster nodes.
	//
	// Default: 10s
	CatalogSyncInterval *Duration

	// Specifies how often the compactor checks for new compaction work to perform.
	//
	// Default: 10s
	CompactionCheckInterval *Duration

	// Specifies the amount of time that the compactor waits after finishing a
	// compaction run to delete files marked as needing deletion during that compaction
	// run.
	//
	// Default: 10m
	CompactionCleanupWait *Duration

	// Specifies the duration of the first level of compaction (gen2). Later levels of
	// compaction are multiples of this duration. This value should be equal to or
	// greater than the gen1 duration.
	//
	// Default: 20m
	CompactionGen2Duration *Duration

	// Sets the maximum number of files included in any compaction plan.
	//
	// Default: 500
	CompactionMaxNumFilesPerPlan *int32

	// Specifies a comma-separated list of multiples defining the duration of each
	// level of compaction. The number of elements in the list determines the number of
	// compaction levels. The first element specifies the duration of the first level
	// (gen3); subsequent levels are multiples of the previous level.
	//
	// Default: 3,4,6,5
	CompactionMultipliers *string

	// Specifies the soft limit for the number of rows per file that the compactor
	// writes. The compactor may write more rows than this limit.
	//
	// Default: 1000000
	CompactionRowLimit *int32

	// Provides custom configuration to DataFusion as a comma-separated list of
	// key:value pairs.
	DataFusionConfig *string

	// When multiple parquet files are required in a sorted way (deduplication for
	// example), specifies the maximum fanout.
	//
	// Default: 1000
	DataFusionMaxParquetFanout *int32

	// Sets the maximum number of DataFusion runtime threads to use.
	DataFusionNumThreads *int32

	// Disables the LIFO slot of the DataFusion runtime.
	DataFusionRuntimeDisableLifoSlot *bool

	// Sets the number of scheduler ticks after which the scheduler of the DataFusion
	// tokio runtime polls for external events–for example: timers, I/O.
	DataFusionRuntimeEventInterval *int32

	// Sets the number of scheduler ticks after which the scheduler of the DataFusion
	// runtime polls the global task queue.
	DataFusionRuntimeGlobalQueueInterval *int32

	// Specifies the limit for additional threads spawned by the DataFusion runtime.
	DataFusionRuntimeMaxBlockingThreads *int32

	// Configures the maximum number of events processed per tick by the tokio
	// DataFusion runtime.
	DataFusionRuntimeMaxIoEventsPerTick *int32

	// Sets a custom timeout for a thread in the blocking pool of the tokio DataFusion
	// runtime.
	DataFusionRuntimeThreadKeepAlive *Duration

	// Sets the thread priority for tokio DataFusion runtime workers.
	//
	// Default: 10
	DataFusionRuntimeThreadPriority *int32

	// Specifies the DataFusion tokio runtime type.
	//
	// Default: multi-thread
	DataFusionRuntimeType DataFusionRuntimeType

	// Uses a cached parquet loader when reading parquet files from the object store.
	DataFusionUseCachedParquetLoader *bool

	// Specifies the grace period before permanently deleting data.
	//
	// Default: 24h
	DeleteGracePeriod *Duration

	// Disables the in-memory Parquet cache. By default, the cache is enabled.
	DisableParquetMemCache *bool

	// Specifies the interval to evict expired entries from the distinct value cache,
	// expressed as a human-readable duration–for example: 20s, 1m, 1h.
	//
	// Default: 10s
	DistinctCacheEvictionInterval *Duration

	// Disables populating the distinct value cache from historical data. If disabled,
	// the cache is still populated with data from the write-ahead log (WAL).
	DistinctValueCacheDisableFromHistory *bool

	// Specifies the size of memory pool used during query execution. Can be given as
	// absolute value in bytes or as a percentage of the total available memory–for
	// example: 8000000000 or 10%.
	//
	// Default: 20%
	ExecMemPoolBytes PercentOrAbsoluteLong

	// Specifies the threshold for the internal memory buffer. Supports either a
	// percentage (portion of available memory) or absolute value in MB–for example:
	// 70% or 100
	//
	// Default: 70%
	ForceSnapshotMemThreshold PercentOrAbsoluteLong

	// Specifies the duration that Parquet files are arranged into. Data timestamps
	// land each row into a file of this duration. Supported durations are 1m, 5m, and
	// 10m. These files are known as “generation 1” files, which the compactor can
	// merge into larger generations.
	//
	// Default: 10m
	Gen1Duration *Duration

	// Specifies how far back to look when creating generation 1 Parquet files.
	//
	// Default: 24h
	Gen1LookbackDuration *Duration

	// Sets the default duration for hard deletion of data.
	//
	// Default: 90d
	HardDeleteDefaultDuration *Duration

	// Specifies the interval to evict expired entries from the Last-N-Value cache,
	// expressed as a human-readable duration–for example: 20s, 1m, 1h.
	//
	// Default: 10s
	LastCacheEvictionInterval *Duration

	// Disables populating the last-N-value cache from historical data. If disabled,
	// the cache is still populated with data from the write-ahead log (WAL).
	LastValueCacheDisableFromHistory *bool

	// Sets the filter directive for logs.
	LogFilter *string

	// Defines the message format for logs.
	//
	// Default: full
	LogFormat LogFormats

	// Specifies the maximum size of HTTP requests.
	//
	// Default: 10485760
	MaxHttpRequestSize *int64

	// Sets the interval to check if the in-memory Parquet cache needs to be pruned.
	//
	// Default: 1s
	ParquetMemCachePruneInterval *Duration

	// Specifies the percentage of entries to prune during a prune operation on the
	// in-memory Parquet cache.
	//
	// Default: 0.1
	ParquetMemCachePrunePercentage *float32

	// Specifies the time window for caching recent Parquet files in memory.
	//
	// Default: 5h
	ParquetMemCacheQueryPathDuration *Duration

	// Specifies the size of the in-memory Parquet cache in megabytes or percentage of
	// total available memory.
	//
	// Default: 20%
	ParquetMemCacheSize PercentOrAbsoluteLong

	// Specifies the interval to prefetch into the Parquet cache during compaction.
	//
	// Default: 3d
	PreemptiveCacheAge *Duration

	// Limits the number of Parquet files a query can access. If a query attempts to
	// read more than this limit, InfluxDB 3 returns an error.
	//
	// Default: 432
	QueryFileLimit *int32

	// Defines the size of the query log. Up to this many queries remain in the log
	// before older queries are evicted to make room for new ones.
	//
	// Default: 1000
	QueryLogSize *int32

	// Specifies the interval at which data replication occurs between cluster nodes.
	//
	// Default: 250ms
	ReplicationInterval *Duration

	// The interval at which retention policies are checked and enforced. Enter as a
	// human-readable time–for example: 30m or 1h.
	//
	// Default: 30m
	RetentionCheckInterval *Duration

	// Specifies the number of snapshotted WAL files to retain in the object store.
	// Flushing the WAL files does not clear the WAL files immediately; they are
	// deleted when the number of snapshotted WAL files exceeds this number.
	//
	// Default: 300
	SnapshottedWalFilesToKeep *int32

	// Limits the concurrency level for table index cache operations.
	//
	// Default: 8
	TableIndexCacheConcurrencyLimit *int32

	// Specifies the maximum number of entries in the table index cache.
	//
	// Default: 1000
	TableIndexCacheMaxEntries *int32

	// Specifies the maximum number of write requests that can be buffered before a
	// flush must be executed and succeed.
	//
	// Default: 100000
	WalMaxWriteBufferSize *int32

	// Concurrency limit during WAL replay. Setting this number too high can lead to
	// OOM. The default is dynamically determined.
	//
	// Default: max(num_cpus, 10)
	WalReplayConcurrencyLimit *int32

	// Determines whether WAL replay should fail when encountering errors.
	//
	// Default: false
	WalReplayFailOnError *bool

	// Defines the number of WAL files to attempt to remove in a snapshot. This,
	// multiplied by the interval, determines how often snapshots are taken.
	//
	// Default: 600
	WalSnapshotSize *int32

	noSmithyDocumentSerde
}

// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
type LogDeliveryConfiguration struct {

	// Configuration for S3 bucket log delivery.
	//
	// This member is required.
	S3Configuration *S3Configuration

	noSmithyDocumentSerde
}

// The parameters that comprise the parameter group.
//
// The following types satisfy this interface:
//
//	ParametersMemberInfluxDBv2
//	ParametersMemberInfluxDBv3Core
//	ParametersMemberInfluxDBv3Enterprise
type Parameters interface {
	isParameters()
}

// All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
type ParametersMemberInfluxDBv2 struct {
	Value InfluxDBv2Parameters

	noSmithyDocumentSerde
}

func (*ParametersMemberInfluxDBv2) isParameters() {}

// All the customer-modifiable InfluxDB v3 Core parameters in Timestream for
// InfluxDB.
type ParametersMemberInfluxDBv3Core struct {
	Value InfluxDBv3CoreParameters

	noSmithyDocumentSerde
}

func (*ParametersMemberInfluxDBv3Core) isParameters() {}

// All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for
// InfluxDB.
type ParametersMemberInfluxDBv3Enterprise struct {
	Value InfluxDBv3EnterpriseParameters

	noSmithyDocumentSerde
}

func (*ParametersMemberInfluxDBv3Enterprise) isParameters() {}

// Percent or Absolute Long for InfluxDB parameters
//
// The following types satisfy this interface:
//
//	PercentOrAbsoluteLongMemberAbsolute
//	PercentOrAbsoluteLongMemberPercent
type PercentOrAbsoluteLong interface {
	isPercentOrAbsoluteLong()
}

// Absolute long for InfluxDB parameters.
type PercentOrAbsoluteLongMemberAbsolute struct {
	Value int64

	noSmithyDocumentSerde
}

func (*PercentOrAbsoluteLongMemberAbsolute) isPercentOrAbsoluteLong() {}

// Percent for InfluxDB parameters.
type PercentOrAbsoluteLongMemberPercent struct {
	Value string

	noSmithyDocumentSerde
}

func (*PercentOrAbsoluteLongMemberPercent) isPercentOrAbsoluteLong() {}

// Configuration for S3 bucket log delivery.
type S3Configuration struct {

	// The name of the S3 bucket to deliver logs to.
	//
	// This member is required.
	BucketName *string

	// Indicates whether log delivery to the S3 bucket is enabled.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isParameters()            {}
func (*UnknownUnionMember) isPercentOrAbsoluteLong() {}
