// Code generated by smithy-go-codegen DO NOT EDIT.

package timestreaminfluxdb

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateDbCluster struct {
}

func (*validateOpCreateDbCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDbCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDbClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDbClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDbInstance struct {
}

func (*validateOpCreateDbInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDbInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDbInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDbInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDbParameterGroup struct {
}

func (*validateOpCreateDbParameterGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDbParameterGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDbParameterGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDbParameterGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDbCluster struct {
}

func (*validateOpDeleteDbCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDbCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDbClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDbClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDbInstance struct {
}

func (*validateOpDeleteDbInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDbInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDbInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDbInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDbCluster struct {
}

func (*validateOpGetDbCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDbCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDbClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDbClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDbInstance struct {
}

func (*validateOpGetDbInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDbInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDbInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDbInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDbParameterGroup struct {
}

func (*validateOpGetDbParameterGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDbParameterGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDbParameterGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDbParameterGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDbInstancesForCluster struct {
}

func (*validateOpListDbInstancesForCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDbInstancesForCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDbInstancesForClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDbInstancesForClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDbCluster struct {
}

func (*validateOpUpdateDbCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDbCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDbClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDbClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDbInstance struct {
}

func (*validateOpUpdateDbInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDbInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDbInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDbInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateDbClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDbCluster{}, middleware.After)
}

func addOpCreateDbInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDbInstance{}, middleware.After)
}

func addOpCreateDbParameterGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDbParameterGroup{}, middleware.After)
}

func addOpDeleteDbClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDbCluster{}, middleware.After)
}

func addOpDeleteDbInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDbInstance{}, middleware.After)
}

func addOpGetDbClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDbCluster{}, middleware.After)
}

func addOpGetDbInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDbInstance{}, middleware.After)
}

func addOpGetDbParameterGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDbParameterGroup{}, middleware.After)
}

func addOpListDbInstancesForClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDbInstancesForCluster{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateDbClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDbCluster{}, middleware.After)
}

func addOpUpdateDbInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDbInstance{}, middleware.After)
}

func validateDuration(v *types.Duration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Duration"}
	if len(v.DurationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DurationType"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInfluxDBv2Parameters(v *types.InfluxDBv2Parameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InfluxDBv2Parameters"}
	if v.HttpIdleTimeout != nil {
		if err := validateDuration(v.HttpIdleTimeout); err != nil {
			invalidParams.AddNested("HttpIdleTimeout", err.(smithy.InvalidParamsError))
		}
	}
	if v.HttpReadHeaderTimeout != nil {
		if err := validateDuration(v.HttpReadHeaderTimeout); err != nil {
			invalidParams.AddNested("HttpReadHeaderTimeout", err.(smithy.InvalidParamsError))
		}
	}
	if v.HttpReadTimeout != nil {
		if err := validateDuration(v.HttpReadTimeout); err != nil {
			invalidParams.AddNested("HttpReadTimeout", err.(smithy.InvalidParamsError))
		}
	}
	if v.HttpWriteTimeout != nil {
		if err := validateDuration(v.HttpWriteTimeout); err != nil {
			invalidParams.AddNested("HttpWriteTimeout", err.(smithy.InvalidParamsError))
		}
	}
	if v.StorageCacheSnapshotWriteColdDuration != nil {
		if err := validateDuration(v.StorageCacheSnapshotWriteColdDuration); err != nil {
			invalidParams.AddNested("StorageCacheSnapshotWriteColdDuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.StorageCompactFullWriteColdDuration != nil {
		if err := validateDuration(v.StorageCompactFullWriteColdDuration); err != nil {
			invalidParams.AddNested("StorageCompactFullWriteColdDuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.StorageRetentionCheckInterval != nil {
		if err := validateDuration(v.StorageRetentionCheckInterval); err != nil {
			invalidParams.AddNested("StorageRetentionCheckInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.StorageWalMaxWriteDelay != nil {
		if err := validateDuration(v.StorageWalMaxWriteDelay); err != nil {
			invalidParams.AddNested("StorageWalMaxWriteDelay", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInfluxDBv3CoreParameters(v *types.InfluxDBv3CoreParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InfluxDBv3CoreParameters"}
	if v.DataFusionRuntimeThreadKeepAlive != nil {
		if err := validateDuration(v.DataFusionRuntimeThreadKeepAlive); err != nil {
			invalidParams.AddNested("DataFusionRuntimeThreadKeepAlive", err.(smithy.InvalidParamsError))
		}
	}
	if v.PreemptiveCacheAge != nil {
		if err := validateDuration(v.PreemptiveCacheAge); err != nil {
			invalidParams.AddNested("PreemptiveCacheAge", err.(smithy.InvalidParamsError))
		}
	}
	if v.ParquetMemCachePruneInterval != nil {
		if err := validateDuration(v.ParquetMemCachePruneInterval); err != nil {
			invalidParams.AddNested("ParquetMemCachePruneInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.ParquetMemCacheQueryPathDuration != nil {
		if err := validateDuration(v.ParquetMemCacheQueryPathDuration); err != nil {
			invalidParams.AddNested("ParquetMemCacheQueryPathDuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.LastCacheEvictionInterval != nil {
		if err := validateDuration(v.LastCacheEvictionInterval); err != nil {
			invalidParams.AddNested("LastCacheEvictionInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.DistinctCacheEvictionInterval != nil {
		if err := validateDuration(v.DistinctCacheEvictionInterval); err != nil {
			invalidParams.AddNested("DistinctCacheEvictionInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.Gen1Duration != nil {
		if err := validateDuration(v.Gen1Duration); err != nil {
			invalidParams.AddNested("Gen1Duration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Gen1LookbackDuration != nil {
		if err := validateDuration(v.Gen1LookbackDuration); err != nil {
			invalidParams.AddNested("Gen1LookbackDuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetentionCheckInterval != nil {
		if err := validateDuration(v.RetentionCheckInterval); err != nil {
			invalidParams.AddNested("RetentionCheckInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.DeleteGracePeriod != nil {
		if err := validateDuration(v.DeleteGracePeriod); err != nil {
			invalidParams.AddNested("DeleteGracePeriod", err.(smithy.InvalidParamsError))
		}
	}
	if v.HardDeleteDefaultDuration != nil {
		if err := validateDuration(v.HardDeleteDefaultDuration); err != nil {
			invalidParams.AddNested("HardDeleteDefaultDuration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInfluxDBv3EnterpriseParameters(v *types.InfluxDBv3EnterpriseParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InfluxDBv3EnterpriseParameters"}
	if v.DataFusionRuntimeThreadKeepAlive != nil {
		if err := validateDuration(v.DataFusionRuntimeThreadKeepAlive); err != nil {
			invalidParams.AddNested("DataFusionRuntimeThreadKeepAlive", err.(smithy.InvalidParamsError))
		}
	}
	if v.PreemptiveCacheAge != nil {
		if err := validateDuration(v.PreemptiveCacheAge); err != nil {
			invalidParams.AddNested("PreemptiveCacheAge", err.(smithy.InvalidParamsError))
		}
	}
	if v.ParquetMemCachePruneInterval != nil {
		if err := validateDuration(v.ParquetMemCachePruneInterval); err != nil {
			invalidParams.AddNested("ParquetMemCachePruneInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.ParquetMemCacheQueryPathDuration != nil {
		if err := validateDuration(v.ParquetMemCacheQueryPathDuration); err != nil {
			invalidParams.AddNested("ParquetMemCacheQueryPathDuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.LastCacheEvictionInterval != nil {
		if err := validateDuration(v.LastCacheEvictionInterval); err != nil {
			invalidParams.AddNested("LastCacheEvictionInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.DistinctCacheEvictionInterval != nil {
		if err := validateDuration(v.DistinctCacheEvictionInterval); err != nil {
			invalidParams.AddNested("DistinctCacheEvictionInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.Gen1Duration != nil {
		if err := validateDuration(v.Gen1Duration); err != nil {
			invalidParams.AddNested("Gen1Duration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Gen1LookbackDuration != nil {
		if err := validateDuration(v.Gen1LookbackDuration); err != nil {
			invalidParams.AddNested("Gen1LookbackDuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetentionCheckInterval != nil {
		if err := validateDuration(v.RetentionCheckInterval); err != nil {
			invalidParams.AddNested("RetentionCheckInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.DeleteGracePeriod != nil {
		if err := validateDuration(v.DeleteGracePeriod); err != nil {
			invalidParams.AddNested("DeleteGracePeriod", err.(smithy.InvalidParamsError))
		}
	}
	if v.HardDeleteDefaultDuration != nil {
		if err := validateDuration(v.HardDeleteDefaultDuration); err != nil {
			invalidParams.AddNested("HardDeleteDefaultDuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.IngestQueryInstances == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestQueryInstances"))
	}
	if v.QueryOnlyInstances == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryOnlyInstances"))
	}
	if v.DedicatedCompactor == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DedicatedCompactor"))
	}
	if v.CompactionGen2Duration != nil {
		if err := validateDuration(v.CompactionGen2Duration); err != nil {
			invalidParams.AddNested("CompactionGen2Duration", err.(smithy.InvalidParamsError))
		}
	}
	if v.CompactionCleanupWait != nil {
		if err := validateDuration(v.CompactionCleanupWait); err != nil {
			invalidParams.AddNested("CompactionCleanupWait", err.(smithy.InvalidParamsError))
		}
	}
	if v.CompactionCheckInterval != nil {
		if err := validateDuration(v.CompactionCheckInterval); err != nil {
			invalidParams.AddNested("CompactionCheckInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.ReplicationInterval != nil {
		if err := validateDuration(v.ReplicationInterval); err != nil {
			invalidParams.AddNested("ReplicationInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.CatalogSyncInterval != nil {
		if err := validateDuration(v.CatalogSyncInterval); err != nil {
			invalidParams.AddNested("CatalogSyncInterval", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLogDeliveryConfiguration(v *types.LogDeliveryConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LogDeliveryConfiguration"}
	if v.S3Configuration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Configuration"))
	} else if v.S3Configuration != nil {
		if err := validateS3Configuration(v.S3Configuration); err != nil {
			invalidParams.AddNested("S3Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateParameters(v types.Parameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Parameters"}
	switch uv := v.(type) {
	case *types.ParametersMemberInfluxDBv2:
		if err := validateInfluxDBv2Parameters(&uv.Value); err != nil {
			invalidParams.AddNested("[InfluxDBv2]", err.(smithy.InvalidParamsError))
		}

	case *types.ParametersMemberInfluxDBv3Core:
		if err := validateInfluxDBv3CoreParameters(&uv.Value); err != nil {
			invalidParams.AddNested("[InfluxDBv3Core]", err.(smithy.InvalidParamsError))
		}

	case *types.ParametersMemberInfluxDBv3Enterprise:
		if err := validateInfluxDBv3EnterpriseParameters(&uv.Value); err != nil {
			invalidParams.AddNested("[InfluxDBv3Enterprise]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Configuration(v *types.S3Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Configuration"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if v.Enabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Enabled"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDbClusterInput(v *CreateDbClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDbClusterInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.DbInstanceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DbInstanceType"))
	}
	if v.VpcSubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcSubnetIds"))
	}
	if v.VpcSecurityGroupIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcSecurityGroupIds"))
	}
	if v.LogDeliveryConfiguration != nil {
		if err := validateLogDeliveryConfiguration(v.LogDeliveryConfiguration); err != nil {
			invalidParams.AddNested("LogDeliveryConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDbInstanceInput(v *CreateDbInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDbInstanceInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Password == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Password"))
	}
	if len(v.DbInstanceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DbInstanceType"))
	}
	if v.VpcSubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcSubnetIds"))
	}
	if v.VpcSecurityGroupIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcSecurityGroupIds"))
	}
	if v.AllocatedStorage == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AllocatedStorage"))
	}
	if v.LogDeliveryConfiguration != nil {
		if err := validateLogDeliveryConfiguration(v.LogDeliveryConfiguration); err != nil {
			invalidParams.AddNested("LogDeliveryConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDbParameterGroupInput(v *CreateDbParameterGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDbParameterGroupInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Parameters != nil {
		if err := validateParameters(v.Parameters); err != nil {
			invalidParams.AddNested("Parameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDbClusterInput(v *DeleteDbClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDbClusterInput"}
	if v.DbClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DbClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDbInstanceInput(v *DeleteDbInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDbInstanceInput"}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDbClusterInput(v *GetDbClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDbClusterInput"}
	if v.DbClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DbClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDbInstanceInput(v *GetDbInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDbInstanceInput"}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDbParameterGroupInput(v *GetDbParameterGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDbParameterGroupInput"}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDbInstancesForClusterInput(v *ListDbInstancesForClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDbInstancesForClusterInput"}
	if v.DbClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DbClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDbClusterInput(v *UpdateDbClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDbClusterInput"}
	if v.DbClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DbClusterId"))
	}
	if v.LogDeliveryConfiguration != nil {
		if err := validateLogDeliveryConfiguration(v.LogDeliveryConfiguration); err != nil {
			invalidParams.AddNested("LogDeliveryConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDbInstanceInput(v *UpdateDbInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDbInstanceInput"}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.LogDeliveryConfiguration != nil {
		if err := validateLogDeliveryConfiguration(v.LogDeliveryConfiguration); err != nil {
			invalidParams.AddNested("LogDeliveryConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
