// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the resource configurations owned by or shared with this account.
func (c *Client) ListResourceConfigurations(ctx context.Context, params *ListResourceConfigurationsInput, optFns ...func(*Options)) (*ListResourceConfigurationsOutput, error) {
	if params == nil {
		params = &ListResourceConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceConfigurations", params, optFns, c.addOperationListResourceConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourceConfigurationsInput struct {

	//  The domain verification ID.
	DomainVerificationIdentifier *string

	// The maximum page size.
	MaxResults *int32

	// A pagination token for the next page of results.
	NextToken *string

	// The ID of the resource configuration of type Group .
	ResourceConfigurationGroupIdentifier *string

	// The ID of the resource gateway for the resource configuration.
	ResourceGatewayIdentifier *string

	noSmithyDocumentSerde
}

type ListResourceConfigurationsOutput struct {

	// Information about the resource configurations.
	Items []types.ResourceConfigurationSummary

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListResourceConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListResourceConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListResourceConfigurationsPaginatorOptions is the paginator options for
// ListResourceConfigurations
type ListResourceConfigurationsPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceConfigurationsPaginator is a paginator for
// ListResourceConfigurations
type ListResourceConfigurationsPaginator struct {
	options   ListResourceConfigurationsPaginatorOptions
	client    ListResourceConfigurationsAPIClient
	params    *ListResourceConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListResourceConfigurationsPaginator returns a new
// ListResourceConfigurationsPaginator
func NewListResourceConfigurationsPaginator(client ListResourceConfigurationsAPIClient, params *ListResourceConfigurationsInput, optFns ...func(*ListResourceConfigurationsPaginatorOptions)) *ListResourceConfigurationsPaginator {
	if params == nil {
		params = &ListResourceConfigurationsInput{}
	}

	options := ListResourceConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceConfigurations page.
func (p *ListResourceConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourceConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourceConfigurationsAPIClient is a client that implements the
// ListResourceConfigurations operation.
type ListResourceConfigurationsAPIClient interface {
	ListResourceConfigurations(context.Context, *ListResourceConfigurationsInput, ...func(*Options)) (*ListResourceConfigurationsOutput, error)
}

var _ ListResourceConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourceConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceConfigurations",
	}
}
